/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.function.DoubleFunction;
import cml.kickass.function.DoubleX3Function;
import cml.kickass.function.Function;
import cml.kickass.function.VoidFunction;
import cml.kickass.libraries.Library;
import cml.kickass.values.MatrixValue;
import cml.kickass.values.Value;
import cml.kickass.values.VectorValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorLibrary
implements Library {
    public List<Constant> getConstants() {
        return new ArrayList<Constant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.add(new VoidFunction("Vector", (Value)VectorValue.invalid){

            protected Value f() {
                return new VectorValue(0.0, 0.0, 0.0);
            }
        });
        functions.add(new DoubleX3Function("Vector", (Value)VectorValue.invalid){

            protected Value f(double a, double b, double c) {
                return new VectorValue(a, b, c);
            }
        });
        functions.add(new VoidFunction("Matrix", (Value)MatrixValue.invalid){

            protected Value f() {
                return new MatrixValue(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
            }
        });
        functions.add(new DoubleX3Function("RotationMatrix", (Value)MatrixValue.invalid){

            protected Value f(double vX, double vY, double vZ) {
                double cX = Math.cos(vX);
                double sX = Math.sin(vX);
                double cY = Math.cos(vY);
                double sY = Math.sin(vY);
                double cZ = Math.cos(vZ);
                double sZ = Math.sin(vZ);
                double[][] entries = new double[][]{{cZ * cY, cZ * sY * sX - sZ * cX, cZ * sY * cX + sZ * sX, 0.0}, {sZ * cY, sZ * sY * sX + cZ * cX, sZ * sY * cX - cZ * sX, 0.0}, {-sY, cY * sX, cY * cX, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(entries);
            }
        });
        functions.add(new DoubleX3Function("ScaleMatrix", (Value)MatrixValue.invalid){

            protected Value f(double rX, double rY, double rZ) {
                double[][] entries = new double[][]{{rX, 0.0, 0.0, 0.0}, {0.0, rY, 0.0, 0.0}, {0.0, 0.0, rZ, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(entries);
            }
        });
        functions.add(new DoubleX3Function("MoveMatrix", (Value)MatrixValue.invalid){

            protected Value f(double mX, double mY, double mZ) {
                double[][] entries = new double[][]{{1.0, 0.0, 0.0, mX}, {0.0, 1.0, 0.0, mY}, {0.0, 0.0, 1.0, mZ}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(entries);
            }
        });
        functions.add(new DoubleFunction("PerspectiveMatrix", (Value)MatrixValue.invalid){

            protected Value f(double zPlane) {
                double[][] entries = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0 / zPlane, 0.0}};
                return new MatrixValue(entries);
            }
        });
        return functions;
    }
}

