/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.exceptions.AsmError;
import cml.kickass.misc.MemoryBlock;
import cml.log.Log;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C64File {
    private static Log log = new Log("");
    private static boolean allowOverlappingMemoryBlocks = false;
    byte[] startAddress = new byte[2];
    byte[] data;

    public static void allowOverlappingMemoryBlocks(boolean bool) {
        allowOverlappingMemoryBlocks = bool;
    }

    public C64File(List<MemoryBlock> globalMemoryBlocks) throws AsmError {
        ArrayList<MemoryBlock> memoryBlocks = new ArrayList<MemoryBlock>();
        for (MemoryBlock memoryBlock : globalMemoryBlocks) {
            if (memoryBlock.isVirtual()) continue;
            memoryBlocks.add(memoryBlock);
        }
        if (memoryBlocks.isEmpty()) {
            this.startAddress[0] = 0;
            this.startAddress[1] = 32;
            System.out.println("WARNING! No data in memory!");
            this.data = new byte[0];
            return;
        }
        Comparator<MemoryBlock> comp = new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock mb1, MemoryBlock mb2) {
                int a2;
                int a1 = mb1.getStartAdress();
                if (a1 < (a2 = mb2.getStartAdress())) {
                    return -1;
                }
                if (a1 == a2) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(memoryBlocks, comp);
        MemoryBlock firstBlock = (MemoryBlock)memoryBlocks.get(0);
        int startAddress = firstBlock.getStartAdress();
        int endAddress = startAddress + firstBlock.getSize();
        int i = 1;
        while (i < memoryBlocks.size()) {
            int endAddress2;
            MemoryBlock mb = (MemoryBlock)memoryBlocks.get(i);
            if (mb.getStartAdress() < endAddress) {
                String errorText = "Memoryblock starting at $" + Integer.toHexString(mb.getStartAdress()) + " overlaps the previous block";
                if (allowOverlappingMemoryBlocks) {
                    log.warn("Warning: " + errorText);
                } else {
                    throw new AsmError("Error: " + errorText, null);
                }
            }
            if ((endAddress2 = mb.getStartAdress() + mb.getSize()) > endAddress) {
                endAddress = endAddress2;
            }
            ++i;
        }
        this.startAddress[0] = (byte)(startAddress & 0xFF);
        this.startAddress[1] = (byte)((startAddress & 0xFF00) >> 8);
        this.data = new byte[endAddress - startAddress];
        for (MemoryBlock mb : memoryBlocks) {
            int offset = mb.getStartAdress() - startAddress;
            byte[] mbdata = mb.getMemory();
            int j = 0;
            while (j < mb.getSize()) {
                this.data[offset + j] = mbdata[j];
                ++j;
            }
        }
    }

    public boolean writeFile(String filename) {
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            fout.write(this.startAddress);
            fout.write(this.data);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

