/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;

public class MemoryBlock {
    private String name;
    private int startAdress;
    private boolean virtual;
    private int currentAdress = 0;
    private byte[] memory;

    public MemoryBlock(int startAdress, String name, boolean virtual) {
        this.startAdress = startAdress;
        this.name = name == null ? "unnamed" : name;
        this.virtual = virtual;
        this.memory = virtual ? null : new byte[65535];
    }

    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void addByte(byte b, DebugInfo debug) throws AsmError {
        if (this.startAdress + this.currentAdress > 65535) {
            throw new AsmError("ERROR! Memory overflow. Memory exceeds the $ffff limit!", debug);
        }
        if (!this.virtual) {
            this.memory[this.startAdress + this.currentAdress] = b;
        }
        ++this.currentAdress;
    }

    public void addBytes(byte[] bytes, DebugInfo debug) throws AsmError {
        int i = 0;
        while (i < bytes.length) {
            this.addByte(bytes[i], debug);
            ++i;
        }
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public int getSize() {
        return this.currentAdress;
    }

    public byte[] getMemory() {
        byte[] res = new byte[this.currentAdress];
        int i = 0;
        while (i < res.length) {
            res[i] = this.memory[this.startAdress + i];
            ++i;
        }
        return res;
    }

    public boolean contentEquals(MemoryBlock b2) {
        boolean parametersMatch;
        boolean bl = parametersMatch = this.name.equals(b2.name) && this.startAdress == b2.startAdress && this.currentAdress == b2.currentAdress && this.virtual == b2.virtual;
        if (!parametersMatch) {
            return false;
        }
        byte[] mem1 = this.getMemory();
        byte[] mem2 = b2.getMemory();
        int i = 0;
        while (i < mem1.length) {
            if (mem1[i] != mem2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

