/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.constant.Constant;
import cml.kickass.misc.ArgTypes;
import cml.kickass.values.NumberValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MnemonicTable {
    private static HashMap<String, int[]> mnemonics = new HashMap();
    private static Object[] mnemonicsData;

    static {
        Object[] objectArray = new Object[79];
        objectArray[0] = new Object[]{"ora", new int[]{-1, 9, 5, 21, -1, 1, 17, 13, 29, 25, -1, -1}};
        objectArray[1] = new Object[]{"and", new int[]{-1, 41, 37, 53, -1, 33, 49, 45, 61, 57, -1, -1}};
        objectArray[2] = new Object[]{"eor", new int[]{-1, 73, 69, 85, -1, 65, 81, 77, 93, 89, -1, -1}};
        objectArray[3] = new Object[]{"adc", new int[]{-1, 105, 101, 117, -1, 97, 113, 109, 125, 121, -1, -1}};
        objectArray[4] = new Object[]{"sbc", new int[]{-1, 233, 229, 245, -1, 225, 241, 237, 253, 249, -1, -1}};
        objectArray[5] = new Object[]{"cmp", new int[]{-1, 201, 197, 213, -1, 193, 209, 205, 221, 217, -1, -1}};
        objectArray[6] = new Object[]{"cpx", new int[]{-1, 224, 228, -1, -1, -1, -1, 236, -1, -1, -1, -1}};
        objectArray[7] = new Object[]{"cpy", new int[]{-1, 192, 196, -1, -1, -1, -1, 204, -1, -1, -1, -1}};
        objectArray[8] = new Object[]{"dec", new int[]{-1, -1, 198, 214, -1, -1, -1, 206, 222, -1, -1, -1}};
        objectArray[9] = new Object[]{"dex", new int[]{202, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[10] = new Object[]{"dey", new int[]{136, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[11] = new Object[]{"inc", new int[]{-1, -1, 230, 246, -1, -1, -1, 238, 254, -1, -1, -1}};
        objectArray[12] = new Object[]{"inx", new int[]{232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[13] = new Object[]{"iny", new int[]{200, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[14] = new Object[]{"asl", new int[]{10, -1, 6, 22, -1, -1, -1, 14, 30, -1, -1, -1}};
        objectArray[15] = new Object[]{"rol", new int[]{42, -1, 38, 54, -1, -1, -1, 46, 62, -1, -1, -1}};
        objectArray[16] = new Object[]{"lsr", new int[]{74, -1, 70, 86, -1, -1, -1, 78, 94, -1, -1, -1}};
        objectArray[17] = new Object[]{"ror", new int[]{106, -1, 102, 118, -1, -1, -1, 110, 126, -1, -1, -1}};
        objectArray[18] = new Object[]{"lda", new int[]{-1, 169, 165, 181, -1, 161, 177, 173, 189, 185, -1, -1}};
        objectArray[19] = new Object[]{"sta", new int[]{-1, -1, 133, 149, -1, 129, 145, 141, 157, 153, -1, -1}};
        objectArray[20] = new Object[]{"ldx", new int[]{-1, 162, 166, -1, 182, -1, -1, 174, -1, 190, -1, -1}};
        objectArray[21] = new Object[]{"stx", new int[]{-1, -1, 134, -1, 150, -1, -1, 142, -1, -1, -1, -1}};
        objectArray[22] = new Object[]{"ldy", new int[]{-1, 160, 164, 180, -1, -1, -1, 172, 188, -1, -1, -1}};
        objectArray[23] = new Object[]{"sty", new int[]{-1, -1, 132, 148, -1, -1, -1, 140, -1, -1, -1, -1}};
        objectArray[24] = new Object[]{"tax", new int[]{170, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[25] = new Object[]{"txa", new int[]{138, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[26] = new Object[]{"tay", new int[]{168, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[27] = new Object[]{"tya", new int[]{152, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[28] = new Object[]{"tsx", new int[]{186, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[29] = new Object[]{"txs", new int[]{154, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[30] = new Object[]{"pla", new int[]{104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[31] = new Object[]{"pha", new int[]{72, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[32] = new Object[]{"plp", new int[]{40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[33] = new Object[]{"php", new int[]{8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[34] = new Object[]{"bpl", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16}};
        objectArray[35] = new Object[]{"bmi", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48}};
        objectArray[36] = new Object[]{"bvc", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80}};
        objectArray[37] = new Object[]{"bvs", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 112}};
        objectArray[38] = new Object[]{"bcc", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 144}};
        objectArray[39] = new Object[]{"bcs", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 176}};
        objectArray[40] = new Object[]{"bne", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 208}};
        objectArray[41] = new Object[]{"beq", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 240}};
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "brk";
        int[] nArray = new int[12];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        objectArray2[1] = nArray;
        objectArray[42] = objectArray2;
        objectArray[43] = new Object[]{"rti", new int[]{64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[44] = new Object[]{"jsr", new int[]{-1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1}};
        objectArray[45] = new Object[]{"rts", new int[]{96, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[46] = new Object[]{"jmp", new int[]{-1, -1, -1, -1, -1, -1, -1, 76, -1, -1, 108, -1}};
        objectArray[47] = new Object[]{"bit", new int[]{-1, -1, 36, 52, -1, -1, -1, 44, 60, -1, -1, -1}};
        objectArray[48] = new Object[]{"clc", new int[]{24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[49] = new Object[]{"sec", new int[]{56, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[50] = new Object[]{"cld", new int[]{216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[51] = new Object[]{"sed", new int[]{248, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[52] = new Object[]{"cli", new int[]{88, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[53] = new Object[]{"sei", new int[]{120, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[54] = new Object[]{"clv", new int[]{184, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[55] = new Object[]{"nop", new int[]{234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[56] = new Object[]{"slo", new int[]{-1, -1, 7, 23, -1, 3, 19, 15, 31, 27, -1, -1}};
        objectArray[57] = new Object[]{"rla", new int[]{-1, -1, 39, 55, -1, 35, 51, 47, 63, 59, -1, -1}};
        objectArray[58] = new Object[]{"sre", new int[]{-1, -1, 71, 87, -1, 67, 83, 79, 95, 91, -1, -1}};
        objectArray[59] = new Object[]{"rra", new int[]{-1, -1, 103, 119, -1, 99, 115, 111, 127, 123, -1, -1}};
        objectArray[60] = new Object[]{"sax", new int[]{-1, -1, 135, -1, 151, 131, -1, 143, -1, -1, -1, -1}};
        objectArray[61] = new Object[]{"lax", new int[]{-1, 171, 167, -1, 183, 163, 179, 175, -1, 191, -1, -1}};
        objectArray[62] = new Object[]{"dcp", new int[]{-1, -1, 199, 215, -1, 195, 211, 207, 223, 219, -1, -1}};
        objectArray[63] = new Object[]{"isc", new int[]{-1, -1, 231, 247, -1, 227, 243, 239, 255, 251, -1, -1}};
        objectArray[64] = new Object[]{"anc", new int[]{-1, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[65] = new Object[]{"anc2", new int[]{-1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[66] = new Object[]{"alr", new int[]{-1, 75, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[67] = new Object[]{"arr", new int[]{-1, 107, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[68] = new Object[]{"xaa", new int[]{-1, 139, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[69] = new Object[]{"axs", new int[]{-1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[70] = new Object[]{"sbc2", new int[]{-1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[71] = new Object[]{"ahx", new int[]{-1, -1, -1, -1, -1, -1, 147, -1, -1, 159, -1, -1}};
        objectArray[72] = new Object[]{"shy", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 156, -1, -1, -1}};
        objectArray[73] = new Object[]{"shx", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 158, -1, -1}};
        objectArray[74] = new Object[]{"tas", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 155, -1, -1}};
        objectArray[75] = new Object[]{"las", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 187, -1, -1}};
        objectArray[76] = new Object[]{"sac", new int[]{-1, 50, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[77] = new Object[]{"sir", new int[]{-1, 66, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        objectArray[78] = new Object[]{"bra", new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18}};
        mnemonicsData = objectArray;
        int i = 0;
        while (i < mnemonicsData.length) {
            Object[] data = (Object[])mnemonicsData[i];
            String key = (String)data[0];
            int[] value = (int[])data[1];
            if (mnemonics.containsKey(key)) {
                System.out.println("Error! - duplicate mnemonic :" + key);
            }
            mnemonics.put((String)data[0], (int[])data[1]);
            ++i;
        }
    }

    public static int[] getPossibleModes(String cmd) {
        return mnemonics.get(cmd);
    }

    public static int getOpcode(String cmd, int mode) {
        int[] modeList = MnemonicTable.getPossibleModes(cmd);
        if (modeList == null) {
            return -2;
        }
        return modeList[mode];
    }

    public static boolean hasRelativeAdressMode(String mnemonic) {
        return MnemonicTable.getOpcode(mnemonic, 11) >= 0;
    }

    public static List<Constant> getOpcodeConstants() {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        for (Map.Entry<String, int[]> cmd : mnemonics.entrySet()) {
            String name = cmd.getKey();
            int[] opcodes = cmd.getValue();
            int i = 0;
            while (i < opcodes.length) {
                if (opcodes[i] >= 0) {
                    String constantName = name.toUpperCase();
                    if (i > 0) {
                        constantName = String.valueOf(constantName) + "_" + ArgTypes.typeToShortString(i);
                    }
                    constants.add(new Constant(constantName, new NumberValue(opcodes[i])));
                }
                ++i;
            }
        }
        return constants;
    }

    public static int getCommandSize(int opcode) {
        for (Map.Entry<String, int[]> cmd : mnemonics.entrySet()) {
            int[] opcodes = cmd.getValue();
            int i = 0;
            while (i < opcodes.length) {
                if (opcodes[i] == opcode) {
                    return ArgTypes.getSize(i) + 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String key : mnemonics.keySet()) {
            int pos = 0;
            while (pos < sortedList.size() && key.compareTo((String)sortedList.get(pos)) > 0) {
                ++pos;
            }
            sortedList.add(pos, key);
        }
        Iterator<String> iterator = sortedList.iterator();
        while (iterator.hasNext()) {
            String key;
            String opcodeLine = key = iterator.next();
            int[] mnemonicModes = mnemonics.get(key);
            int i = 0;
            while (i < mnemonicModes.length) {
                int opcode = mnemonicModes[i];
                String opcodeStr = Integer.toHexString(opcode);
                if (opcodeStr.length() == 1) {
                    opcodeStr = "0" + opcodeStr;
                }
                opcodeStr = "$" + opcodeStr;
                opcodeLine = String.valueOf(opcodeLine) + "," + (opcode < 0 ? "" : opcodeStr);
                ++i;
            }
            System.out.println(opcodeLine);
        }
    }
}

