/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.state.scope.Scope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.log.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViceSymbolFile {
    private static Log log = new Log("ViceSymbolFile");
    private Scope rootScope;

    public ViceSymbolFile(Scope rootScope) {
        this.rootScope = rootScope;
    }

    public void writeFile(String filename) {
        try {
            Map<String, Integer> multiSymbolTable = this.initMultiSymbolTable(this.rootScope);
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            this.writeFile(this.rootScope, out, multiSymbolTable);
            ((Writer)out).close();
        }
        catch (IOException ex) {
            log.error("IO error while writing vic symbol file '" + filename + "':" + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Internal error while writing vice symbol file '" + filename + "'. Contact the author");
            ex.printStackTrace(System.out);
        }
    }

    private Map<String, Integer> initMultiSymbolTable(Scope rootScope) {
        HashMap<String, Integer> symbolCounts = new HashMap<String, Integer>();
        this.countLabels(rootScope, symbolCounts);
        HashMap<String, Integer> symbolCounts2 = new HashMap<String, Integer>();
        for (Map.Entry entry : symbolCounts.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            symbolCounts2.put((String)entry.getKey(), new Integer(1));
        }
        return symbolCounts2;
    }

    private void countLabels(Scope scope, Map<String, Integer> symbolMap) {
        for (Map.Entry entry : scope.getSymbols().getLocalDefinedEntities().entrySet()) {
            String labelName = entry.getKey();
            SymbolScopeValue value = (SymbolScopeValue)entry.getValue();
            if (!(value instanceof LabelReferenceValue)) continue;
            Integer labelCount = symbolMap.get(labelName);
            if (labelCount == null) {
                labelCount = 0;
            }
            labelCount = labelCount + 1;
            symbolMap.put(labelName, labelCount);
        }
        for (Scope subScope : scope.getChildren()) {
            this.countLabels(subScope, symbolMap);
        }
    }

    private void writeFile(Scope scope, Writer out, Map<String, Integer> multiSymbolTable) throws Exception {
        for (Map.Entry entry : scope.getSymbols().getLocalDefinedEntities().entrySet()) {
            String labelName = entry.getKey();
            SymbolScopeValue value = (SymbolScopeValue)entry.getValue();
            if (!(value instanceof LabelReferenceValue)) continue;
            String extLabelName = labelName;
            Integer count = multiSymbolTable.get(labelName);
            if (count != null) {
                extLabelName = String.valueOf(extLabelName) + "__" + count;
                multiSymbolTable.put(labelName, count + 1);
            }
            String labelValue = Integer.toHexString(((SymbolScopeValue)scope.getSymbols().get(labelName)).getInt(null));
            out.write("al C:" + labelValue + " ." + extLabelName + "\n");
        }
        for (Scope subScope : scope.getChildren()) {
            this.writeFile(subScope, out, multiSymbolTable);
        }
    }
}

