/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state;

import cml.kickass.lexvalues.DebugInfo;
import java.util.Stack;

public class CallStack {
    private Stack<DebugInfo> stack = new Stack();

    public CallStack() {
        this.stack.ensureCapacity(200);
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public DebugInfo pop() {
        return this.stack.pop();
    }

    public void push(DebugInfo debug) {
        this.stack.push(debug);
    }

    public void popTilDepth(int depth) {
        while (this.stack.size() > depth) {
            this.stack.pop();
        }
    }

    public String getTrace(DebugInfo presentPosition) {
        int startI;
        String newln = System.getProperties().getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(presentPosition.getPositionString());
        sb.append(newln);
        int i = startI = this.stack.size() - 1;
        while (i >= 0) {
            sb.append("called ");
            sb.append(((DebugInfo)this.stack.get(i)).getPositionString());
            sb.append(newln);
            --i;
        }
        return sb.toString();
    }
}

