/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.sideeffect.SEIncreaseMemoryPosition;
import cml.kickass.sideeffect.SESetMemoryPosition;
import cml.kickass.sideeffect.SideEffect;
import cml.kickass.state.AssertManager;
import cml.kickass.state.CallStack;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.log.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationState {
    private static Log log = new Log("");
    public static final int defaultMemoryPosition = 8192;
    private final long initSeed = (long)(Math.random() * 1.0E7);
    private boolean dtvMode = false;
    private ArrayList<File> sourceLibraryPath;
    private FunctionTable functionTable = new StdFunctionTable();
    private int passNo = 0;
    private boolean failOnInvalidValue;
    private boolean madeMetaProgress;
    private boolean functionMode = false;
    private boolean pseudoPcMode = false;
    private Integer currentMemoryPosition;
    private Integer currentRealMemoryPosition;
    private boolean errorDuringFunctionEvaluation;
    private FunctionSideOutput sideOutput = null;
    private Scope systemScope = new StdScope(null, false);
    private Scope scopeBeforeFunctionMode = null;
    private Scope currentScope = new StdScope(this.systemScope, true);
    private CallStack callStack = new CallStack();
    private String currentDirectory = "";
    private AssertManager assertManager = new AssertManager();

    public void prepareNewParse() {
        ++this.passNo;
        this.madeMetaProgress = false;
        MathLibrary.setSeed(this.initSeed);
        this.setMemoryPosition(8192);
        this.currentScope.resetBeforePass();
    }

    public void setDtvMode(boolean dtv) {
        this.dtvMode = dtv;
    }

    public boolean getDtvMode() {
        return this.dtvMode;
    }

    public boolean failOnInvalidValue() {
        return this.failOnInvalidValue;
    }

    public void setFailOnInvalidValue(boolean failOnInvalidValue) {
        this.failOnInvalidValue = failOnInvalidValue;
    }

    public void setMadeMetaProgress() {
        this.madeMetaProgress = true;
    }

    public boolean getMadeMetaProgress() {
        return this.madeMetaProgress;
    }

    public void setPseudoPcMode(boolean mode) {
        this.pseudoPcMode = mode;
    }

    public boolean getPseudoPcMode() {
        return this.pseudoPcMode;
    }

    public void setSourceLibraryPath(ArrayList<File> path) {
        this.sourceLibraryPath = path;
    }

    public boolean getFunctionsMode() {
        return this.functionMode;
    }

    public void setFunctionMode(boolean functionMode) {
        this.functionMode = functionMode;
    }

    public AssertManager getAssertManager() {
        return this.assertManager;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public int getPassNo() {
        return this.passNo;
    }

    public void addLibrary(Library library) {
        String libraryName = library.getClass().getSimpleName();
        for (Constant constant : library.getConstants()) {
            String errorText = "Error while adding the constant '" + constant.getName() + "' from the library '" + libraryName + "'. The symbol already exist!";
            ConstantReferenceValue value = new ConstantReferenceValue(constant.getValue());
            this.systemScope.getSymbols().putErrorIfExist(constant.getName(), value, errorText, null);
        }
        for (Function function : library.getFunctions()) {
            this.functionTable.add(function);
        }
    }

    public FunctionTable getFunctionTable() {
        return this.functionTable;
    }

    public void clearFunctionSideOutput() {
        this.sideOutput = null;
        this.errorDuringFunctionEvaluation = false;
    }

    public FunctionSideOutput getFunctionSideOutput() {
        return this.sideOutput;
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.getOrNewFunctionSideOutput().addSideEffect(sideEffect);
    }

    public void addTextOutput(String text) {
        this.getOrNewFunctionSideOutput().addTextOutput(text);
    }

    private FunctionSideOutput getOrNewFunctionSideOutput() {
        if (this.sideOutput == null) {
            this.sideOutput = new FunctionSideOutput();
        }
        return this.sideOutput;
    }

    public boolean getErrrorDuringFunctionEvaluation() {
        return this.errorDuringFunctionEvaluation;
    }

    public void setErrrorDuringFunctionEvaluation(boolean value) {
        this.errorDuringFunctionEvaluation = value;
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(Scope scope) {
        this.currentScope = scope;
    }

    public Scope getScopeBeforeFunctionMode() {
        return this.scopeBeforeFunctionMode;
    }

    public void setScopeBeforeFunctionMode(Scope scope) {
        this.scopeBeforeFunctionMode = scope;
    }

    public Integer getMemoryPosition() {
        return this.currentMemoryPosition;
    }

    public Integer getRealMemoryPosition() {
        return this.currentRealMemoryPosition;
    }

    public void setRealMemoryPosition(Integer pos) {
        this.currentRealMemoryPosition = pos;
    }

    public void setMemoryPosition(Integer pos) {
        this.setMemoryPositionWithoutSideEffect(pos);
        if (pos == null) {
            this.setErrrorDuringFunctionEvaluation(true);
        } else {
            this.addSideEffect(new SESetMemoryPosition(pos));
        }
    }

    public void setMemoryPositionWithoutSideEffect(Integer pos) {
        this.currentMemoryPosition = pos;
        this.currentRealMemoryPosition = pos;
    }

    public void increaseMemoryPosition(int value) {
        this.increaseMemoryPositionWithoutSideEffect(value);
        this.addSideEffect(new SEIncreaseMemoryPosition(value));
    }

    public void increaseMemoryPositionWithoutSideEffect(int value) {
        if (this.currentMemoryPosition != null) {
            this.currentMemoryPosition = this.currentMemoryPosition + value;
        }
        if (this.currentRealMemoryPosition != null) {
            this.currentRealMemoryPosition = this.currentRealMemoryPosition + value;
        }
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public InputStream openFile(String filename, DebugInfo debug) throws AsmException {
        File file = this.getFile(filename, debug);
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new AsmError("Can't open file '" + filename + "'", debug);
        }
    }

    public File getFile(String filename, DebugInfo debug) {
        File file = this.getFile(filename);
        if (file == null) {
            throw new AsmError("Can't locate file '" + filename + "'", debug);
        }
        return file;
    }

    public File getFile(String filename) {
        File file = new File(this.currentDirectory, filename);
        if (file.exists()) {
            return file;
        }
        int i = 0;
        while (i < this.sourceLibraryPath.size()) {
            file = new File(this.sourceLibraryPath.get(i), filename);
            if (file.exists()) {
                return file;
            }
            ++i;
        }
        file = new File(filename);
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

