/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state.scope;

import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.scope.EntityScope;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdEntityScope<Entity>
implements EntityScope<Entity> {
    private EntityScope<Entity> parrent;
    private Map<String, Entity> localDefinedEntities = new HashMap<String, Entity>();

    public StdEntityScope(EntityScope<Entity> parrent) {
        this.parrent = parrent;
    }

    @Override
    public Entity get(String id) {
        Entity entity = this.localDefinedEntities.get(id);
        if (entity == null && this.parrent != null) {
            entity = this.parrent.get(id);
        }
        return entity;
    }

    @Override
    public void put(String id, Entity entity) {
        this.localDefinedEntities.put(id, entity);
    }

    @Override
    public void putErrorIfExist(String id, Entity entity, String errorMessage, DebugInfo debug) {
        if (this.localDefinedEntities.containsKey(id)) {
            throw new AsmError(errorMessage, debug);
        }
        this.put(id, entity);
    }

    @Override
    public Map<String, Entity> getLocalDefinedEntities() {
        return this.localDefinedEntities;
    }

    @Override
    public void setLocalDefinedEntities(Map<String, Entity> entityMap) {
        this.localDefinedEntities = entityMap;
    }

    protected EntityScope<Entity> getParrent() {
        return this.parrent;
    }
}

