/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state.scope;

import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.scope.EntityScope;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdEntityScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.SymbolScopeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdScope
implements Scope {
    private String name;
    private Scope parrent;
    private Collection<Scope> children = new ArrayList<Scope>();
    private SymbolScope symbols = null;
    private EntityScope<ExecutableDirectives> macros;
    private EntityScope<ExecutableDirectives> pseudoCommands;

    public StdScope(Scope parrent, boolean registerInParrent) {
        this(null, parrent, registerInParrent);
    }

    public StdScope(String name, Scope parrent, boolean registerInParrent) {
        this.parrent = parrent;
        if (parrent == null) {
            this.symbols = new SymbolScope(null);
            this.macros = new StdEntityScope<ExecutableDirectives>(null);
            this.pseudoCommands = new StdEntityScope<ExecutableDirectives>(null);
        } else {
            this.symbols = new SymbolScope(parrent.getSymbols());
            this.macros = parrent.getMacros();
            this.pseudoCommands = parrent.getPseudoCommands();
        }
        if (registerInParrent) {
            parrent.registerChild(this);
        }
    }

    @Override
    public void registerChild(Scope child) {
        this.children.add(child);
    }

    @Override
    public Collection<Scope> getChildren() {
        return this.children;
    }

    @Override
    public void resetBeforePass() {
        HashMap<String, SymbolScopeValue> newSymbolMap = new HashMap<String, SymbolScopeValue>();
        for (Map.Entry entry : this.getSymbols().getLocalDefinedEntities().entrySet()) {
            if (!((SymbolScopeValue)entry.getValue()).keepInNextPass()) continue;
            ((SymbolScopeValue)entry.getValue()).initBeforeParse();
            newSymbolMap.put(entry.getKey(), (SymbolScopeValue)entry.getValue());
        }
        this.symbols.setLocalDefinedEntities(newSymbolMap);
        for (Scope scope : this.children) {
            scope.resetBeforePass();
        }
    }

    @Override
    public Scope getParrent() {
        return this.parrent;
    }

    @Override
    public EntityScope<ExecutableDirectives> getMacros() {
        return this.macros;
    }

    @Override
    public EntityScope<ExecutableDirectives> getPseudoCommands() {
        return this.pseudoCommands;
    }

    @Override
    public SymbolScope getSymbols() {
        return this.symbols;
    }
}

