/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.ArgTypes;
import cml.kickass.misc.Argument;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class AsmCommandArgumentValue
extends ImmutableValue {
    public static AsmCommandArgumentValue noArgument = new AsmCommandArgumentValue(0, new NumberValue(0.0));
    private int type;
    private Value value;
    static FunctionTable functions = new StdFunctionTable(AsmCommandArgumentValue.getStandardFunctions());

    static {
        functions.add(new Function("getType", 1, NumberValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                return new NumberValue(((AsmCommandArgumentValue)arguments[0]).type);
            }
        });
        functions.add(new Function("getValue", 1, NumberValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                return ((AsmCommandArgumentValue)arguments[0]).value;
            }
        });
    }

    public AsmCommandArgumentValue(int type, Value value) {
        this.type = type;
        this.value = value;
        this.setHasInvalidContent(value.isInvalid());
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == Value.RP_ASMARGVALUE) {
            return new Argument(this.type, this.value);
        }
        if (representation == Value.RP_STRINGVALUE) {
            return "Argument<" + ArgTypes.typeToString(this.type) + ">";
        }
        return null;
    }

    public String getType() {
        return "Asm command argument";
    }

    public FunctionTable getFunctions() {
        return functions;
    }
}

