/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class BinaryFileValue
extends ImmutableValue {
    public static BinaryFileValue invalid = new BinaryFileValue();
    private static final String c64FileToken = "C64FILE";
    private int offset = 0;
    private byte[] file;
    FunctionTable functions = new StdFunctionTable(BinaryFileValue.getStandardFunctions());

    private BinaryFileValue() {
        this.setInvalid();
    }

    public BinaryFileValue(byte[] file, BlockData blockData) {
        this.file = file;
        this.offset = blockData.offset;
        for (Block block : blockData.blocks) {
            this.functions.add(new BlockGetFunction("get" + block.name, block));
            this.functions.add(new BlockSizeFunction("get" + block.name + "Size", block));
        }
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return "Binary file";
        }
        return null;
    }

    public String getType() {
        return "Binary file";
    }

    public static BlockData templateToBlocks(String template, int fileLength, DebugInfo debug) throws AsmError {
        BlockData blockData = BinaryFileValue.parseBlocks(template, debug);
        Comparator<Block> blockCmp = new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                if (b1.start == b2.start) {
                    return 0;
                }
                return b1.start < b2.start ? -1 : 1;
            }
        };
        Collections.sort(blockData.blocks, blockCmp);
        Block prevBlock = null;
        for (Block block : blockData.blocks) {
            if (prevBlock != null) {
                prevBlock.length = block.start - prevBlock.start;
            }
            prevBlock = block;
        }
        if (prevBlock != null) {
            prevBlock.length = fileLength - blockData.offset - prevBlock.start;
        }
        Block globalBlock = new Block();
        globalBlock.name = "";
        globalBlock.start = 0;
        globalBlock.length = fileLength - blockData.offset;
        blockData.blocks.add(globalBlock);
        return blockData;
    }

    private static BlockData parseBlocks(String template, DebugInfo debug) throws AsmError {
        BlockData blockData = new BlockData();
        StringTokenizer tokens = new StringTokenizer(template, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.trim().equals(c64FileToken)) {
                blockData.offset = 2;
                continue;
            }
            int i = token.indexOf(61);
            if (i < 0) {
                throw new AsmError("Invalid token in template: '" + token + "'", debug);
            }
            String blockNameStr = token.substring(0, i).trim();
            String blockAddressStr = token.substring(i + 1).trim();
            int blockAddress = 0;
            try {
                int radix = 10;
                if (blockAddressStr.charAt(0) == '$') {
                    radix = 16;
                    blockAddressStr = blockAddressStr.substring(1);
                }
                blockAddress = Integer.valueOf(blockAddressStr, radix);
            }
            catch (Exception ex) {
                throw new AsmError("Error in address of token : '" + token + "'", debug);
            }
            Block block = new Block();
            block.start = blockAddress;
            block.name = blockNameStr;
            blockData.blocks.add(block);
        }
        return blockData;
    }

    public FunctionTable getFunctions() {
        return this.functions;
    }

    public static class Block {
        public int start;
        public int length;
        public String name;
    }

    public static class BlockData {
        public int offset = 0;
        public List<Block> blocks = new ArrayList<Block>();
    }

    private class BlockGetFunction
    extends Function {
        private Block block;

        public BlockGetFunction(String name, Block block) {
            super(name, null, NumberValue.invalid);
            this.block = block;
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            int combinedIndex;
            int index = 0;
            if (arguments.length > 2) {
                throw new AsmError("Invalid number of arguments : " + (arguments.length - 1), debug);
            }
            if (arguments.length == 2) {
                index = arguments[1].getInt(debug);
            }
            if ((combinedIndex = this.block.start + index + BinaryFileValue.this.offset) >= BinaryFileValue.this.file.length) {
                throw new AsmError("index out of range : " + index, debug);
            }
            return new NumberValue(BinaryFileValue.this.file[combinedIndex]);
        }
    }

    private static class BlockSizeFunction
    extends Function {
        private Block block;

        public BlockSizeFunction(String name, Block block) {
            super(name, 1, NumberValue.invalid);
            this.block = block;
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            return new NumberValue(this.block.length);
        }
    }
}

