/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.BooleanFunction;
import cml.kickass.function.BooleanX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class BooleanValue
extends ImmutableValue {
    private boolean value;
    public static Value invalid = new BooleanValue();
    public static Value falseValue = new BooleanValue(false);
    public static Value trueValue = new BooleanValue(true);
    static FunctionTable functions = new StdFunctionTable(BooleanValue.getStandardFunctions());

    static {
        functions.add(new BooleanFunction("!", invalid){

            protected Value f(boolean a) {
                return new BooleanValue(!a);
            }
        });
        functions.add(new BooleanX2Function("==", invalid){

            protected Value f(boolean a, boolean b) {
                return new BooleanValue(a == b);
            }
        });
        functions.add(new BooleanX2Function("!=", invalid){

            protected Value f(boolean a, boolean b) {
                return new BooleanValue(a ^ b);
            }
        });
        functions.add(new BooleanX2Function("&&", invalid){

            protected Value f(boolean a, boolean b) {
                return new BooleanValue(a && b);
            }
        });
        functions.add(new BooleanX2Function("||", invalid){

            protected Value f(boolean a, boolean b) {
                return new BooleanValue(a || b);
            }
        });
    }

    private BooleanValue() {
        this.setInvalid();
    }

    public BooleanValue(boolean value) {
        this.value = value;
    }

    public String getType() {
        return "boolean";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_BOOLEANVALUE) {
            return new Boolean(this.value);
        }
        if (representation == RP_STRINGVALUE) {
            return "" + this.value;
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }
}

