/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.StringX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class CharValue
extends ImmutableValue {
    public static Value invalid = new CharValue();
    private char c;
    static FunctionTable functions = new StdFunctionTable(CharValue.getStandardFunctions());

    static {
        functions.add(new StringX2Function("==", BooleanValue.invalid){

            protected Value f(String a, String b) {
                return new BooleanValue(a.equals(b));
            }
        });
        functions.add(new StringX2Function("!=", BooleanValue.invalid){

            protected Value f(String a, String b) {
                return new BooleanValue(!a.equals(b));
            }
        });
    }

    private CharValue() {
        this.setInvalid();
    }

    public CharValue(char c) {
        this.c = c;
    }

    public String getType() {
        return this.isInvalid() ? "Invalid Char" : "Char";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == Value.RP_STRINGVALUE) {
            return "" + this.c;
        }
        if (representation == Value.RP_DOUBLEVALUE) {
            return CharToPetsciiConverter.convert(this.c).doubleValue();
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }
}

