/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.ListValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import java.util.HashMap;

public class HashtableValue
extends LockableValue {
    private HashMap<String, Value> hashtable = new HashMap();
    static FunctionTable functions = new StdFunctionTable(HashtableValue.getStandardFunctions());

    static {
        functions.add(new HashTableFunction("put", 3, null){

            protected Value f(HashtableValue tableValue, DebugInfo debug, Value ... arguments) {
                String key = arguments[1].getString(debug);
                Value value = arguments[2];
                tableValue.hashtable.put(key, value);
                if (value.isInvalid()) {
                    tableValue.setHasInvalidContent(true);
                }
                return value;
            }
        });
        functions.add(new HashTableFunction("get", 2, (Value)InvalidValue.instance){

            protected Value f(HashtableValue tableValue, DebugInfo debug, Value ... arguments) {
                if (arguments[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String key = arguments[1].getString(debug);
                Value value = (Value)tableValue.hashtable.get(key);
                if (value == null) {
                    value = NullValue.instance;
                }
                return value;
            }
        });
        functions.add(new HashTableFunction("keys", 1, (Value)ListValue.invalid){

            protected Value f(HashtableValue tableValue, DebugInfo debug, Value ... arguments) {
                ListValue keyList = new ListValue(0);
                for (String key : tableValue.hashtable.keySet()) {
                    keyList.add((Value)new StringValue(key));
                }
                return keyList;
            }
        });
    }

    public String getType() {
        return "Hashtable";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return "Hashtable";
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    public void lock(DebugInfo debug) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.hashtable.values()) {
            value.lock(debug);
        }
    }

    private static abstract class HashTableFunction
    extends Function {
        public HashTableFunction(String name, int noOfArguments, Value invalidResult) {
            super(name, noOfArguments, invalidResult, true);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            HashtableValue hashTableValue = (HashtableValue)arguments[0];
            if (hashTableValue.isInvalid()) {
                return this.getInvalidResult(arguments);
            }
            return this.f(hashTableValue, debug, arguments);
        }

        protected abstract Value f(HashtableValue var1, DebugInfo var2, Value ... var3);
    }
}

