/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmErrorWithExtraDebug;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LockableValue;
import cml.kickass.values.Value;

public class InvalidUnlockedSideEffectValue
extends LockableValue {
    private DebugInfo setDebug;

    public InvalidUnlockedSideEffectValue(DebugInfo setDebug) {
        this.setDebug = setDebug;
    }

    public Object getRepresentation(int representation) throws AsmException {
        this.throwException(null);
        return null;
    }

    public String getType() {
        this.throwException(null);
        return null;
    }

    public FunctionTable getFunctions() {
        return new InvalidValueFunctionTable();
    }

    public void lock(DebugInfo debug) {
    }

    protected void throwException(DebugInfo debug) {
        String message1 = "You are trying to use an unlocked value accross passes. This is not supported.";
        String message2 = "Try locking the variable with the .define directive or .lock() method before assigning it";
        throw new AsmErrorWithExtraDebug(message1, debug, message2, this.setDebug);
    }

    class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        public Function get(String name, Value[] args, DebugInfo debug) {
            return new Function(name, null, null, true){

                public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                    InvalidUnlockedSideEffectValue.this.throwException(debug);
                    return null;
                }
            };
        }

        public boolean exist(String name, Value[] args) {
            throw NotImplementedException.intance;
        }
    }
}

