/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collections;

public class ListValue
extends LockableValue {
    public static ListValue invalid = new ListValue();
    private ArrayList<Value> list = new ArrayList();
    static FunctionTable functions = new StdFunctionTable(ListValue.getStandardFunctions());

    static {
        functions.add(new Function("add", null, null, true){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                ListValue list = (ListValue)arguments[0];
                list.ensureNotLocked(debug);
                if (list.isInvalid()) {
                    return list;
                }
                int i = 1;
                while (i < arguments.length) {
                    list.add(arguments[i]);
                    ++i;
                }
                return list;
            }
        });
        functions.add(new ListValueStateFunction("get", InvalidValue.instance){

            protected Value f(ListValue list, Value v1, EvaluationState state, DebugInfo debug) {
                if (v1.isInvalid()) {
                    return InvalidValue.instance;
                }
                int n = v1.getInt(debug);
                list.checkForOutOfBound(n, debug);
                Value result = (Value)list.list.get(n);
                if (result.isInvalid()) {
                    state.setErrrorDuringFunctionEvaluation(true);
                }
                return (Value)list.list.get(n);
            }
        });
        functions.add(new ListValueX2Function("set", null){

            protected Value f(ListValue list, Value v1, Value v2, DebugInfo debug) {
                list.ensureNotLocked(debug);
                if (v1.isInvalid()) {
                    list.setInvalid();
                    return list;
                }
                int n = v1.getInt(debug);
                list.checkForOutOfBound(n, debug);
                list.list.set(n, v2);
                if (v2.isInvalid()) {
                    list.setHasInvalidContent(true);
                }
                return list;
            }
        });
        functions.add(new ListValueFunction("remove", null){

            protected Value f(ListValue list, Value value, DebugInfo debug) {
                list.ensureNotLocked(debug);
                if (value.isInvalid()) {
                    list.setInvalid();
                    return list;
                }
                int n = value.getInt(debug);
                list.checkForOutOfBound(n, debug);
                list.list.remove(n);
                return list;
            }
        });
        functions.add(new ListFunction("size", NumberValue.invalid){

            protected Value f(ListValue list, DebugInfo debug) {
                return new NumberValue(list.list.size());
            }
        });
        functions.add(new ListFunction("shuffle", null){

            protected Value f(ListValue list, DebugInfo debug) {
                list.ensureNotLocked(debug);
                Collections.shuffle(list.list, MathLibrary.getRandomGenerator());
                return list;
            }
        });
    }

    private ListValue() {
        this.setInvalid();
    }

    public ListValue(int size) {
        int i = 0;
        while (i < size) {
            this.list.add(NullValue.instance);
            ++i;
        }
    }

    public String getType() {
        return "List";
    }

    public void add(Value value) {
        this.list.add(value);
        if (value.isInvalid()) {
            this.setHasInvalidContent(true);
        }
    }

    public void add(Value ... values) {
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            this.add(value);
            ++n2;
        }
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "InvalidList";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            int i = 0;
            while (i < this.list.size()) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.list.get(i).getString(null));
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
        if (representation == RP_LISTVALUE) {
            return this.list;
        }
        return null;
    }

    void checkForOutOfBound(int n, DebugInfo debug) throws AsmException {
        if (n < 0 || this.list.size() <= n) {
            throw new AsmError("Index out of bound : " + n, debug);
        }
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    public void lock(DebugInfo debug) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.list) {
            value.lock(debug);
        }
    }

    static abstract class ListFunction
    extends Function {
        public ListFunction(String name, Value invalidResult) {
            super(name, 1, invalidResult);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            return this.f((ListValue)arguments[0], debug);
        }

        protected abstract Value f(ListValue var1, DebugInfo var2);
    }

    static abstract class ListValueFunction
    extends Function {
        public ListValueFunction(String name, Value invalidResult) {
            super(name, 2, invalidResult, true);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            ListValue listValue = (ListValue)arguments[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(arguments);
            }
            return this.f((ListValue)arguments[0], arguments[1], debug);
        }

        protected abstract Value f(ListValue var1, Value var2, DebugInfo var3);
    }

    static abstract class ListValueStateFunction
    extends Function {
        public ListValueStateFunction(String name, Value invalidResult) {
            super(name, 2, invalidResult, true);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            ListValue listValue = (ListValue)arguments[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(arguments);
            }
            return this.f((ListValue)arguments[0], arguments[1], state, debug);
        }

        protected abstract Value f(ListValue var1, Value var2, EvaluationState var3, DebugInfo var4);
    }

    static abstract class ListValueX2Function
    extends Function {
        public ListValueX2Function(String name, Value invalidResult) {
            super(name, 3, invalidResult, true);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            ListValue listValue = (ListValue)arguments[0];
            if (listValue.isInvalid()) {
                return this.getInvalidResult(arguments);
            }
            return this.f((ListValue)arguments[0], arguments[1], arguments[2], debug);
        }

        protected abstract Value f(ListValue var1, Value var2, Value var3, DebugInfo var4);
    }
}

