/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import cml.kickass.values.VectorValue;

public class MatrixValue
extends LockableValue {
    public static MatrixValue invalid = new MatrixValue();
    private double[][] entries = new double[4][4];
    static FunctionTable functions = new StdFunctionTable(MatrixValue.getStandardFunctions());

    static {
        functions.add(new MatrixFunction("get", 3, NumberValue.invalid, false){

            protected Value f(MatrixValue mv, DebugInfo debug, Value ... arguments) {
                int i = arguments[1].getInt(debug);
                int j = arguments[2].getInt(debug);
                mv.outOfBoundCheck(i, j, debug);
                return new NumberValue(mv.entries[i][j]);
            }
        });
        functions.add(new MatrixFunction("set", 4, null, true){

            protected Value f(MatrixValue mv, DebugInfo debug, Value ... arguments) {
                mv.ensureNotLocked(debug);
                if (arguments[1].isInvalid() || arguments[2].isInvalid() || arguments[3].isInvalid()) {
                    mv.setInvalid();
                    return mv;
                }
                int i = arguments[1].getInt(debug);
                int j = arguments[2].getInt(debug);
                double value = arguments[3].getDouble(debug);
                mv.outOfBoundCheck(i, j, debug);
                ((MatrixValue)mv).entries[i][j] = value;
                return mv;
            }
        });
        functions.add(new MatrixFunction("*", 2, invalid, false){

            protected Value f(MatrixValue mv, DebugInfo debug, Value ... arguments) {
                double[][] entries2 = (double[][])arguments[1].getRepresentation(RP_MATRIXVALUE);
                if (entries2 != null) {
                    return mv.matrixMatrixMul(mv.entries, entries2);
                }
                double[] coords = (double[])arguments[1].getRepresentation(RP_VECTORVALUE);
                if (coords != null) {
                    return mv.matrixVectorMul(mv.entries, coords);
                }
                throw new AsmError("Cant multiply a matrix with an object of type " + arguments[0].getType(), debug);
            }
        });
    }

    private MatrixValue() {
        this.setInvalid();
    }

    public MatrixValue(double[][] entries) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.entries[i][j] = entries[i][j];
                ++j;
            }
            ++i;
        }
    }

    public String getType() {
        return "Matrix";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_MATRIXVALUE) {
            return this.entries;
        }
        if (representation == RP_STRINGVALUE) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            int i = 0;
            while (i < 4) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("[");
                int j = 0;
                while (j < 4) {
                    if (j != 0) {
                        sb.append(",");
                    }
                    sb.append(this.entries[i][j]);
                    ++j;
                }
                sb.append("]");
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    private Value matrixMatrixMul(double[][] m1, double[][] m2) {
        double[][] result = new double[4][4];
        int pp = 0;
        while (pp < 4) {
            int mm = 0;
            while (mm < 4) {
                int nn = 0;
                while (nn < 4) {
                    double[] dArray = result[mm];
                    int n = pp;
                    dArray[n] = dArray[n] + m1[mm][nn] * m2[nn][pp];
                    ++nn;
                }
                ++mm;
            }
            ++pp;
        }
        return new MatrixValue(result);
    }

    private Value matrixVectorMul(double[][] m, double[] v) {
        double[] res = new double[]{v[0] * m[0][0] + v[1] * m[0][1] + v[2] * m[0][2] + m[0][3], v[0] * m[1][0] + v[1] * m[1][1] + v[2] * m[1][2] + m[1][3], v[0] * m[2][0] + v[1] * m[2][1] + v[2] * m[2][2] + m[2][3], v[0] * m[3][0] + v[1] * m[3][1] + v[2] * m[3][2] + m[3][3]};
        return new VectorValue(res[0] / res[3], res[1] / res[3], res[2] / res[3]);
    }

    private void outOfBoundCheck(int i, int j, DebugInfo debug) throws AsmException {
        if (i < 0 || 4 <= i || j < 0 || 4 <= j) {
            throw new AsmError("Index out of bound (" + i + "," + j + ")", debug);
        }
    }

    public boolean isInvalid() {
        return super.isInvalid();
    }

    public void lock(DebugInfo debug) {
        this.isLocked = true;
    }

    public String toString() {
        return "MatrixValue";
    }

    static abstract class MatrixFunction
    extends Function {
        public MatrixFunction(String name, Integer noOfArguments, Value invalidResult, boolean handlesInvalidArguments) {
            super(name, noOfArguments, invalidResult, handlesInvalidArguments);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            MatrixValue matrixValue = (MatrixValue)arguments[0];
            if (matrixValue.isInvalid()) {
                return this.getInvalidResult(arguments);
            }
            return this.f(matrixValue, debug, arguments);
        }

        protected abstract Value f(MatrixValue var1, DebugInfo var2, Value ... var3);
    }
}

