/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import java.util.Map;

public class NameSpaceValue
extends LabelReferenceValue {
    private Scope scope;
    private boolean alsoLabel = false;

    public NameSpaceValue(Scope scope) {
        this(scope, false);
    }

    public NameSpaceValue(Scope scope, boolean alsoLabel) {
        this.scope = scope;
        this.alsoLabel = alsoLabel;
    }

    public Object getRepresentation(int representation) {
        if (this.alsoLabel) {
            return super.getRepresentation(representation);
        }
        return null;
    }

    public FunctionTable getFunctions() {
        if (this.alsoLabel) {
            return super.getFunctions();
        }
        return NameSpaceValue.getStandardFunctions();
    }

    public boolean isInvalid() {
        if (this.alsoLabel) {
            return super.isInvalid();
        }
        return false;
    }

    public boolean hasInvalidContent() {
        if (this.alsoLabel) {
            return super.hasInvalidContent();
        }
        return false;
    }

    public String getType() {
        return this.isInvalid() ? "Invalid Namespace" : "Namespace";
    }

    protected Value localGetVariable(String name, DebugInfo debug) {
        boolean exposeValue;
        Map localSymbolScope = this.scope.getSymbols().getLocalDefinedEntities();
        SymbolScopeValue refValue = (SymbolScopeValue)localSymbolScope.get(name);
        boolean bl = exposeValue = refValue instanceof LabelReferenceValue || refValue instanceof NameSpaceValue;
        if (exposeValue) {
            return refValue;
        }
        if (this.alsoLabel) {
            return super.localGetVariable(name, debug);
        }
        return null;
    }

    public void setValue(Value value, EvaluationState state, DebugInfo debug) {
        throw new AsmError("Can't assign a new value to a label/namespace", debug);
    }
}

