/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.DoubleX2Function;
import cml.kickass.function.Function;
import cml.kickass.function.IntFunction;
import cml.kickass.function.IntX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class NumberValue
extends ImmutableValue {
    public static final NumberValue zero = new NumberValue(0.0);
    public static final NumberValue one = new NumberValue(1.0);
    public static final NumberValue invalid = new NumberValue();
    private double value;
    static FunctionTable functions = new StdFunctionTable(NumberValue.getStandardFunctions());

    static {
        functions.add(new IntFunction("-", invalid){

            protected Value f(int a) {
                return new NumberValue(-a);
            }
        });
        functions.add(new IntFunction("<", invalid){

            protected Value f(int a) {
                return new NumberValue(a & 0xFF);
            }
        });
        functions.add(new IntFunction(">", invalid){

            protected Value f(int a) {
                return new NumberValue(a >> 8 & 0xFF);
            }
        });
        functions.add(new DoubleX2Function("+", invalid){

            protected Value f(double a, double b) {
                return new NumberValue(a + b);
            }
        });
        functions.add(new DoubleX2Function("-", invalid){

            protected Value f(double a, double b) {
                return new NumberValue(a - b);
            }
        });
        functions.add(new DoubleX2Function("*", invalid){

            protected Value f(double a, double b) {
                return new NumberValue(a * b);
            }
        });
        functions.add(new DoubleX2Function("/", invalid){

            protected Value f(double a, double b) {
                return new NumberValue(a / b);
            }
        });
        functions.add(new DoubleX2Function("<=", BooleanValue.invalid){

            protected Value f(double a, double b) {
                return new BooleanValue(a <= b);
            }
        });
        functions.add(new DoubleX2Function(">=", BooleanValue.invalid){

            protected Value f(double a, double b) {
                return new BooleanValue(a >= b);
            }
        });
        functions.add(new DoubleX2Function("<", BooleanValue.invalid){

            protected Value f(double a, double b) {
                return new BooleanValue(a < b);
            }
        });
        functions.add(new DoubleX2Function(">", BooleanValue.invalid){

            protected Value f(double a, double b) {
                return new BooleanValue(a > b);
            }
        });
        functions.add(new IntX2Function("&", invalid){

            protected Value f(int a, int b) {
                return new NumberValue(a & b);
            }
        });
        functions.add(new IntX2Function("|", invalid){

            protected Value f(int a, int b) {
                return new NumberValue(a | b);
            }
        });
        functions.add(new IntX2Function("^", invalid){

            protected Value f(int a, int b) {
                return new NumberValue(a ^ b);
            }
        });
        functions.add(new IntX2Function(">>", invalid){

            protected Value f(int a, int b) {
                return new NumberValue(a >> b);
            }
        });
        functions.add(new IntX2Function("<<", invalid){

            protected Value f(int a, int b) {
                return new NumberValue(a << b);
            }
        });
        functions.add(new Function("==", 2, BooleanValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                Double value2 = (Double)arguments[1].getRepresentation(Value.RP_DOUBLEVALUE);
                if (value2 == null) {
                    return BooleanValue.falseValue;
                }
                return new BooleanValue(((NumberValue)arguments[0]).value == value2);
            }
        });
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                Double value2 = (Double)arguments[1].getRepresentation(Value.RP_DOUBLEVALUE);
                if (value2 == null) {
                    return BooleanValue.trueValue;
                }
                return new BooleanValue(((NumberValue)arguments[0]).value != value2);
            }
        });
    }

    public String getType() {
        return "number";
    }

    private NumberValue() {
        this.setInvalid();
    }

    public NumberValue(double value) {
        this.value = value;
    }

    public Object getRepresentation(int representation) {
        if (this.isInvalid()) {
            throw new AsmError("You cant get a representation from an invalid number value", null);
        }
        if (representation == Value.RP_DOUBLEVALUE) {
            return new Double(this.value);
        }
        if (representation == Value.RP_STRINGVALUE) {
            return Double.toString(this.value);
        }
        return null;
    }

    public boolean hasRepresentation(int representation) {
        return representation == Value.RP_DOUBLEVALUE || representation == Value.RP_STRINGVALUE;
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    public String toString() {
        return "" + this.value;
    }
}

