/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ColorMapper;
import cml.kickass.values.ColorTable;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;
import java.util.HashMap;

public class PictureValue
extends ImmutableValue {
    public static Value invalid = new PictureValue();
    private int[] pixels;
    private int width;
    private int height;
    private ColorMapper colorTable = null;
    static FunctionTable functions = new StdFunctionTable(PictureValue.getStandardFunctions());

    static {
        functions.add(new PictureXYFunction("getPixel", NumberValue.invalid){

            protected Value f(PictureValue picValue, int x, int y, DebugInfo debug) {
                return new NumberValue(picValue.getPixel(x, y, debug));
            }
        });
        functions.add(new PictureXYFunction("getMulticolorByte", NumberValue.invalid){

            protected Value f(PictureValue picValue, int x, int y, DebugInfo debug) {
                return new NumberValue(picValue.getMulticolorByte(x, y, debug));
            }
        });
        functions.add(new PictureXYFunction("getSinglecolorByte", NumberValue.invalid){

            protected Value f(PictureValue picValue, int x, int y, DebugInfo debug) {
                return new NumberValue(picValue.getSinglecolorByte(x, y, debug));
            }
        });
    }

    public PictureValue() {
        this.setInvalid();
    }

    public PictureValue(int width, int height, int[] pixels, int[] colorTable) {
        this.pixels = pixels;
        this.width = width;
        this.height = height;
        this.colorTable = colorTable != null ? PictureValue.createColorTable(colorTable) : PictureValue.createDefaultColorTable(pixels, 0);
    }

    public String getType() {
        return "Picture";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return "Picture";
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    public Value localGetVariable(String name, DebugInfo debug) throws AsmException {
        if (this.isInvalid()) {
            return NumberValue.invalid;
        }
        if (name.equals("width")) {
            return new NumberValue(this.width);
        }
        if (name.equals("height")) {
            return new NumberValue(this.height);
        }
        return null;
    }

    private int getPixel(int x, int y, DebugInfo debug) throws AsmException {
        if (x < 0 || this.width <= x) {
            throw new AsmError("x coordinate out of range : " + x, debug);
        }
        if (y < 0 || this.height <= y) {
            throw new AsmError("y coordinate out of range : " + y, debug);
        }
        return this.pixels[x + y * this.width] & 0xFFFFFF;
    }

    private int getMulticolorByte(int byteX, int y, DebugInfo debug) throws AsmException {
        int x = byteX * 8;
        if (x < 0 || this.width <= x) {
            throw new AsmError("byte x coordinate out of range : " + byteX, debug);
        }
        if (y < 0 || this.height <= y) {
            throw new AsmError("y coordinate out of range : " + y, debug);
        }
        int idx = x + y * this.width;
        int color1 = this.pixels[idx];
        int color2 = x + 2 >= this.width ? 0 : this.pixels[idx + 2];
        int color3 = x + 4 >= this.width ? 0 : this.pixels[idx + 4];
        int color4 = x + 6 >= this.width ? 0 : this.pixels[idx + 6];
        int result = (this.colorTable.getColor(color1) & 3) << 6 | (this.colorTable.getColor(color2) & 3) << 4 | (this.colorTable.getColor(color3) & 3) << 2 | this.colorTable.getColor(color4) & 3;
        return result;
    }

    private int getSinglecolorByte(int byteX, int y, DebugInfo debug) throws AsmException {
        int x = byteX * 8;
        if (x < 0 || this.width <= x) {
            throw new AsmError("byte x coordinate out of range : " + byteX, debug);
        }
        if (y < 0 || this.height <= y) {
            throw new AsmError("y coordinate out of range : " + y, debug);
        }
        int idx = x + y * this.width;
        int color1 = this.pixels[idx];
        int color2 = x + 1 >= this.width ? 0 : this.pixels[idx + 1];
        int color3 = x + 2 >= this.width ? 0 : this.pixels[idx + 2];
        int color4 = x + 3 >= this.width ? 0 : this.pixels[idx + 3];
        int color5 = x + 4 >= this.width ? 0 : this.pixels[idx + 4];
        int color6 = x + 5 >= this.width ? 0 : this.pixels[idx + 5];
        int color7 = x + 6 >= this.width ? 0 : this.pixels[idx + 6];
        int color8 = x + 7 >= this.width ? 0 : this.pixels[idx + 7];
        int result = (this.colorTable.getColor(color1) & 1) << 7 | (this.colorTable.getColor(color2) & 1) << 6 | (this.colorTable.getColor(color3) & 1) << 5 | (this.colorTable.getColor(color4) & 1) << 4 | (this.colorTable.getColor(color5) & 1) << 3 | (this.colorTable.getColor(color6) & 1) << 2 | (this.colorTable.getColor(color7) & 1) << 1 | this.colorTable.getColor(color8) & 1;
        return result;
    }

    private static ColorTable createDefaultColorTable(int[] pixels, int backGroundColor) {
        HashMap<Integer, Integer> ct = new HashMap<Integer, Integer>();
        int color = 0;
        if (backGroundColor >= 0) {
            ct.put(backGroundColor, color);
            ++color;
        }
        int i = 0;
        while (i < pixels.length && color < 4) {
            int col = pixels[i] & 0xFFFFFF;
            if (ct.get(col) == null) {
                ct.put(col, color);
                ++color;
            }
            ++i;
        }
        return new ColorTable(ct);
    }

    private static ColorTable createColorTable(int[] colorList) {
        HashMap<Integer, Integer> ct = new HashMap<Integer, Integer>();
        int color = 0;
        int i = 0;
        while (i < colorList.length) {
            int col = colorList[i] & 0xFFFFFF;
            if (ct.get(col) == null) {
                ct.put(col, color);
                ++color;
            }
            ++i;
        }
        return new ColorTable(ct);
    }

    public static abstract class PictureXYFunction
    extends Function {
        public PictureXYFunction(String name, Value invalidResult) {
            super(name, 3, invalidResult);
        }

        public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
            PictureValue pictureValue = (PictureValue)arguments[0];
            int x = arguments[1].getInt(debug);
            int y = arguments[2].getInt(debug);
            return this.f(pictureValue, x, y, debug);
        }

        protected abstract Value f(PictureValue var1, int var2, int var3, DebugInfo var4);
    }
}

