/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SEVariableAssignment;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidUnlockedSideEffectValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public abstract class ReferenceValue
extends SymbolScopeValue {
    protected Value value;

    protected ReferenceValue() {
    }

    public ReferenceValue(Value value) {
        this.value = value == null ? null : value.deReference();
    }

    public Value deReference() {
        return this.value;
    }

    public boolean keepInNextPass() {
        return false;
    }

    public void initBeforeParse() {
    }

    public void setValue(Value value, EvaluationState state, DebugInfo debug) {
        this.value = value.deReference();
        if (value.hasInvalidContent()) {
            state.setErrrorDuringFunctionEvaluation(true);
        }
        Value setValue = value.isLocked() ? value : new InvalidUnlockedSideEffectValue(debug);
        SEVariableAssignment sideEffect = new SEVariableAssignment(setValue, this);
        state.addSideEffect(sideEffect);
    }

    public void setWithoutSideEffect(Value value) {
        this.value = value;
    }

    public String getType() {
        return this.value.getType();
    }

    public Object getRepresentation(int representation) {
        return this.value.getRepresentation(representation);
    }

    public boolean hasRepresentation(int representation) {
        return this.value.hasRepresentation(representation);
    }

    public void lock(DebugInfo debug) {
        this.value.lock(debug);
    }

    public boolean isLocked() {
        return this.value.isLocked();
    }

    public boolean isInvalid() {
        return this.value.isInvalid();
    }

    public boolean hasInvalidContent() {
        return this.value.hasInvalidContent();
    }

    protected Value localGetVariable(String name, DebugInfo debug) {
        return this.value.localGetVariable(name, debug);
    }

    public FunctionTable getFunctions() {
        return new ReferenceFunctionTable();
    }

    private class ReferenceFunctionTable
    extends FunctionTable {
        private ReferenceFunctionTable() {
        }

        public Function get(String name, Value[] args, DebugInfo debug) {
            if (name.equals("=")) {
                return new Function("=", 2, null, true){

                    public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                        Value value = arguments[1];
                        if (ReferenceValue.this.isInvalid()) {
                            return value;
                        }
                        ReferenceValue.this.setValue(value, state, debug);
                        return value;
                    }
                };
            }
            if (name.equals("--")) {
                return new Function("--", 1, NumberValue.invalid){

                    public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                        Value refValue = ((ReferenceFunctionTable)ReferenceFunctionTable.this).ReferenceValue.this.value;
                        Value[] minusOneArgs = new Value[]{refValue, NumberValue.one};
                        Function minusFunction = refValue.getFunctions().get("-", minusOneArgs, debug);
                        ReferenceValue.this.setValue(minusFunction.execute(minusOneArgs, state, debug), state, debug);
                        return refValue;
                    }
                };
            }
            if (name.equals("++")) {
                return new Function("++", 1, NumberValue.invalid){

                    public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                        Value refValue = ((ReferenceFunctionTable)ReferenceFunctionTable.this).ReferenceValue.this.value;
                        Value[] plusOneArgs = new Value[]{refValue, NumberValue.one};
                        Function plusFunction = refValue.getFunctions().get("+", plusOneArgs, debug);
                        ReferenceValue.this.setValue(plusFunction.execute(plusOneArgs, state, debug), state, debug);
                        return refValue;
                    }
                };
            }
            return ReferenceValue.this.value.getFunctions().get(name, args, debug);
        }

        public boolean exist(String name, Value[] args) {
            throw NotImplementedException.intance;
        }
    }
}

