/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;

public class SidFileValue
extends ImmutableValue {
    public static Value invalid = new SidFileValue();
    private static int POS_HEADER = 0;
    private static int POS_DATAOFFSET = 6;
    private static int POS_LOADADDR = 8;
    private static int POS_INITADDR = 10;
    private static int POS_PLAYADDR = 12;
    private static int POS_SONGS = 14;
    private static int POS_STARTSONG = 16;
    private static int POS_NAME = 22;
    private static int POS_AUTHOR = 54;
    private static int POS_COPYRIGHT = 86;
    protected byte[] file;
    private int dataOffset;
    private int location;
    static FunctionTable functions = new StdFunctionTable(SidFileValue.getStandardFunctions());

    static {
        functions.add(new Function("getData", 2, NumberValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                SidFileValue sidFile = (SidFileValue)arguments[0];
                int idx = arguments[1].getInt(debug);
                if (idx < 0 || sidFile.file.length <= sidFile.dataOffset + idx) {
                    throw new AsmError("Index (" + idx + ") out of range", debug);
                }
                return new NumberValue(sidFile.file[sidFile.dataOffset + idx]);
            }
        });
    }

    public SidFileValue() {
        this.setInvalid();
    }

    public SidFileValue(byte[] file) {
        this.file = file;
        if (file[POS_HEADER] != 80 || file[POS_HEADER + 1] != 83 || file[POS_HEADER + 2] != 73 || file[POS_HEADER + 3] != 68) {
            throw new AsmError("Not a valid PSID file", null);
        }
        this.dataOffset = this.getInt(POS_DATAOFFSET, 2, file);
        this.location = this.getInt(POS_LOADADDR, 2, file);
        if (this.location == 0) {
            this.location = (file[this.dataOffset] & 0xFF) + 256 * (file[this.dataOffset + 1] & 0xFF);
            this.dataOffset += 2;
        }
    }

    public String getType() {
        return "SID file";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return "SID<\"" + this.getString(POS_NAME, 32, this.file) + "\">";
        }
        return null;
    }

    public Value localGetVariable(String name, DebugInfo debug) throws AsmException {
        if (name.equals("location")) {
            return new NumberValue(this.location);
        }
        if (name.equals("init")) {
            return new NumberValue(this.getInt(POS_INITADDR, 2, this.file));
        }
        if (name.equals("play")) {
            return new NumberValue(this.getInt(POS_PLAYADDR, 2, this.file));
        }
        if (name.equals("songs")) {
            return new NumberValue(this.getInt(POS_SONGS, 2, this.file));
        }
        if (name.equals("startSong")) {
            return new NumberValue(this.getInt(POS_STARTSONG, 2, this.file));
        }
        if (name.equals("name")) {
            return new StringValue(this.getString(POS_NAME, 32, this.file));
        }
        if (name.equals("author")) {
            return new StringValue(this.getString(POS_AUTHOR, 32, this.file));
        }
        if (name.equals("copyright")) {
            return new StringValue(this.getString(POS_COPYRIGHT, 32, this.file));
        }
        if (name.equals("size")) {
            return new NumberValue(this.file.length - this.dataOffset);
        }
        return null;
    }

    private int getInt(int offset, int size, byte[] file) {
        int value = 0;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                value <<= 8;
            }
            value += file[offset + i] & 0xFF;
            ++i;
        }
        return value;
    }

    private String getString(int offset, int maxSize, byte[] file) {
        char[] chars = new char[maxSize];
        int i = 0;
        while (i < maxSize && file[offset + i] != 0) {
            chars[i] = (char)file[offset + i];
            ++i;
        }
        return String.valueOf(chars, 0, i);
    }

    public FunctionTable getFunctions() {
        return functions;
    }
}

