/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.StringFunction;
import cml.kickass.function.StringX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.CharValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class StringValue
extends ImmutableValue {
    public static Value invalid = new StringValue();
    String string;
    static FunctionTable functions = new StdFunctionTable(StringValue.getStandardFunctions());

    static {
        functions.add(new StringX2Function("+", invalid){

            protected Value f(String a, String b) {
                return new StringValue(String.valueOf(a) + b);
            }
        });
        functions.add(new StringX2Function("==", BooleanValue.invalid){

            protected Value f(String a, String b) {
                return new BooleanValue(a.equals(b));
            }
        });
        functions.add(new StringX2Function("!=", BooleanValue.invalid){

            protected Value f(String a, String b) {
                return new BooleanValue(!a.equals(b));
            }
        });
        functions.add(new StringFunction("size", NumberValue.invalid){

            protected Value f(String a) {
                return new NumberValue(a.length());
            }
        });
        functions.add(new Function("charAt", 2, invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                String string = ((StringValue)arguments[0]).string;
                int i = arguments[1].getInt(debug);
                if (i < 0 || string.length() <= i) {
                    throw new AsmError("Index out of bounds: " + i, debug);
                }
                return new CharValue(string.charAt(i));
            }
        });
        functions.add(new Function("substring", 3, invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                String string = ((StringValue)arguments[0]).string;
                int i1 = arguments[1].getInt(debug);
                int i2 = arguments[2].getInt(debug);
                if (i1 < 0) {
                    throw new AsmError("Start index out of bounds: " + i1, debug);
                }
                if (i2 > string.length()) {
                    throw new AsmError("End index out of bounds: " + i2, debug);
                }
                if (i1 > i2) {
                    throw new AsmError("End index bigger than startindex: " + i1 + "," + i2, debug);
                }
                return new StringValue(string.substring(i1, i2));
            }
        });
    }

    private StringValue() {
        this.setInvalid();
    }

    public StringValue(String string) {
        this.string = string;
    }

    public String getType() {
        return this.isInvalid() ? "Invalid String" : "String";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == Value.RP_STRINGVALUE) {
            return this.string;
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }
}

