/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructValue
extends LockableValue {
    public static StructValue invalid = new StructValue();
    private String structName;
    private Map<String, Value> variables = new HashMap<String, Value>();
    static FunctionTable functions = new StdFunctionTable(StructValue.getStandardFunctions());
    private boolean checkingInvalidContent = false;

    private StructValue() {
        this.setInvalid();
        this.structName = "Invalid";
    }

    public StructValue(String structName, List<String> variableNames, Value[] initValues) {
        this.structName = structName;
        boolean hasInvalidContent = false;
        int i = 0;
        while (i < variableNames.size()) {
            String name = variableNames.get(i);
            NullValue value = initValues == null ? NullValue.instance : initValues[i];
            VariableReferenceValue refvalue = new VariableReferenceValue(value);
            this.variables.put(name, refvalue);
            ++i;
        }
        this.setHasInvalidContent(hasInvalidContent);
    }

    @Override
    public boolean hasInvalidContent() {
        if (this.checkingInvalidContent) {
            return false;
        }
        this.checkingInvalidContent = true;
        boolean result = false;
        for (Value value : this.variables.values()) {
            if (!value.hasInvalidContent()) continue;
            result = true;
            break;
        }
        this.checkingInvalidContent = false;
        return result;
    }

    @Override
    public String getType() {
        return "struct";
    }

    @Override
    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return String.valueOf(this.structName) + "-struct";
        }
        return null;
    }

    @Override
    public Value localGetVariable(String name, DebugInfo debug) throws AsmException {
        if (this.isInvalid()) {
            return InvalidValue.instance;
        }
        return this.variables.get(name);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debug) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value variable : this.variables.values()) {
            variable.lock(debug);
        }
    }
}

