/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.Argument;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Lockable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Lockable {
    private boolean isInvalid = false;
    private boolean hasInvalidContent = false;
    public static int RP_DOUBLEVALUE = 1;
    public static int RP_STRINGVALUE = 2;
    public static int RP_BOOLEANVALUE = 3;
    public static int RP_MATRIXVALUE = 4;
    public static int RP_VECTORVALUE = 5;
    public static int RP_LISTVALUE = 6;
    public static int RP_ASMARGVALUE = 7;
    static FunctionTable functions = new StdFunctionTable();

    static {
        functions.add(new Function("lock", 1, null, true){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                arguments[0].lock(debug);
                return arguments[0];
            }
        });
    }

    public abstract String getType();

    public abstract Object getRepresentation(int var1);

    public boolean hasRepresentation(int representation) {
        return this.getRepresentation(representation) != null;
    }

    public abstract FunctionTable getFunctions();

    protected Value localGetVariable(String name, DebugInfo debug) {
        return null;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    protected void setInvalid() {
        this.isInvalid = true;
        this.setHasInvalidContent(true);
    }

    protected void setHasInvalidContent(boolean invalidContent) {
        this.hasInvalidContent = invalidContent;
    }

    public Value deReference() {
        return this;
    }

    protected static StdFunctionTable getStandardFunctions() {
        return (StdFunctionTable)functions;
    }

    public Argument getCmdArgument(DebugInfo debug) {
        Argument s = (Argument)this.getRepresentation(RP_ASMARGVALUE);
        if (s == null) {
            throw new AsmError("Can't get a command argument from a value of type " + this.getType(), debug);
        }
        return s;
    }

    public String getString(DebugInfo debug) {
        String s = (String)this.getRepresentation(RP_STRINGVALUE);
        if (s == null) {
            throw new AsmError("Can't get a string representation from a value of type " + this.getType(), debug);
        }
        return s;
    }

    public boolean getBoolean(DebugInfo debug) {
        Boolean b = (Boolean)this.getRepresentation(RP_BOOLEANVALUE);
        if (b == null) {
            throw new AsmError("Can't get a boolean representation from a value of type " + this.getType(), debug);
        }
        return b;
    }

    public double getDouble(DebugInfo debug) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debug);
        }
        return d;
    }

    public int getInt(DebugInfo debug) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debug);
        }
        return d.intValue();
    }

    public long getLong(DebugInfo debug) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debug);
        }
        return d.longValue();
    }

    public double[] getVector(DebugInfo debug) {
        double[] v = (double[])this.getRepresentation(RP_VECTORVALUE);
        if (v == null) {
            throw new AsmError("Can't get a vector representation from a value of type " + this.getType(), debug);
        }
        return v;
    }

    public ArrayList<Value> getList(DebugInfo debug) {
        ArrayList list = (ArrayList)this.getRepresentation(RP_LISTVALUE);
        if (list == null) {
            throw new AsmError("Can't get a list representation from a value of type " + this.getType(), debug);
        }
        return list;
    }

    public Value getVariable(String name, DebugInfo debug) {
        Value result = this.localGetVariable(name, debug);
        if (result == null) {
            throw new AsmError("Variable '" + name + "' not present on value of type '" + this.getType() + "'", debug);
        }
        return result;
    }
}

