/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.VectorDoubleFunction;
import cml.kickass.function.VectorFunction;
import cml.kickass.function.VectorX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class VectorValue
extends ImmutableValue {
    public static VectorValue invalid = new VectorValue();
    private double[] values = new double[3];
    static FunctionTable functions = new StdFunctionTable(VectorValue.getStandardFunctions());

    static {
        functions.add(new Function("get", 2, NumberValue.invalid){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                VectorValue vector = (VectorValue)arguments[0];
                int idx = arguments[1].getInt(debug);
                if (idx < 0 || 3 <= idx) {
                    throw new AsmError("Invalid index : " + idx, debug);
                }
                return new NumberValue(vector.values[idx]);
            }
        });
        functions.add(new Function("*", 2, InvalidValue.instance){

            public Value execute(Value[] arguments, EvaluationState state, DebugInfo debug) {
                double[] values = ((VectorValue)arguments[0]).values;
                if (arguments[1].hasRepresentation(RP_VECTORVALUE)) {
                    double[] v2 = arguments[1].getVector(debug);
                    return new NumberValue(values[0] * v2[0] + values[1] * v2[1] + values[2] * v2[2]);
                }
                if (arguments[1].hasRepresentation(RP_DOUBLEVALUE)) {
                    double k = arguments[1].getDouble(debug);
                    return new VectorValue(values[0] * k, values[1] * k, values[2] * k);
                }
                throw new AsmError("Invalid argument. Can't get vector or number representation.", debug);
            }
        });
        functions.add(new VectorFunction("getX", NumberValue.invalid){

            protected Value f(double[] a) {
                return new NumberValue(a[0]);
            }
        });
        functions.add(new VectorFunction("getY", NumberValue.invalid){

            protected Value f(double[] a) {
                return new NumberValue(a[1]);
            }
        });
        functions.add(new VectorFunction("getZ", NumberValue.invalid){

            protected Value f(double[] a) {
                return new NumberValue(a[2]);
            }
        });
        functions.add(new VectorX2Function("+", invalid){

            protected Value f(double[] a, double[] b) {
                return new VectorValue(a[0] + b[0], a[1] + b[1], a[2] + b[2]);
            }
        });
        functions.add(new VectorX2Function("-", invalid){

            protected Value f(double[] a, double[] b) {
                return new VectorValue(a[0] - b[0], a[1] - b[1], a[2] - b[2]);
            }
        });
        functions.add(new VectorDoubleFunction("/", invalid){

            protected Value f(double[] a, double b) {
                return new VectorValue(a[0] / b, a[1] / b, a[2] / b);
            }
        });
        functions.add(new VectorX2Function("X", invalid){

            protected Value f(double[] a, double[] b) {
                return new VectorValue(a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]);
            }
        });
        functions.add(new VectorX2Function("==", BooleanValue.invalid){

            protected Value f(double[] a, double[] b) {
                return new BooleanValue(a[0] == b[0] && a[1] == b[1] && a[2] == b[2]);
            }
        });
        functions.add(new VectorX2Function("!=", BooleanValue.invalid){

            protected Value f(double[] a, double[] b) {
                return new BooleanValue(a[0] != b[0] || a[1] != b[1] || a[2] != b[2]);
            }
        });
    }

    private VectorValue() {
        this.setInvalid();
    }

    public VectorValue(double[] values) {
        int i = 0;
        while (i < 3) {
            this.values[i] = values[i];
            ++i;
        }
    }

    public VectorValue(double x, double y, double z) {
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
    }

    public String getType() {
        return "Vector";
    }

    public Object getRepresentation(int representation) throws AsmException {
        if (representation == RP_STRINGVALUE) {
            return "(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
        }
        if (representation == RP_VECTORVALUE) {
            return this.values.clone();
        }
        return null;
    }

    public FunctionTable getFunctions() {
        return functions;
    }

    public String toString() {
        return "Vector(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
    }
}

