/*
 * Decompiled with CFR 0.152.
 */
package cml.log;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Log {
    private static boolean debuggingOn = false;
    private static boolean warningsOn = true;
    private static List<PrintStream> printStreams = new ArrayList<PrintStream>();
    private String classname;

    public static void setDebugging(boolean flag) {
        debuggingOn = flag;
    }

    public static void setWarnings(boolean flag) {
        warningsOn = flag;
    }

    public void addPrintStream(PrintStream stream) {
        printStreams.add(stream);
    }

    private void printlnToAllStreams(String str) {
        int i = 0;
        while (i < printStreams.size()) {
            printStreams.get(i).println(str);
            ++i;
        }
    }

    public Log(String classname) {
        this.classname = classname;
    }

    public void println() {
        this.printlnToAllStreams("");
    }

    public void println(String s) {
        this.printlnToAllStreams(s);
    }

    public void mark(String s) {
        if (debuggingOn) {
            this.printlnToAllStreams(s);
        }
    }

    public void warn(String s) {
        if (warningsOn) {
            this.printlnToAllStreams(s);
        }
    }

    public void error(Exception e) {
        this.printlnToAllStreams(e.getMessage());
        if (debuggingOn) {
            e.printStackTrace(System.out);
        }
    }

    public void error(String msg) {
        this.printlnToAllStreams(msg);
    }
}

