/*
 * Decompiled with CFR 0.152.
 */
package cml.math;

public class Matrix {
    private int columns;
    private int rows;
    private double[] entries;

    public Matrix(int rows, int columns, double[] entries) {
        if (rows * columns != entries.length) {
            throw new RuntimeException("Invalid number of entries");
        }
        this.columns = columns;
        this.rows = rows;
        this.entries = entries;
    }

    protected Matrix(Matrix matrix) {
        this.columns = matrix.columns;
        this.rows = matrix.rows;
        this.entries = (double[])matrix.entries.clone();
    }

    public double get(int m, int n) {
        return this.entries[m * this.columns + n];
    }

    protected void set(int m, int n, double value) {
        this.entries[m * this.columns + n] = value;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    private void RowMul(int row, double k, int startCollum) {
        int nn = startCollum;
        while (nn < this.columns) {
            this.set(row, nn, k * this.get(row, nn));
            ++nn;
        }
    }

    private void RowSubMul(int tarRow, int srcRow, double k, int startCollum) {
        int nn = startCollum;
        while (nn < this.columns) {
            this.set(tarRow, nn, this.get(tarRow, nn) - k * this.get(srcRow, nn));
            ++nn;
        }
    }

    private void SwapRows(int row1, int row2, int startCollum) {
        int n = startCollum;
        while (n < this.columns) {
            double tmp = this.get(row1, n);
            this.set(row1, n, this.get(row2, n));
            this.set(row2, n, tmp);
            ++n;
        }
    }

    public Matrix solve() {
        Matrix m = new Matrix(this);
        m.internalSolve();
        return m;
    }

    private Solution internalSolve() {
        int row = 0;
        int col = 0;
        while (col < this.columns - 1 && row < this.rows) {
            int okRow = row;
            while (this.get(okRow, col) == 0.0 && okRow < this.rows) {
                ++okRow;
            }
            if (okRow != this.rows) {
                if (okRow != row) {
                    this.SwapRows(row, okRow, col);
                }
                this.RowMul(row, 1.0 / this.get(row, col), col + 1);
                this.set(row, col, 1.0);
                int mm = row + 1;
                while (mm < this.rows) {
                    if (this.get(mm, col) != 0.0) {
                        this.RowSubMul(mm, row, this.get(mm, col), col + 1);
                        this.set(mm, col, 0.0);
                    }
                    ++mm;
                }
                ++row;
            }
            ++col;
        }
        int testRow = row;
        while (testRow < this.rows) {
            if (this.get(testRow, this.rows - 1) != 0.0) {
                return Solution.NO_SOLUTION;
            }
            ++testRow;
        }
        int reduceCol = this.columns - 1;
        int reduceRow = row - 1;
        while (reduceRow > 0) {
            reduceCol = 0;
            while (this.get(reduceRow, reduceCol) == 0.0) {
                ++reduceCol;
            }
            int r = 0;
            while (r < reduceRow) {
                this.set(r, this.columns - 1, this.get(r, this.columns - 1) - this.get(r, reduceCol) * this.get(reduceRow, this.columns - 1));
                this.set(r, reduceCol, 0.0);
                ++r;
            }
            --reduceRow;
        }
        if (row >= this.rows - 1) {
            return Solution.ONE_SOLUTION;
        }
        return Solution.INF_SOLUTIONS;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int m = 0;
        while (m < this.rows) {
            sb.append("[");
            int n = 0;
            while (n < this.columns) {
                sb.append(this.get(m, n));
                if (n != this.columns - 1) {
                    sb.append(", ");
                }
                ++n;
            }
            sb.append("]\n");
            ++m;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Solution {
        NO_SOLUTION,
        ONE_SOLUTION,
        INF_SOLUTIONS;

    }
}

