/*
 * Decompiled with CFR 0.152.
 */
package cml.tools;

import cml.log.Log;
import java.util.ArrayList;
import java.util.List;

public class Timer {
    static Log log = new Log("Timer");
    static List<Timer> timers = new ArrayList<Timer>();
    private long startTime = 0L;
    private long timeSoFar = 0L;
    private long noOfCalls = 0L;
    private String name;

    public static void printTimers() {
        for (Timer timer : timers) {
            log.mark(timer.toString());
        }
    }

    public Timer(String name) {
        this.name = name;
        timers.add(this);
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void stop() {
        this.timeSoFar += System.nanoTime() - this.startTime;
        ++this.noOfCalls;
    }

    public long getTimeInMs() {
        return this.timeSoFar / 1000000L;
    }

    public String toString() {
        return this.name + "=" + this.getTimeInMs() + "ms (" + this.noOfCalls + " calls)";
    }
}

