/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AdderGenerationTask
extends Task {
    String finalString = "";
    String outputDir;
    String inputFile;
    String worldName;
    ArrayList<String> type = new ArrayList();
    ArrayList<String> x = new ArrayList();
    ArrayList<String> xMsb = new ArrayList();
    ArrayList<String> y = new ArrayList();
    ArrayList<String> color = new ArrayList();
    ArrayList<String> user1 = new ArrayList();
    ArrayList<String> user2 = new ArrayList();
    Map<String, String> definitions = new HashMap<String, String>();
    Map<String, String> commonDefinitions = new HashMap<String, String>();
    ArrayList<String> usedDefinitions = new ArrayList();

    public void setWorldname(String name) {
        this.worldName = name;
    }

    public void setOutputDir(String filename) {
        this.outputDir = filename;
    }

    public void setInputFile(String filename) {
        this.inputFile = filename;
    }

    public void execute() throws BuildException {
        try {
            this.validate();
            this.loadDefinitions();
            int i = 0;
            while (i < 10) {
                this.type.clear();
                this.x.clear();
                this.xMsb.clear();
                this.y.clear();
                this.color.clear();
                this.user1.clear();
                this.user2.clear();
                this.convert(i);
                ++i;
            }
            this.save();
        }
        catch (Exception e) {
            throw new BuildException(e.toString());
        }
    }

    private void loadDefinition(BufferedReader br, Map def) {
        boolean done = false;
        while (!done) {
            try {
                String line = br.readLine();
                if (line != null) {
                    String[] row = line.split("=");
                    if (row.length != 2) continue;
                    this.addDefinition(row, def);
                    continue;
                }
                done = true;
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                done = true;
            }
        }
    }

    private void loadDefinitions() {
        FileReader is2;
        FileReader is;
        try {
            is = new FileReader(String.valueOf(this.inputFile) + "/object_definition_enemies.txt");
            is2 = new FileReader(String.valueOf(this.inputFile) + "/object_definition_common.txt");
        }
        catch (FileNotFoundException e1) {
            return;
        }
        BufferedReader br = new BufferedReader(is);
        this.loadDefinition(br, this.definitions);
        br = new BufferedReader(is2);
        this.loadDefinition(br, this.commonDefinitions);
        this.getIntegerFor("OBJECT_NONE");
        Set<String> set = this.commonDefinitions.keySet();
        for (String key : set) {
            System.out.println("######## " + key);
            this.getIntegerFor(key);
        }
    }

    private void addDefinition(String[] row, Map<String, String> def) {
        String property = row[0].trim();
        String value = row[1].trim();
        def.put(property, value);
    }

    private void convert(int index) {
        FileReader is;
        try {
            is = new FileReader(String.valueOf(this.inputFile) + "/" + this.worldName + "/adder/adder" + index + ".txt");
        }
        catch (FileNotFoundException e1) {
            return;
        }
        BufferedReader br = new BufferedReader(is);
        boolean done = false;
        while (!done) {
            try {
                String line = br.readLine();
                if (line != null) {
                    String[] row = line.split(",");
                    if (row.length == 6) {
                        this.process(row);
                        continue;
                    }
                    if (row.length != 1 || !"OBJECT_NONE".equals(row[0])) continue;
                    this.process(new String[]{"OBJECT_NONE", "0", "0", "0", "0", "0"});
                    continue;
                }
                done = true;
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                done = true;
            }
        }
        this.addStage(index);
    }

    private void process(String[] row) {
        try {
            String object = row[0].trim();
            int xpos = Integer.parseInt(row[1].trim());
            int ypos = Integer.parseInt(row[2].trim());
            int col = Integer.parseInt(row[3].trim());
            int usr1 = Integer.parseInt(row[4].trim());
            int usr2 = Integer.parseInt(row[5].trim());
            int objectInt = this.getIntegerFor(object);
            this.type.add("" + objectInt);
            this.x.add("" + xpos % 256);
            this.xMsb.add("" + xpos / 256);
            this.y.add("" + ypos);
            this.color.add("" + col);
            this.user1.add("" + usr1);
            this.user2.add("" + usr2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getIntegerFor(String object) {
        int index = this.usedDefinitions.indexOf(object);
        if (index == -1) {
            this.usedDefinitions.add(object);
            return this.usedDefinitions.indexOf(object) * 2;
        }
        return index * 2;
    }

    private void addToFinalString(String str) {
        this.finalString = String.valueOf(this.finalString) + str;
    }

    private void createOutput(ArrayList<String> list) {
        Iterator<String> output = list.iterator();
        while (output.hasNext()) {
            this.addToFinalString(output.next());
            if (!output.hasNext()) continue;
            this.addToFinalString(", ");
        }
    }

    private void addStage(int index) {
        this.addToFinalString("\n// ### Room: " + index + "\n");
        this.addToFinalString("\n//objecttypes:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.type);
        this.addToFinalString("\n//objectxpos:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.x);
        this.addToFinalString("\n//objectxpos_msb:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.xMsb);
        this.addToFinalString("\n//objectypos:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.y);
        this.addToFinalString("\n//objectcolor:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.color);
        this.addToFinalString("\n//objectuser1:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.user1);
        this.addToFinalString("\n//objectuser2:\n");
        this.addToFinalString("\t.byte ");
        this.createOutput(this.user2);
    }

    private void save() throws Exception {
        System.out.println(this.finalString);
        FileOutputStream fl = new FileOutputStream(String.valueOf(this.outputDir) + "/" + this.worldName + "/adder.asm");
        DataOutputStream dos = new DataOutputStream(fl);
        dos.writeBytes(this.finalString);
        dos.close();
        fl = new FileOutputStream(String.valueOf(this.outputDir) + "/" + this.worldName + "/constants.asm");
        dos = new DataOutputStream(fl);
        dos.writeBytes(this.getConstants());
        dos.close();
    }

    private String getConstants() {
        String key2;
        String constants = "";
        int objNo = 0;
        for (String key2 : this.usedDefinitions) {
            constants = String.valueOf(constants) + "\n\t.const " + key2 + " = " + objNo;
            objNo += 2;
        }
        constants = String.valueOf(constants) + "\n";
        objNo = 1;
        constants = String.valueOf(constants) + "\n_world_object_pointer_list:";
        constants = String.valueOf(constants) + "\n\t.word 0";
        Iterator<String> keys = this.usedDefinitions.iterator();
        if (keys.hasNext()) {
            keys.next();
        }
        while (keys.hasNext()) {
            key2 = keys.next();
            constants = String.valueOf(constants) + "\n\t.word _label_" + objNo;
            ++objNo;
        }
        constants = String.valueOf(constants) + "\n";
        objNo = 1;
        keys = this.usedDefinitions.iterator();
        if (keys.hasNext()) {
            keys.next();
        }
        while (keys.hasNext()) {
            key2 = keys.next();
            String val = this.definitions.get(key2);
            if (val == null) {
                val = this.commonDefinitions.get(key2);
            }
            constants = String.valueOf(constants) + "\n_label_" + objNo + ":";
            constants = String.valueOf(constants) + "\n\t.import source " + val;
            ++objNo;
        }
        return constants;
    }

    private void validate() throws BuildException {
        if (this.outputDir == null) {
            throw new BuildException("Attribute outputDir has not been set");
        }
        if (this.inputFile == null) {
            throw new BuildException("Attribute inputFile has not been set");
        }
        if (this.worldName == null) {
            throw new BuildException("Attribute worldName has not been set");
        }
    }
}

