/*
 * Decompiled with CFR 0.152.
 */
import helpers.Palette;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.tools.ant.BuildException;

public class Font16CreatorTask {
    private String inputFile = null;
    private String outputFile = null;
    BufferedImage png;
    int[] data;

    public void setInputFile(String filename) {
        this.inputFile = filename;
    }

    public void setOutputFile(String filename) {
        this.outputFile = filename;
    }

    public void execute() throws BuildException {
        try {
            this.validate();
            this.loadFiles();
            this.convert();
            this.save();
        }
        catch (Exception e) {
            throw new BuildException(e.toString());
        }
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.outputFile);
            DataOutputStream dos = new DataOutputStream(fos);
            int i = 0;
            while (i < this.data.length) {
                dos.write(this.data[i]);
                ++i;
            }
            dos.close();
        }
        catch (Exception e) {
            System.out.println("Write error: ");
            e.printStackTrace();
        }
    }

    public void convert() {
        System.out.println("width: " + this.png.getWidth());
        System.out.println("height: " + this.png.getHeight());
        int numberOfChars = this.png.getWidth() / 16;
        this.data = new int[32 * numberOfChars];
        int j = 0;
        int x = 0;
        while (x < this.png.getWidth()) {
            int y = 0;
            while (y < this.png.getHeight()) {
                int dat = 0;
                int a = 6;
                int i = 0;
                while (i < 8) {
                    int col = this.png.getRGB(x + i, y) & 0xFFFFFF;
                    dat |= this.getBitPair(col) << a;
                    a -= 2;
                    i += 2;
                }
                this.data[j] = dat;
                System.out.println("" + this.data[j]);
                ++j;
                ++y;
            }
            x += 8;
        }
    }

    public int getBitPair(int value) {
        int i = 0;
        while (i < 16) {
            if (Palette.PALETTE[i] == value) {
                if (i == 0) {
                    return 3;
                }
                if (i == 11) {
                    return 1;
                }
                if (i == 15) {
                    return 2;
                }
                return 0;
            }
            ++i;
        }
        return 0;
    }

    private void loadFiles() {
        try {
            System.out.println("loading" + this.inputFile);
            this.png = ImageIO.read(new File(this.inputFile));
        }
        catch (Exception e) {
            System.out.println("load error");
        }
    }

    private void validate() throws BuildException {
        if (this.inputFile == null) {
            throw new BuildException("Attribute inputFile has not been set");
        }
        if (this.outputFile == null) {
            throw new BuildException("Attribute outputFile has not been set");
        }
    }
}

