/*
 * Decompiled with CFR 0.152.
 */
import helpers.Characters;
import helpers.Room;
import helpers.Tiles;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Png2CharsTask
extends Task {
    private String inputFile = null;
    private String outputFile = null;
    private ArrayList<Object> rooms = new ArrayList();
    private Characters chars = new Characters();
    private Tiles tiles = new Tiles();

    public void setInputFile(String filename) {
        this.inputFile = filename;
    }

    public void setOutputFile(String filename) {
        this.outputFile = filename;
    }

    public void execute() throws BuildException {
        try {
            this.validate();
            this.loadFiles();
            this.convert();
            this.save();
        }
        catch (Exception e) {
            throw new BuildException(e.toString());
        }
    }

    public void save() {
        this.chars.print();
        this.tiles.print();
        this.printRooms();
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(this.outputFile) + "bkg");
            DataOutputStream dos = new DataOutputStream(fos);
            this.saveRooms(dos);
            dos.close();
            fos = new FileOutputStream(String.valueOf(this.outputFile) + "stil");
            dos = new DataOutputStream(fos);
            this.tiles.writeSmall(dos);
            dos.close();
            fos = new FileOutputStream(String.valueOf(this.outputFile) + "ltil");
            dos = new DataOutputStream(fos);
            this.tiles.writeLarge(dos);
            dos.close();
            fos = new FileOutputStream(String.valueOf(this.outputFile) + "chars");
            dos = new DataOutputStream(fos);
            this.chars.write(dos);
            dos.close();
        }
        catch (Exception e) {
            System.out.println("Write error: ");
            e.printStackTrace();
        }
    }

    public void convert() {
        for (Room room : this.rooms) {
            room.convert(this.chars, this.tiles);
        }
    }

    public void printRooms() {
        int a = 0;
        for (Room room : this.rooms) {
            System.out.println("Room: " + a);
            room.print();
            ++a;
        }
    }

    public void saveRooms(DataOutputStream dos) throws IOException {
        boolean a = false;
        dos.write(this.rooms.size());
        for (Room room : this.rooms) {
            room.save(dos);
        }
    }

    private void loadFiles() {
        int i = 0;
        boolean done = false;
        while (!done) {
            Room room = new Room();
            try {
                room.loadImage(this.inputFile, i);
                room.loadColorDefinitions(this.inputFile, i);
                this.rooms.add(room);
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
    }

    private void validate() throws BuildException {
        if (this.inputFile == null) {
            throw new BuildException("Attribute inputFile has not been set");
        }
        if (this.outputFile == null) {
            throw new BuildException("Attribute outputFile has not been set");
        }
    }
}

