/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.Palette;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.IOException;

public class Character {
    private int[] data = new int[8];

    public Character(int fill) {
        int i = 0;
        while (i < 8) {
            this.data[i] = fill;
            ++i;
        }
    }

    public Character(int[] _data) {
        int i = 0;
        while (i < 8) {
            this.data[i] = _data[i];
            ++i;
        }
    }

    public Character(BufferedImage img, int x, int y, Palette palette) {
        int j = 0;
        while (j < 8) {
            int dat = 0;
            int a = 6;
            int i = 0;
            while (i < 8) {
                int col = img.getRGB(x + i, y + j) & 0xFFFFFF;
                dat |= palette.getBitPair(col, y) << a;
                a -= 2;
                i += 2;
            }
            this.data[j] = dat;
            ++j;
        }
    }

    public int getData(int index) {
        return this.data[index];
    }

    public void print() {
        System.out.print("\t");
        int i = 0;
        while (i < 8) {
            System.out.print(String.valueOf(this.data[i]) + ", ");
            ++i;
        }
        System.out.println("");
    }

    public boolean equals(Character chara) {
        int i = 0;
        while (i < 8) {
            if (this.data[i] != chara.getData(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void write(DataOutputStream dos) throws IOException {
        int i = 0;
        while (i < this.data.length) {
            dos.write(this.data[i]);
            ++i;
        }
    }
}

