/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.ColorDefinition;
import java.io.DataOutputStream;
import java.io.IOException;

public class Palette {
    public static final int[] PALETTE;
    private static final int[] COORD_TO_LINE;
    ColorDefinition[] colorDefinitions = new ColorDefinition[9];

    static {
        int[] nArray = new int[16];
        nArray[1] = 0xFFFFFF;
        nArray[2] = 6829867;
        nArray[3] = 7382194;
        nArray[4] = 7290246;
        nArray[5] = 5803331;
        nArray[6] = 3483769;
        nArray[7] = 12109679;
        nArray[8] = 7294757;
        nArray[9] = 4405504;
        nArray[10] = 10119001;
        nArray[11] = 0x444444;
        nArray[12] = 0x6C6C6C;
        nArray[13] = 10146436;
        nArray[14] = 7102133;
        nArray[15] = 0x959595;
        PALETTE = nArray;
        int[] nArray2 = new int[25];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 3;
        nArray2[11] = 4;
        nArray2[12] = 4;
        nArray2[13] = 4;
        nArray2[14] = 5;
        nArray2[15] = 5;
        nArray2[16] = 5;
        nArray2[17] = 6;
        nArray2[18] = 6;
        nArray2[19] = 6;
        nArray2[20] = 7;
        nArray2[21] = 7;
        nArray2[22] = 7;
        nArray2[23] = 8;
        nArray2[24] = 8;
        COORD_TO_LINE = nArray2;
    }

    public Palette() {
        int i = 0;
        while (i < 9) {
            this.colorDefinitions[i] = new ColorDefinition();
            ++i;
        }
    }

    public void add(String lineCol, String value) {
        int iColType = lineCol.indexOf(46) + 1;
        int iLine = lineCol.indexOf(46) - 1;
        String col = lineCol.substring(iColType, lineCol.length());
        String line = lineCol.substring(iLine, iLine + 1);
        int lin = Integer.parseInt(line);
        this.colorDefinitions[lin].add(col.trim(), value.trim());
    }

    public int getBitPair(int value, int y) {
        int line = COORD_TO_LINE[y / 8];
        int i = 0;
        while (i < 16) {
            if (PALETTE[i] == value) {
                return this.colorDefinitions[line].getBitPair(i);
            }
            ++i;
        }
        return 0;
    }

    public void print() {
        int i = 0;
        while (i < 9) {
            System.out.println("\tLine " + i);
            this.colorDefinitions[i].print();
            ++i;
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        int i = 0;
        while (i < 9) {
            this.colorDefinitions[i].write(dos);
            ++i;
        }
    }
}

