/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.Character;
import helpers.Characters;
import helpers.Palette;
import helpers.Tile;
import helpers.TileLarge;
import helpers.Tiles;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Room {
    private String file;
    private BufferedImage png;
    private int width;
    private int height;
    Palette palette;
    int[] roomInCharacters;
    int widthInChars;
    int heightInChars;
    int[] roomInTiles;
    int widthInTiles;
    int heightInTiles;
    int[] roomInLargeTiles;
    int widthInLargeTiles;

    public void loadImage(String filename, int number) throws IOException {
        this.file = String.valueOf(filename) + "_" + number + ".png";
        System.out.println("Reading File: " + this.file);
        this.png = ImageIO.read(new File(this.file));
        this.width = this.png.getWidth();
        this.height = this.png.getHeight();
        this.widthInChars = this.width / 8;
        this.heightInChars = this.height / 8;
        this.widthInTiles = this.widthInChars / 4;
        this.heightInTiles = this.heightInChars / 5;
        this.widthInLargeTiles = this.widthInTiles;
        if (this.height != 200) {
            System.out.println("Invalid image height: " + this.height);
            throw new IOException();
        }
        if (this.widthInChars % 4 != 0) {
            System.out.println("Invalid image width: " + this.width);
            throw new IOException();
        }
        this.palette = new Palette();
        this.roomInCharacters = new int[this.widthInChars * this.heightInChars];
        System.out.println("roomInCharacters len " + this.roomInCharacters.length);
        this.roomInTiles = new int[this.widthInTiles * this.heightInTiles];
        System.out.println("roomInTiles len " + this.roomInTiles.length);
        this.roomInLargeTiles = new int[this.widthInLargeTiles];
        System.out.println("roomInLargeTiles len " + this.roomInLargeTiles.length);
    }

    public void loadColorDefinitions(String filename, int number) {
        String pFile = String.valueOf(filename) + "_" + number + ".properties";
        System.out.println("Reading File: " + pFile);
        FileReader file = null;
        try {
            file = new FileReader(pFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        BufferedReader br = new BufferedReader(file);
        boolean done = false;
        while (!done) {
            try {
                String line = br.readLine();
                if (line != null) {
                    String[] props = line.split("=");
                    if (props.length != 2) continue;
                    props[0].trim();
                    props[1].trim();
                    this.palette.add(props[0], props[1]);
                    continue;
                }
                done = true;
            }
            catch (IOException e) {
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                done = true;
            }
        }
    }

    public void convert(Characters chars, Tiles tiles) {
        int i;
        System.out.println("Creating chars for " + this.file);
        int a = 0;
        int j = 0;
        while (j < this.height) {
            i = 0;
            while (i < this.width) {
                Character chr = new Character(this.png, i, j, this.palette);
                this.roomInCharacters[a] = chars.checkAndAdd(chr);
                ++a;
                i += 8;
            }
            j += 8;
        }
        System.out.println("Creating Small tiles for " + this.file);
        a = 0;
        j = 0;
        while (j < this.heightInChars) {
            i = 0;
            while (i < this.widthInChars) {
                Tile tile = new Tile(this.roomInCharacters, i, j, this.widthInChars);
                this.roomInTiles[a] = tiles.checkAndAddSmall(tile);
                ++a;
                i += 4;
            }
            j += 5;
        }
        System.out.println("Creating Large tiles for " + this.file);
        a = 0;
        int i2 = 0;
        while (i2 < this.widthInTiles) {
            TileLarge tile = new TileLarge(this.roomInTiles, i2, this.widthInTiles);
            this.roomInLargeTiles[a] = tiles.checkAndAddLarge(tile);
            ++a;
            ++i2;
        }
    }

    public void print() {
        int a = 0;
        System.out.println("Room (in large tiles):");
        int i = 0;
        while (i < this.widthInLargeTiles) {
            System.out.print(" " + this.roomInLargeTiles[a]);
            ++a;
            ++i;
        }
        System.out.println();
        System.out.println("Room Size (chars): " + this.widthInChars + "x" + this.heightInChars);
        System.out.println("Room Size (tiles): " + this.widthInTiles + "x" + this.heightInTiles);
        System.out.println("Room Size (ltiles): " + this.widthInLargeTiles + "x1");
        System.out.println("Total size (bytes): " + this.widthInTiles + " bytes");
    }

    public void save(DataOutputStream dos) throws IOException {
        boolean a = false;
        this.palette.write(dos);
        dos.write(this.widthInLargeTiles);
        int i = 0;
        while (i < this.widthInLargeTiles) {
            dos.write(this.roomInLargeTiles[i]);
            ++i;
        }
    }
}

