/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.Tile;
import helpers.TileLarge;
import java.io.DataOutputStream;
import java.io.IOException;

public class Tiles {
    public static final int CHAR_SIZE_PX = 8;
    public static final int TILE_WIDTH_CH = 4;
    public static final int TILE_WIDTH_PX = 32;
    public static final int TILE_HEIGHT_SMALL_CH = 5;
    public static final int TILE_HEIGHT_SMALL_PX = 40;
    private Tile[] tilesSmall = new Tile[256];
    private int currentSmallTile = 0;
    private TileLarge[] tilesLarge = new TileLarge[256];
    private int currentLargeTile = 0;

    public int checkAndAddSmall(Tile tile) {
        int i = 0;
        while (i < this.currentSmallTile) {
            if (this.tilesSmall[i].equals(tile)) {
                return i;
            }
            ++i;
        }
        return this.addSmall(tile);
    }

    public int addSmall(Tile tile) {
        this.tilesSmall[this.currentSmallTile] = tile;
        ++this.currentSmallTile;
        return this.currentSmallTile - 1;
    }

    public int checkAndAddLarge(TileLarge tile) {
        int i = 0;
        while (i < this.currentLargeTile) {
            if (this.tilesLarge[i].equals(tile)) {
                return i;
            }
            ++i;
        }
        return this.addLarge(tile);
    }

    public int addLarge(TileLarge tile) {
        this.tilesLarge[this.currentLargeTile] = tile;
        ++this.currentLargeTile;
        return this.currentLargeTile - 1;
    }

    public void print() {
        System.out.println("Number of small tiles: " + this.currentSmallTile + " (" + this.currentSmallTile * 4 * 5 + " bytes)");
        System.out.println("Number of large tiles: " + this.currentLargeTile + " (" + this.currentLargeTile * 5 + " bytes)");
    }

    public void writeSmall(DataOutputStream dos) throws IOException {
        int i = 0;
        while (i < this.currentSmallTile) {
            this.tilesSmall[i].write(dos);
            ++i;
        }
    }

    public void writeLarge(DataOutputStream dos) throws IOException {
        int i = 0;
        while (i < this.currentLargeTile) {
            this.tilesLarge[i].write(dos);
            ++i;
        }
    }
}

