; =====================================================
;
; DEPAK2.ASM
;
; Decompaction routines written for the
; PAK (repeated strings) encoding scheme
;
; Written  by Carl Muller 11 Mar 1991
; Modified by Carl Muller  1 May 1991
;
; SYS 2066 will work even if BASIC is not set up.
;
; =====================================================
;
; This program is BASIC hostile.
; There is a header of six bytes - size, start and execute
; addresses - in the packed data.
; This program unpaks a machine code program starting
; from the start address ($0100 upwards) and executes it.
; The machine code program will need to set up the machine
; for itself if necessary. (e.g. reenable IRQs).
;
; =====================================================


	ORG	2049

CPUDIR	EQU	0
CPUPORT	EQU	1
IO_ON	EQU	$35
IO_OFF	EQU	$34
PUTPTR	EQU	2
PTR2	EQU	4
POSPTR	EQU	6
ENDPTR	EQU	8
JPTR	EQU	10
THECOUNT	EQU	12
TEMP	EQU	13

PROG	EQU	14	; Code starts here

VICCTRL1	EQU	53265
BORDER	EQU	53280


	; BASIC program to SYS 2066
	DB	16,8
	DW	1991
	DB	158,"2066 CARL",0,0,0
	; Location 2066 - machine code start address
	
	; Turn off screen and setup chip
	SEI
	CLD
	LDA	#$2F
	STA	CPUDIR
	LDA	#IO_ON
	STA	CPUPORT
	LDA	#0
	STA	VICCTRL1
	LDA	#IO_OFF
	STA	CPUPORT
	LDX	#255
	TXS
	
	; Copy program into low memory
	LDX	#0
LOWLOOP	LDA	SPROG,X
	STA	PROG,X
	INX
	CPX	#(ENDOFPROG-PROG)
	BNE	LOWLOOP

	; Find end of data
	LDA	TRUEEND-6
	CLC
	ADC	#<TRUEEND
	STA	ENDPTR
	LDA	TRUEEND-5
	ADC	#>TRUEEND
	STA	ENDPTR+1

	; Copy data into high memory
	LDA	ENDPTR
	STA	POSPTR
	LDA	ENDPTR+1
	SEC
	SBC	#1
	STA	POSPTR+1
	LDA	#0
	STA	PUTPTR
	LDA	#255
	STA	PUTPTR+1
	LDY	#255
HIGHLOOP	LDA	(POSPTR),Y
	STA	(PUTPTR),Y
	DEY
        	LDA	(POSPTR),Y
	STA	(PUTPTR),Y
	DEY
	CPY	#255
	BNE	HIGHLOOP
	DEC	PUTPTR+1
	DEC	POSPTR+1
	LDA	#(>TRUEEND)-2
	CMP	POSPTR+1
	BNE	HIGHLOOP
	
	; Setup decompaction pointers
	LDA	#<TRUEEND
	SEC
	SBC	ENDPTR
	STA	POSPTR
	LDA	#>TRUEEND
	SBC	ENDPTR+1
	STA	POSPTR+1
	LDA	TRUEEND-4
	STA	PUTPTR
	LDA	TRUEEND-3
	STA	PUTPTR+1
	LDA	TRUEEND-2
	STA	JPTR
	LDA	TRUEEND-1
	STA	JPTR+1
	JMP	PROG

SPROG	; Start of prog in real terms


	ORG PROG

	; Program assembled to think it is in low-memory
	; This bit of the program is position independant
	; anyway!



; This program will reside in low-memory
; (must be < 256 bytes)
; ---------------------------------------

LOOP	; Flash border
	LDA	#IO_ON
	STA	CPUPORT
	INC	BORDER
	LDA	#IO_OFF
	STA	CPUPORT
	; Get character
	LDY	#0
	LDA	(POSPTR),Y
	BMI	LESS
	; Unique for ch+1 chars
	STA	THECOUNT
	INC	THECOUNT
	INC	POSPTR
	BNE	ULOOP
	INC	POSPTR+1
ULOOP	LDA	(POSPTR),Y
	STA	(PUTPTR),Y
	INY
	CPY	THECOUNT
	BNE	ULOOP
	; Add count to posptr
	LDA	POSPTR
	CLC
	ADC	THECOUNT
	STA	POSPTR
	BCC	NOINC3
	INC	POSPTR+1
NOINC3	; Add count to putptr
	LDA	PUTPTR
	CLC
	ADC	THECOUNT
	STA	PUTPTR
	BCC	LOOP
	INC	PUTPTR+1
	CLC
	BCC	LOOP

LESS	; Negative number means copy
	INC	POSPTR
	BNE	NOINC1
	INC	POSPTR+1
NOINC1	STA	TEMP
	LDA	(POSPTR),Y
	BEQ	DEEND
	STA	THECOUNT
	LDA	TEMP
	; ptr2 = ptr3+offset-256
	CLC
	ADC	PUTPTR
	STA	PTR2
	LDA	PUTPTR+1
	ADC	#255
	STA	PTR2+1
CLOOP	LDA	(PTR2),Y
	STA	(PUTPTR),Y
	INY
	CPY	THECOUNT
	BNE	CLOOP
	; Increment POSPTR
	INC	POSPTR
	BNE	NOINC2
	INC	POSPTR+1
NOINC2	; Add size to PUTPTR
	LDA	PUTPTR
	CLC
	ADC	THECOUNT
	STA	PUTPTR
	BCC	LOOP
	INC	PUTPTR+1
	CLC
	BCC	LOOP

DEEND	; Reset chip
	LDA	#IO_ON
	STA	CPUPORT
	; Run the machine code program
	JMP	(JPTR)

ENDOFPROG
	; End of file
TRUEEND	EQU	ENDOFPROG+6+SPROG-PROG

