;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; ================================================
; This file contains Commodore 64 system constants
; and general purpose macros
; ================================================
 
 	SEND	COMPUTER2
	SKIP	20
 
; System constants
; ----------------
;BIT	EQU	0.125	; ( = %0.001 in binary)
;NYBBLE	EQU	0.5
BYTE	EQU	1
WORD	EQU	2
LONGWORD	EQU	4
 
BIT0	EQU	1
BIT1	EQU	2
BIT2	EQU	4
BIT3	EQU	8
BIT4	EQU	16
BIT5	EQU	32
BIT6	EQU	64
BIT7	EQU	128
 
 
; CPU constants
; -------------
CPU_0	EQU	0
CPU_1	EQU	1
VECTOR_IRQ	EQU	$FFFE
IRQVEC	EQU	$FFFA-3
_JMP	EQU	76	; Opcode for jump instruction

 
; Joystick constants
; ------------------
JOY_UP	EQU	BIT0
JOY_DOWN	EQU	BIT1
JOY_LEFT	EQU	BIT2
JOY_RIGHT	EQU	BIT3
JOY_FIRE	EQU	BIT4
JOY_EXTRA	EQU	BIT5	; Software value

 
; Keyboard (ASCII) constants
; --------------------------
CR	EQU	13
STOP	EQU	3
DEL	EQU	20
INSERT	EQU	148
CRSR_RIGHT	EQU	29
CRSR_LEFT	EQU	157
CRSR_UP	EQU	145
CRSR_DOWN	EQU	17
CLR	EQU	147
HOME	EQU	19
SPACE	EQU	32
QUOTES	EQU	34
RVS_ON	EQU	18
RVS_OFF	EQU	146

F1	EQU	133
F2	EQU	137
F3	EQU	134
F4	EQU	138
F5	EQU	135
F6	EQU	139
F7	EQU	136
F8	EQU	140
 
CTRL_A	EQU	1
CTRL_B	EQU	2
CTRL_C	EQU	3
CTRL_D	EQU	4
CTRL_E	EQU	5
CTRL_F	EQU	6
CTRL_G	EQU	7
CTRL_H	EQU	8
CTRL_I	EQU	9
CTRL_J	EQU	10
CTRL_K	EQU	11
CTRL_L	EQU	12
CTRL_M	EQU	13
CTRL_N	EQU	14
CTRL_O	EQU	15
CTRL_P	EQU	16
CTRL_Q	EQU	17
CTRL_R	EQU	18
CTRL_S	EQU	19
CTRL_T	EQU	20
CTRL_U	EQU	21
CTRL_V	EQU	22
CTRL_W	EQU	23
CTRL_X	EQU	24
CTRL_Y	EQU	25
CTRL_Z	EQU	26

CTRL_BLACK	EQU	144
CTRL_WHITE	EQU	5
CTRL_RED	EQU	28
CTRL_CYAN	EQU	159
CTRL_PURPLE	EQU	156
CTRL_GREEN	EQU	30
CTRL_BLUE	EQU	31
CTRL_YELLOW	EQU	158
CTRL_ORANGE	EQU	129
CTRL_BROWN	EQU	149
CTRL_PINK	EQU	150
CTRL_DKGREY	EQU	151
CTRL_MDGREY	EQU	152
CTRL_LTGREEN	EQU	153
CTRL_LTBLUE	EQU	154
CTRL_LTGREY	EQU	155

 
; Video chip constants
; --------------------
COLOUR	EQU	$D800
VIC	EQU	$D000
SPRITE_POS	EQU	VIC
SPRITE_MSB	EQU	VIC+$10
VIC_CTRL1	EQU	VIC+$11
RASTER.LOW	EQU	VIC+$12
LIGHTPENX	EQU	VIC+$13
LIGHTPENY	EQU	VIC+$14
SPRITE_ENABLE	EQU	VIC+$15
VIC_CTRL2	EQU	VIC+$16
SPRITE_EXPANDY	EQU	VIC+$17
VIC_MEMMAP	EQU	VIC+$18
RASTER_FLAG	EQU	VIC+$19
RASTER_ENABLE	EQU	VIC+$1A
SPRITE_PRIOR	EQU	VIC+$1B
SPRITE_MULTI	EQU	VIC+$1C
SPRITE_EXPANDX	EQU	VIC+$1D
COLLISION_SS	EQU	VIC+$1E
COLLISION_SB	EQU	VIC+$1F	
BORDER_COL	EQU	VIC+$20
BKGND_COL	EQU	VIC+$21
SPR0_COL	EQU	VIC+$27
SPR1_COL	EQU	VIC+$28
SPR2_COL	EQU	VIC+$29
SPR3_COL	EQU	VIC+$2A
SPR4_COL	EQU	VIC+$2B
SPR5_COL	EQU	VIC+$2C
SPR6_COL	EQU	VIC+$2D
SPR7_COL	EQU	VIC+$2E
 
; Colour constants
; ----------------
BLACK	EQU	0
WHITE	EQU	1
RED	EQU	2
CYAN	EQU	3
PURPLE	EQU	4
GREEN	EQU	5
BLUE	EQU	6
YELLOW	EQU	7
ORANGE	EQU	8
BROWN	EQU	9
PINK	EQU	10
DKGREY	EQU	11
MDGREY	EQU	12
LTGREEN	EQU	13
LTBLUE	EQU	14
LTGREY	EQU	15

 
; Sound chip constants
; --------------------
SID1_FREQ.LOW	EQU	$D400
SID1_FREQ.HIGH	EQU	$D401
SID1_WID.LOW	EQU	$D402
SID1_WID.HIGH	EQU	$D403
SID1_WAVE	EQU	$D404
SID1_AD	EQU	$D405
SID1_SR	EQU	$D406

SID2_FREQ.LOW	EQU	$D407
SID2_FREQ.HIGH	EQU	$D408
SID2_WID.LOW	EQU	$D409
SID2_WID.HIGH	EQU	$D40A
SID2_WAVE	EQU	$D40B
SID2_AD	EQU	$D40C
SID2_SR	EQU	$D40D

SID3_FREQ.LOW	EQU	$D40E
SID3_FREQ.HIGH	EQU	$D40F
SID3_WID.LOW	EQU	$D410
SID3_WID.HIGH	EQU	$D411
SID3_WAVE	EQU	$D412
SID3_AD	EQU	$D413
SID3_SR	EQU	$D414

SID_FILT.LOW	EQU	$D415
SID_FILT.HIGH	EQU	$D416
SID_FILTER	EQU	$D417
SID_VOL	EQU	$D418
SID_PADDLE1	EQU	$D419
SID_PADDLE2	EQU	$D41A
SID_WAVE3	EQU	$D41B
SID_ENV3	EQU	$D41C
 
 
; Now the macros!
; ---------------
XY	MACRO		; Load the X and Y registers with a constant
 	LDX	#<(@1)
	LDY	#>(@1)
	ENDM

LDXY	MACRO		; Load the X and Y registers from a variable
 	LDX	@1+0
	LDY	@1+1
	ENDM

STXY	MACRO		; Store the X and Y registers in a variable
	STX	@1+0
	STY	@1+1
	ENDM

JAM	MACRO		; Continual error loop
!LP	INC	BORDER_COL
 	JMP	!LP
 	ENDM

FLASH	MACRO		; Toggle the colour of the border
 	LDA	BORDER_COL
;	EOR	#DKGREY
	STA	BORDER_COL
	ENDM

