;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; ==================================
; This file constants game constants
; and variable declarations
; ==================================
 
 
 
; =====================================
; PANG - Commodore 64 version
; -------------------------------------
; Source code (c) Carl Muller 1990
; All rights reserved.
; -------------------------------------
; Written by Carl Muller 30 July 1990
; Modified by Carl Muller 6 August 1990
; =====================================

 
 
; Game constants
; --------------
NUM_OBJS	EQU	32	; Maximum number of moving objects
MAX_SPRITES	EQU	33	; Number of plexed hardware sprites
NUM_TYPES	EQU	6	; Number of types of object
MAX_BOXES	EQU	10
MAX_LADDERS	EQU	10
 
GRAVITY	EQU	50
LEFTVEL	EQU	-250
RIGHTVEL	EQU	250
UPVEL	EQU	-900
ACCELX	EQU	100
ACCELY	EQU	100
DAMPX	EQU	80
DAMPY	EQU	80
 
MAN_LEFTVEL	EQU	-384
MAN_RIGHTVEL	EQU	384
MAN_UPVEL	EQU	-512
MAN_DOWNVEL	EQU	512

WIDTH_LADDER	EQU	8
SCRBOT	EQU	192	; Bottom of screen
LINECHAR	EQU	224	; Start of box characters
 
 
; Game variables - zero page
; ==========================
 	ORG	$0002
ZERO.START
 
; Pointer variables
; -----------------
PTR1	DS	WORD
PTR2	DS	WORD
PTR3	DS	WORD
 
; Game variables
; --------------
FRAME	DS	BYTE	; Frame counter for sync with IRQs
LASTFRAME	DS	BYTE	; Used to check for frame overrun
DEAD	DS	BYTE	; Flag - 1 = dead
CONTROL	DS	BYTE	; Joystick control byte
CONTROLDOWN	DS	BYTE	; Joystick transition control byte
NUMBOXES	DS	BYTE	; Number of collision boxes
NUMLADDERS	DS	BYTE	; Number of climable ladders

; Temporary variables
; -------------------
TEMP	DS	BYTE
TEMP2	DS	BYTE
SPRNUM	DS	BYTE
BOUNCE	DS	BYTE
COUNT	DS	BYTE
COUNT2	DS	BYTE
PLATFORM	DS	BYTE	; Current platform being processed
HARPOON	DS	BYTE	; Which harpoon is being used (0 or 1)
PLAYER	DS	BYTE	; Current player being tested (0 or 1)

; Raster variables
; ----------------
CURRENTPOS	DS	BYTE	; Index of current interrupt
CURRENTSPRITE	DS	BYTE	; Index into hardware sprites
STACKPTR	DS	BYTE
IRQ.A	DS	BYTE
IRQ.X	DS	BYTE
IRQ.Y	DS	BYTE

; Collision variables
; -------------------
BITSET	DS	BYTE	; Status bit to toggle for collisions
BANGX	DS	NUM_TYPES
BANGY	DS	NUM_TYPES
BANGWIDTH	DS	NUM_TYPES
BANGHEIGHT	DS	NUM_TYPES
LASTPOS	DS	BYTE

; Printing variables
; ------------------
PRINTPTR	DS	WORD	; Pointer to screen
PRINTPTR2	DS	WORD	; Other pointer to screen
ZERO.END
 
 
 
; Reserve stack space
; ===================
	ORG	$0100
 	; Raster interrupt info
STACK
IRQTYPE	DS	64	; Chain of IRQs at 4 pixel boundaries
			; 0=NONE, 1..24 = Virtual sprite number
 	DS	256-64
 
 
 
; Game variables - non-zero page
; ==============================
 	ORG	$0200
VARS.START
; General variables
JPTR	DS	WORD	; Jump vector
IJPTR	DS	WORD	; Jump vector used by IRQ

; Game variables
LEVEL	DS	BYTE	; Current screen number

; Input variables
MAXKEYS	EQU	10	; Size of keyboard buffer
KEYSCANS	DS	8	; Currently pressed keys
KEYDOWN	DS	8	; Transition down for keyboard
KEYBOARD_HEAD	DS	1	; Part of keyboard buffer to add keypresses
KEYBOARD_TAIL	DS	1	; Part of keyboard buffer to read keys from
KEYBUF	DS	MAXKEYS	; Keyboard buffer
JOY1	DS	BYTE	; Currently pressed values
JOY2	DS	BYTE
JOY1DOWN	DS	BYTE	; Downward transition values
JOY2DOWN	DS	BYTE
LASTJOY1	DS	BYTE	; Previously pressed values
LASTJOY2	DS	BYTE
 
; Player variables
LIVES.P1	DS	BYTE
LIVES.P2	DS	BYTE
MAN.P1	DS	BYTE	; Pointer to player's object
MAN.P2	DS	BYTE	; Bit 7 set for no object allocated
WANT	DS	BYTE	; Bit 1 = player 1 wants an object
			; Bit 2 = player 2 wants an object

; Object variables
XVEL.LOW	DS	NUM_OBJS
XVEL.HIGH	DS	NUM_OBJS
XPOS.LOW	DS	NUM_OBJS
XPOS.HIGH	DS	NUM_OBJS
YVEL.LOW	DS	NUM_OBJS
YVEL.HIGH	DS	NUM_OBJS
YPOS.LOW	DS	NUM_OBJS
YPOS.HIGH	DS	NUM_OBJS
OBJTYPE	DS	NUM_OBJS

; Software sprite variables
STATUS	DS	NUM_OBJS	; 0 = object not in use
ST_HARDWARE	EQU	1		; 1 = hardware sprite
ST_SOFTWARE	EQU	2		; 2 = software sprite (tiny ball)
ST_BALL	EQU	4		; 4 = bouncy ball
ST_DEAD	EQU	128		; 128 = being destroyed (temp)

HITSTATUS	DS	NUM_OBJS
ST_HIT.P1	EQU	8		; 8 = can hurt player 1 (temp)
ST_HIT.W1	EQU	16		; 16 = can collide with weapon 1 (temp)
ST_HIT.P2	EQU	32		; 32 = can hurt player 2 (temp) 
ST_HIT.W2	EQU	64		; 64 = can collide with weapon 2 (temp)
ST_HIT.PLAT	EQU	128		; 128 = can bounce off platform (temp)

SPRPOS.LOW	DS	NUM_OBJS	; Byte to start erasing from
SPRPOS.HIGH	DS	NUM_OBJS
SPRKILL.LOW	DS	NUM_OBJS	; Routine to do the erasing
SPRKILL.HIGH	DS	NUM_OBJS
 
; Virtual sprite info
VIRT_SHAPE	DS	MAX_SPRITES
VIRT_XPOS	DS	MAX_SPRITES
VIRT_YPOS	DS	MAX_SPRITES
VIRT_MSB	DS	MAX_SPRITES

; Harpoon variables
NUM_HARPOONS	EQU	2
OLDPICCY1	DS	200
OLDPICCY2	DS	200
WIRE_X	DS	NUM_HARPOONS
WIRE_TOP	DS	NUM_HARPOONS
WIRE_BOT	DS	NUM_HARPOONS
WIRE_LASTTOP	DS	NUM_HARPOONS
WIRE_FLAG	DS	NUM_HARPOONS

; Background map variables
BOX_X	DS	MAX_BOXES
BOX_Y	DS	MAX_BOXES
BOX_WIDTH	DS	MAX_BOXES
BOX_HEIGHT	DS	MAX_BOXES
LADDER_X	DS	MAX_LADDERS
LADDER_Y	DS	MAX_LADDERS
LADDER_HEIGHT	DS	MAX_LADDERS
 
; Printing variables
PRINTX	DS	BYTE	; Horizontal position to print at
PRINTY	DS	BYTE	; Vertical position to print at
PRINTCOLOUR	DS	BYTE	; Colour to print with
CURSORCHAR	DS	BYTE	; Character underneath cursor
CURSORCOLOUR	DS	BYTE	; Colour underneath cursor
CURSORSTATE	DS	BYTE	; 0=cursor off, 1=cursor on
CURSORCOUNT	DS	BYTE	; Frames till cursor flashes
WINDOW_X1	DS	BYTE	; Leftmost part of window
WINDOW_X2	DS	BYTE
WINDOW_Y1	DS	BYTE
WINDOW_Y2	DS	BYTE
VARS.END
 
; Buffers
FADEBUFFER	DS	256
SM	EQU	40+2
SL	EQU	25+2
COLLIS	DS	SM*SL	; Big enough for smearing
 