;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; ===============================
; This file contains utility code
; and initialisation code
; ===============================

 
COLD_START	EXEC	*
	; Initialise machine
	SEI		; CPU registers
	CLD
 	LDX	#$FF
	TXS
 	JSR	INIT_MACHINE
!GAME_LOOP	JSR	INIT_GAME
 	JSR	INIT_SCREEN
 	JSR	DO_GAME
 
 	LDA	#0
	STA	SPRITE_ENABLE
 	SEI
 	JSR	FADE_OUT
	JSR	SETUP_SCREEN
	LDX	#1
	JSR	PRINT_WINDOW
	INX
 	JSR	PRINT_WINDOW
	INX
 	JSR	PRINT_WINDOW
	JSR	INPUT
 	SEI
 	JSR	FADE_OUT
	JMP	!GAME_LOOP

 
; Macro to copy a block of memory
COPY_BLOCK	MACRO
 	XY	@1
 	STXY	PTR1
 	XY	@2
 	STXY	PTR2
 	XY	@3
 	STXY	PTR3	
	JSR	TRANSFER_BLOCK
	ENDM

 
; Macro to clear a block to a certain value
CLEAR_BLOCK	MACRO
	XY	@1
 	STXY	PTR1
 	XY	@2
 	STXY	PTR2
 	LDA	#@3
 	JSR	SET_BLOCK
 	ENDM

 
; ===================
; Initialisation code
; ===================

 
 
; Initialise the machine
; ----------------------
INIT_MACHINE	LDA	#$2F
	STA	CPU_0	; On-chip DDR
 	LDA	#$35
	STA	CPU_1	; On-chip Data port

 	LDX	#0
	STX	RASTER_ENABLE	; VIC interrupts
	LDA	#$7F
	STA	$DC0D
 	STA	$DD0D
 	STA	RASTER_FLAG
 	BIT	$DC0D
 	BIT	$DD0D
 	LDA	$DD02	; Setup DDR for VIC chip
	ORA	#3
	STA	$DD02
 	LDA	#BLACK
	STA	BORDER_COL	; Set border colour to black
 	LDA	#0
	STA	VIC_CTRL1	; Turn off screen
 	; Initialise SID chip
 	LDA	#0
	STA	SID_VOL
 	LDX	#$17
!LOOP	LDA	#255
 	STA	$D400,X
 	LDA	#0
	STA	$D400,X
 	DEX
 	BPL	!LOOP	
	LDA	#15
 	STA	SID_VOL
 	RTS
 
 
; Setup the game variables
; ------------------------
INIT_GAME	; Clear zero page variables
	LDX	#ZERO.START
 	LDA	#0
!LOOP	STA	0,X
	INX
 	CPX	#ZERO.END
 	BNE	!LOOP
 	; Clear other variables
 	CLEAR_BLOCK VARS.START, VARS.END, 0
 	; Setup game
	LDA	#0
	STA	LEVEL
 	RTS
 
 
; Setup a screen
; --------------
INIT_SCREEN	; Unpack the background into piccy, piccy.col and piccy.scr
	; ....
	; Plot platforms over this
	CLEAR_BLOCK COLLIS, COLLIS+(SM*SL), 0
 	LDA	LEVEL
 	ASL
 	TAX
 	LDA	LEVELPTRS,X
 	STA	PTR1
	LDA	LEVELPTRS+1,X
 	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y
	STA	NUMBOXES
	BEQ	!DONE1
	LDX	#0
!COPYLOOP1	; Copy a box into the variable structure
	INY
 	LDA	(PTR1),Y
	ASL
 	ASL
 	STA	BOX_X,X
 	INY
 	LDA	(PTR1),Y
	ASL
 	ASL
 	ASL
 	STA	BOX_Y,X
 	INY
 	LDA	(PTR1),Y
	ASL
 	ASL
 	STA	BOX_WIDTH,X
 	LDA	#8
	STA	BOX_HEIGHT,X
	; Continue loop
 	INX
 	CPX	NUMBOXES
	BNE	!COPYLOOP1
	; Get ladders
!DONE1	INY
 	LDA	(PTR1),Y
	STA	NUMLADDERS
	BEQ	!DONE2
	LDX	#0
!COPYLOOP2	; Copy a ladder into the variable structure
 	INY
 	LDA	(PTR1),Y
	STA	LADDER_X,X
	INY
 	LDA	(PTR1),Y
	STA	LADDER_Y,X
	INY
 	LDA	(PTR1),Y
	STA	LADDER_HEIGHT,X
 	INX
 	CPX	NUMLADDERS
	BNE	!COPYLOOP2
!DONE2	; Draw all platforms
	LDX	#0
	CPX	NUMBOXES
	BEQ	!DONE3
!LOOPPLAT	JSR	DRAW_PLATFORM
	INX
 	CPX	NUMBOXES
	BNE	!LOOPPLAT
!DONE3	; Smear collision data
	JSR	SMEAR_MAP
 	; Draw all ladders
	LDX	#0
	CPX	NUMLADDERS
	BEQ	!DONE4
!LOOPLAD	JSR	DRAW_LADDER
 	INX
 	CPX	NUMLADDERS
	BNE	!LOOPLAD
!DONE4	; Setup the background
	COPY_BLOCK COLOUR, COLOUR+1000, PICCY.COL
 	COPY_BLOCK SCREEN, SCREEN+1000, PICCY.SCR
 	COPY_BLOCK BITMAP, BITMAP+8000, PICCY
 
 	; Set up players variables
	LDA	#3	; Please allocate for player 1 and 2
 	STA	WANT
	LDA	#255
	STA	MAN.P1
	STA	MAN.P2

 	; Set up music and sprites
	JSR	START_MUSIC
 	JSR	CLR_SPRITES
 	JSR	SPRINTER

 	; Set up VIC chip
 	LDA	$DD00	; Let VIC access correct bank
 	ORA	#3
	EOR	#VICBANK/$4000
	STA	$DD00
 	; Set up video chip
 	JSR	WAIT_VB
 	LDX	#VIC_INIT.END-VIC_INIT-1
!LOOPVIC	LDA	VIC_INIT,X
	STA	VIC,X
 	DEX
 	BPL	!LOOPVIC

 	; Setup interrupts
	JSR	PLOT_SPRITES
	JSR	SETUP_IRQ
 	LDA	FRAME
 	STA	LASTFRAME
 	RTS
 
 
; Initialisation data for video chip
; ----------------------------------
VIC_INIT	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; Sprite X & Y positions
 	DB	0	; Sprite X MSB
 	DB	32+16+8+3	; MSB raster compare/Extended colour mode/
 			; Bitmap mode/Display enable/yscroll
	DB	0	; Raster compare register
	DB	0	; Light pen X
	DB	0	; Light pen Y
	DB	255	; Sprite enable
	DB	16+8	; Multi-colour/xscroll
	DB	0	; Sprite Y expand
	DB	(BITMAP-VICBANK)/1024+16*(SCREEN-VICBANK)/1024
 			; Memory pointers
 	DB	0	; Interrupt flags
	DB	0	; Interrupt enable
 	DB	0	; Sprite/background priority
 	DB	255	; Multi-colour sprites
 	DB	0	; Sprite X expand
	DB	0	; Sprite/sprite collision
	DB	0	; Sprite/background collision
	DB	BLACK	; Border colour
	DB	WHITE	; Background colour 0 (Ball colour)
	DB	BLACK	; Background colour 1
	DB	BLACK	; Background colour 2
	DB	BLACK	; Background colour 3
	DB	WHITE	; Sprite Multicolour 1 (Ball colour)
 	DB	LTGREEN	; Sprite Multicolour 2
 	DB	BLACK	; Sprite 0 colour
	DB	BLACK	; Sprite 1 colour
	DB	BLACK	; Sprite 2 colour
	DB	BLACK	; Sprite 3 colour
	DB	BLACK	; Sprite 4 colour
	DB	BLACK	; Sprite 5 colour
	DB	BLACK	; Sprite 6 colour
	DB	BLACK	; Sprite 7 colour
VIC_INIT.END
 
 
; Initialisation data for video chip - char mode
; ----------------------------------------------
VIC_INIT2	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; Sprite X & Y positions
	DB	0	; Sprite X MSB
 	DB	16+8+3	; MSB raster compare/Extended colour mode/
			; Bitmap mode/Display enable/yscroll
	DB	0	; Raster compare register
	DB	0	; Light pen X
	DB	0	; Light pen Y
	DB	0	; Sprite enable
	DB	8	; Multi-colour/xscroll
 	DB	0	; Sprite Y expand
	DB	(CHARSET-VICBANK)/1024+16*(SCREEN-VICBANK)/1024
			; Memory pointers
 	DB	0	; Interrupt flags
	DB	0	; Interrupt enable
 	DB	0	; Sprite/background priority
 	DB	255	; Multi-colour sprites
 	DB	0	; Sprite X expand
	DB	0	; Sprite/sprite collision
	DB	0	; Sprite/background collision
	DB	BLACK	; Border colour
	DB	BLACK	; Background colour 0
	DB	BLACK	; Background colour 1
	DB	BLACK	; Background colour 2
	DB	BLACK	; Background colour 3
	DB	WHITE	; Sprite Multicolour 1 (Ball colour)
 	DB	LTGREEN	; Sprite Multicolour 2
 	DB	BLACK	; Sprite 0 colour
	DB	BLACK	; Sprite 1 colour
	DB	BLACK	; Sprite 2 colour
	DB	BLACK	; Sprite 3 colour
	DB	BLACK	; Sprite 4 colour
	DB	BLACK	; Sprite 5 colour
	DB	BLACK	; Sprite 6 colour
	DB	BLACK	; Sprite 7 colour
VIC_INIT2.END

 
 
; ================
; Utility routines
; ================
 
 
; Wait for a vertical blank to occur
; ----------------------------------
WAIT_VB	LDX	FRAME
!LOOP	CPX	FRAME
	BNE	!END
	LDA	RASTER.LOW
	CMP	#250
	BNE	!LOOP
!END	RTS
 
 
; Wait for sync with the interrupts
; ---------------------------------
WAIT_SYNC	LDA	FRAME
!LOOP	CMP	FRAME
	BEQ	!LOOP
 	RTS
 
 
; Clear a block of memory
; Pre - PTR1 = start of block
;       PTR2 = end of block
;       A    = byte to set
; Post - registers destroyed, block set to zero
; ---------------------------------------------
SET_BLOCK	PHA
	LDY	PTR1
	LDA	#0
	STA	PTR1
	LDX	PTR1+1
	PLA
!LOOP	STA	(PTR1),Y
 	INY
 	BNE	!NOINC
	INC	PTR1+1
	INX
!NOINC	CPY	PTR2
	BNE	!LOOP
 	CPX	PTR2+1
	BNE	!LOOP
 	RTS
 
 
; Copy a block of memory
; Pre - PTR1 = start of block
;       PTR2 = end of block
;       PTR3 = start of block to copy from
; Post - registers destroyed, block set to zero
; ---------------------------------------------
TRANSFER_BLOCK
 	LDA	#0
	LDY	PTR1
	LDX	PTR1+1
	STA	PTR1
!LOOP	LDA	(PTR3),Y
 	STA	(PTR1),Y
	INY
 	BNE	!NOINC
	INC	PTR1+1
	INC	PTR3+1
	INX
!NOINC	CPY	PTR2
	BNE	!LOOP
 	CPX	PTR2+1
	BNE	!LOOP
 	RTS
 
 
 
; ====================
; Handle input devices
; ====================
 
 
; Read the joysticks
; ------------------
READ_JOY	; Remember last joystick values
 	LDA	JOY1
	STA	LASTJOY1
	LDA	JOY2
	STA	LASTJOY2
	; Read joysticks
	LDA	#$00
	STA	$DC02
 	STA	$DC03
 	LDA	$DC00
 	EOR	#$FF
	AND	#$1F
	STA	JOY1

 	LDA	#$FF
	STA	$DC02	;now set port to output
 	STA	$DC00
 	LDA	$DC01
 	EOR	#$FF
	AND	#$1F
	STA	JOY2

 	; Read keyboard
 	LDY	#$FF	; Use to mask off bad values 
	LDX	#8-1
!LOOP
	STY	$DC00
 	LDA	$DC01
 	STA	TEMP
	LDA	BIT_MASK1,X
 	STA	$DC00
 	LDA	$DC01
 	STY	$DC00
 	EOR	#255
	AND	$DC01	; Mask off next joystick value
	AND	TEMP
	STA	TEMP

 	EOR	KEYSCANS,X
	AND	TEMP
	STA	KEYDOWN,X
 	LDA	TEMP
	STA	KEYSCANS,X
	DEX
 	BPL	!LOOP
 
 	; Add joystick emulation keys to joy values
 	LDY	#6
!LOOPJOY	LDA	JOY1KEYS,Y
	AND	#7
	TAX
 	LDA	BIT_MASK0,X
 	STA	TEMP
	LDA	JOY1KEYS,Y
	LSR
 	LSR
 	LSR
 	AND	#7
	TAX
 	LDA	KEYSCANS,X
	AND	TEMP
	BEQ	!NOTDOWN1
 	; Add value to joystick
 	LDA	JOY1
	ORA	BIT_MASK0,Y
 	STA	JOY1
!NOTDOWN1	; Check joystick 2
 	LDA	JOY2KEYS,Y
	AND	#7
	TAX
 	LDA	BIT_MASK0,X
 	STA	TEMP
	LDA	JOY2KEYS,Y
	LSR
 	LSR
 	LSR
 	AND	#7
	TAX
 	LDA	KEYSCANS,X
	AND	TEMP
	BEQ	!NOTDOWN2
 	; Add value to joystick
 	LDA	JOY2
	ORA	BIT_MASK0,Y
 	STA	JOY2
!NOTDOWN2	DEY
	BPL	!LOOPJOY

 	; Work out transitions
	LDA	LASTJOY1
	EOR	#255
	STA	TEMP
	LDA	JOY1
	AND	TEMP
	STA	JOY1DOWN
	LDA	LASTJOY2
	EOR	#255
	STA	TEMP
	LDA	JOY2
	AND	TEMP
	STA	JOY2DOWN
	RTS
 
 
 
; Initialise keyboard buffer
; --------------------------
INIT_KEYS	LDA	#0
 	STA	KEYBOARD_HEAD
 	STA	KEYBOARD_TAIL
 	RTS
 
 
 
; Put keypresses into a keyboard buffer
; -------------------------------------
SCAN_KEYS	; Find status of shift keys
	; (0=none, 64=shift, 128=cbm, 192=ctrl)
 	LDY	#0
	LDA	KEYSCANS+1	; Check left shift key
 	AND	#BIT7
 	BEQ	!NOSHIFT.L
	LDY	#64
!NOSHIFT.L	LDA	KEYSCANS+6	; Check right shift key
	AND	#BIT4
 	BEQ	!NOSHIFT.R
	LDY	#64
!NOSHIFT.R	LDA	KEYSCANS+7	; Check commodore shift key
	AND	#BIT5
 	BEQ	!NOCBM
	LDY	#128
!NOCBM	LDA	KEYSCANS+7	; Check control key
	AND	#BIT2
 	BEQ	!NOCTRL
 	LDY	#192
!NOCTRL	; Loop through all keys
	LDX	#0
!BIGLOOP	STX	COUNT
 	LDA	KEYDOWN,X
 	LDX	#0
	STA	TEMP
!LOOP	AND	BIT_MASK0,X
	BEQ	!NOPRESS
	; Insert key into keyboard buffer
 	LDA	SCANCODES,Y
 	BEQ	!NOPRESS	; Ignore shift keys etc.
 	JSR	INSERTKEY
!NOPRESS	; Continue to loop through all keys
 	INY	; Increment pointer to conversion table
 	LDA	TEMP
	INX
 	CPX	#8
	BNE	!LOOP
 	LDX	COUNT
 	INX
 	CPX	#8
	BNE	!BIGLOOP
	RTS
 
 
; Read the keyboard buffer
; ------------------------
; Post - A = character number of key press (or 0 for no key press)
READ_KEY	LDX	KEYBOARD_TAIL
 	CPX	KEYBOARD_HEAD
 	BEQ	!NOKEY
	INX
 	CPX	#MAXKEYS
	BNE	!OK
 	LDX	#0
!OK	STX	KEYBOARD_TAIL
	LDA	KEYBUF,X
	RTS
!NOKEY	LDA	#0
	RTS
 
 
 
; Insert a key into the keyboard buffer
; -------------------------------------
; Pre - A = ASCII code of keypress to insert
; Preserves X and Y, uses ptr1
INSERTKEY	STX	PTR1
 	LDX	KEYBOARD_HEAD
 	INX
 	CPX	#MAXKEYS
	BNE	!NOWRAP
 	LDX	#0		; Wrap around circular buffer
!NOWRAP	CPX	KEYBOARD_TAIL
	BEQ	!OVERFLOW	; Check for buffer overflow
 	STX	KEYBOARD_HEAD
 	STA	KEYBUF,X
!OVERFLOW	LDX	PTR1
 	RTS
 
 
 
; ======================
; System constant tables
; ======================
 
 
 
; Bit masks for general use
; -------------------------
BIT_MASK0	DB	1, 2, 4, 8, 16, 32, 64, 128
BIT_MASK1	DB	255-1, 255-2, 255-4, 255-8
	DB	255-16, 255-32, 255-64, 255-128
BIT_MASK2	DB	192, 48, 12, 3

 
; Scan code conversion table for keyboard reading
; -----------------------------------------------

 
SCANCODES	; Unshifted keys
 	DB	DEL, CR, CRSR_RIGHT, F7, F1, F3, F5, CRSR_DOWN
 	DB	"3wa4zse", 0
 	DB	"5rd6cftx"
 	DB	"7yg8bhuv"
 	DB	"9ij0mkon"
 	DB	"+pl-.:@,"
 	DB	"`*;", HOME, 0, "=^/"
	DB	"1_", 0, "2", SPACE, 0, "q", STOP
	; Shifted keys
	DB	INSERT, CR, CRSR_LEFT, F8, F2, F4, F6, CRSR_UP
 	DB	"#WA$ZSE", 0
 	DB	"%RD&CFTX"
 	DB	"'YG(BHUV"
 	DB	")IJ0MKON"
 	DB	"+PL->[@<"
 	DB	"`*]", CLR, 0, "=^?"
 	DB	"!_", 0, QUOTES, SPACE, 0, "Q", STOP
 	; Commodore keys
	DB	INSERT, CR, CRSR_LEFT, F8, F2, F4, F6, CRSR_UP
 	DB	CTRL_PINK, "WA", CTRL_DKGREY, "ZSE", 0
 	DB	CTRL_MDGREY, "RD", CTRL_LTGREEN, "CFTX"
	DB	CTRL_LTBLUE, "YG", CTRL_LTGREY, "BHUV"
 	DB	")IJ0MKON"
 	DB	"+PL->[@<"
 	DB	"`*]", CLR, 0, "=^?"
 	DB	CTRL_ORANGE, "_", 0, CTRL_BROWN, SPACE, 0, "Q", STOP
 	; Control keys
	DB	DEL, CR, 0, 0, 0, 0, 0, 0
	DB	CTRL_RED, CTRL_W, CTRL_A, CTRL_CYAN
	DB	CTRL_Z, CTRL_S, CTRL_E, 0
	DB	CTRL_PURPLE, CTRL_R, CTRL_D, CTRL_GREEN
	DB	CTRL_C, CTRL_F, CTRL_T, CTRL_X
 	DB	CTRL_BLUE, CTRL_Y, CTRL_G, CTRL_YELLOW
 	DB	CTRL_B, CTRL_H, CTRL_U, CTRL_V
 	DB	RVS_ON, CTRL_I, CTRL_J, RVS_OFF
	DB	CTRL_M, CTRL_K, CTRL_O, CTRL_N
 	DB	0, CTRL_P, CTRL_L, 0
 	DB	0, 27, 0, 0
	DB	28, 0, 29, 0
 	DB	0, 31, 30, 0
 	DB	CTRL_BLACK, 6, 0, CTRL_WHITE
 	DB	0, 0, CTRL_Q, 0

 
; Joystick emulation keys
; -----------------------
JOY1KEYS	DB	33	; Up = I
	DB	36	; Down = M
	DB	34	; Left = J
	DB	37	; Right = K
 	DB	60	; Fire = space
	DB	57	; Extra = <-

JOY2KEYS	DB	10	; Up = A
	DB	12	; Down = Z
	DB	47	; Left = <
	DB	44	; Right = >
 	DB	55	; Fire = /
	DB	0	; Extra = Insert/Del
 
 
; Table pointing to rows on the screen
; ------------------------------------
SCREENROWS.LOW
 	DL	SCREEN, SCREEN+40, SCREEN+40*2, SCREEN+40*3
	DL	SCREEN+40*4, SCREEN+40*5, SCREEN+40*6, SCREEN+40*7
 	DL	SCREEN+40*8, SCREEN+40*9, SCREEN+40*10, SCREEN+40*11
 	DL	SCREEN+40*12, SCREEN+40*13, SCREEN+40*14, SCREEN+40*15
 	DL	SCREEN+40*16, SCREEN+40*17, SCREEN+40*18, SCREEN+40*19
 	DL	SCREEN+40*20, SCREEN+40*21, SCREEN+40*22, SCREEN+40*23
 	DL	SCREEN+40*24
 
 
SCREENROWS.HIGH
	DH	SCREEN, SCREEN+40, SCREEN+40*2, SCREEN+40*3
	DH	SCREEN+40*4, SCREEN+40*5, SCREEN+40*6, SCREEN+40*7
 	DH	SCREEN+40*8, SCREEN+40*9, SCREEN+40*10, SCREEN+40*11
 	DH	SCREEN+40*12, SCREEN+40*13, SCREEN+40*14, SCREEN+40*15
 	DH	SCREEN+40*16, SCREEN+40*17, SCREEN+40*18, SCREEN+40*19
 	DH	SCREEN+40*20, SCREEN+40*21, SCREEN+40*22, SCREEN+40*23
 	DH	SCREEN+40*24
 
 
; Table pointing to rows on the collision map
; -------------------------------------------
COLLIS.LOW
 	DL	COLLIS, COLLIS+SM, COLLIS+SM*2, COLLIS+SM*3
	DL	COLLIS+SM*4, COLLIS+SM*5, COLLIS+SM*6, COLLIS+SM*7
 	DL	COLLIS+SM*8, COLLIS+SM*9, COLLIS+SM*10, COLLIS+SM*11
 	DL	COLLIS+SM*12, COLLIS+SM*13, COLLIS+SM*14, COLLIS+SM*15
 	DL	COLLIS+SM*16, COLLIS+SM*17, COLLIS+SM*18, COLLIS+SM*19
 	DL	COLLIS+SM*20, COLLIS+SM*21, COLLIS+SM*22, COLLIS+SM*23
 	DL	COLLIS+SM*24
 
 
COLLIS.HIGH
	DH	COLLIS, COLLIS+SM, COLLIS+SM*2, COLLIS+SM*3
	DH	COLLIS+SM*4, COLLIS+SM*5, COLLIS+SM*6, COLLIS+SM*7
 	DH	COLLIS+SM*8, COLLIS+SM*9, COLLIS+SM*10, COLLIS+SM*11
 	DH	COLLIS+SM*12, COLLIS+SM*13, COLLIS+SM*14, COLLIS+SM*15
 	DH	COLLIS+SM*16, COLLIS+SM*17, COLLIS+SM*18, COLLIS+SM*19
 	DH	COLLIS+SM*20, COLLIS+SM*21, COLLIS+SM*22, COLLIS+SM*23
 	DH	COLLIS+SM*24
 
 
 
 
; Pointer to data structure for each level
; ----------------------------------------
LEVELPTRS	DW	LEVEL1, LEVEL1, LEVEL1, LEVEL1

; Format of data - 1 byte number of boxes, followed by 3 bytes per box
; xpos, ypos, width (in characters)
; NB xpos and width should be multiples of 4
; 1 byte number of ladders, followed by 3 bytes per ladder 
; xpos, ypos, height
 
; Data for first level
; --------------------
LEVEL1	DB	2
	DB	12, 6, 10
	DB	16, 12, 8
	DB	2
	DB	4*16, 8*12, SCRBOT-8*12
	DB	4*(12+10)-8, 8*6, 8*(12-6)
 