;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; =====================================
; This file contains the main game code
; =====================================

 
; Main loop for game
; ------------------
DO_GAME	; Check for frame overrun
	LDA	FRAME
 	CMP	LASTFRAME
 	BEQ	!NOOVERRUN
	; Code to run in case of overrun - not much screen update
 	STA	LASTFRAME
 	JSR	READ_JOY
	JSR	MOVE_SPRITES
	JSR	HANDLE_MEN
	JSR	MOVE_HARPOONS
 	JSR	HANDLE_OBJS
!NOOVERRUN	; Work out interrupt structure
	JSR	WAIT_SYNC
 	LDA	FRAME
 	STA	LASTFRAME
;	LDA	#RED
;	STA	BORDER_COL
 	JSR	SETUP_IRQ	; Starts interrupt off
	JSR	PLOT_SPRITES	; Display virtual sprites
;	LDA	#BLACK
;	STA	BORDER_COL
 	JSR	ERASE_BALLS
 	JSR	PLOT_BALLS
	JSR	READ_JOY
	JSR	MOVE_SPRITES
	JSR	HANDLE_MEN
	JSR	MOVE_HARPOONS
 	JSR	HANDLE_OBJS
 	JSR	DO_MUSIC
	; End of main loop processing
 	LDA	DEAD
	BNE	!TERMINATE
	JMP	DO_GAME
!TERMINATE	RTS
 
 
 
; Handle players
; --------------
HANDLE_MEN	; See if player 1 wants to be allocated
 	LDA	WANT
	AND	#1
	BEQ	!NOWANT1
	JSR	ALLOCMAN
	STY	MAN.P1
	BMI	!NOWANT1	; Unsuccessful
 	LDA	WANT
	AND	#255-1
	STA	WANT
!NOWANT1	; See if player 2 wants to be allocated
 	LDA	WANT
	AND	#2
	BEQ	!NOWANT2
	JSR	ALLOCMAN
	STY	MAN.P2
	BMI	!NOWANT2	; Unsuccessful
 	LDA	WANT
	AND	#255-2
	STA	WANT
!NOWANT2	; Move players if they are allocated
	LDX	MAN.P1
	BMI	!NOMAN1
 	LDA	JOY1
	STA	CONTROL
 	LDA	JOY1DOWN
	STA	CONTROLDOWN
 	LDA	#0
	STA	HARPOON
 	JSR	MOVE_MAN
!NOMAN1	LDX	MAN.P2
 	BMI	!NOMAN2
 	LDA	JOY2
	STA	CONTROL
 	LDA	JOY2DOWN
	STA	CONTROLDOWN
 	LDA	#1
	STA	HARPOON
 	JSR	MOVE_MAN
!NOMAN2	RTS

 
 
; Allocate a man
; --------------
ALLOCMAN	; Search for a free object
	LDY	#NUM_OBJS
!LOOP	DEY
	BMI	!NOHOPE
 	LDA	STATUS,Y
	BNE	!LOOP
 	; Set up the man's variables
	LDA	#0
	STA	XPOS.LOW,Y
	STA	YPOS.LOW,Y
	STA	XVEL.LOW,Y
	STA	XVEL.HIGH,Y
 	STA	YVEL.LOW,Y
	STA	YVEL.HIGH,Y
 	LDA	#160/2
	STA	XPOS.HIGH,Y
 	LDA	#SCRBOT-21
	STA	YPOS.HIGH,Y
 	LDA	#<NOERASE
 	STA	SPRKILL.LOW,Y
 	LDA	#>NOERASE
 	STA	SPRKILL.HIGH,Y
	LDA	#ST_HARDWARE
	STA	STATUS,Y
	LDA	#5
	STA	OBJTYPE,Y
!NOHOPE	RTS

 
 
; Macro to loop through all balls calling a routine
; -------------------------------------------------
; Parameters - routine, number of optional routines, optional routines
OBJLOOP	MACRO
	LDX	#NUM_OBJS-1
!LOOP	LDA	STATUS,X
 	AND	#ST_BALL
	BEQ	!NOTBALL
	JSR	@1
	IF	@2=1
 	  BCC	!NOTBALL
	  JSR	@3
	ENDIF
!NOTBALL	DEX
 	BPL	!LOOP
 	ENDM
	

; Handle objects
; --------------
HANDLE_OBJS	; Move objects
 	OBJLOOP	MOVE_BALL,0
 
 	; Check for them hitting harpoons
 	LDY	#0
!LOOP	STY	HARPOON
	LDA	WIRE_FLAG,Y
 	BEQ	!NOTWIRE
	JSR	SETUP_CHECK
 	OBJLOOP	CHECK_CRASH,1,HANDLE_HIT
!NOTWIRE	LDY	HARPOON
 	INY
 	CPY	#NUM_HARPOONS
 	BNE	!LOOP
 
 	; Check for them killing you
	LDX	MAN.P1
	BMI	!NOP1		; Player 1 not allocated
 	LDA	#ST_HIT.P1
	STA	BITSET
	LDA	#0
	STA	PLAYER
	JSR	SETUP_CHECK2
	OBJLOOP	CHECK_CRASH,1,KILLME
!NOP1	LDX	MAN.P2
 	BMI	!NOP2		; Player 2 not allocated
 	LDA	#ST_HIT.P2
	STA	BITSET
	LDA	#1
	STA	PLAYER
	JSR	SETUP_CHECK2
	OBJLOOP	CHECK_CRASH,1,KILLME
!NOP2
	; Check for them hitting platforms
	OBJLOOP	CHECK_CRASH.P, 0
	RTS
 
 
 
; Handle the harpoon hitting a ball
; ---------------------------------
HANDLE_HIT	JSR	SFX1
	JSR	SPLIT_BALL
	STX	SPRNUM
	JSR	ERASE_HARPOON
 	LDX	SPRNUM
	RTS
 
 
; Handle the ball hitting a platform
; ----------------------------------
; Pre - X = object number of ball to bounce
;       PLATFORM contains number of platform to bounce off
; Preserves X
REVERSE_Y	; Find row to bounce off
 	LDA	YPOS.HIGH,X
 	AND	#255-7
	STA	BOUNCE
	LDA	YVEL.HIGH,X
 	BPL	!OFFTOP
 	LDA	BOUNCE
	CLC
 	ADC	#8
	STA	BOUNCE
!OFFTOP
	; Bounce yvel and ypos
	LDA	#0
	SEC
 	SBC	YVEL.LOW,X
	STA	YVEL.LOW,X
	LDA	#0
	SBC	YVEL.HIGH,X
 	STA	YVEL.HIGH,X
 
 	SEC
 	LDA	#0
	SBC	YPOS.LOW,X
	STA	YPOS.LOW,X
	LDA	BOUNCE
	SBC	YPOS.HIGH,X
 	CLC
 	ADC	BOUNCE
	STA	YPOS.HIGH,X
 	RTS
 
 
 
; Handle the ball hitting a platform
; ----------------------------------
; Pre - X = object number of ball to bounce
;       PLATFORM contains number of platform to bounce off
; Preserves X
REVERSE_X	; Find row to bounce off
 	LDA	XPOS.HIGH,X
 	AND	#255-3
	STA	BOUNCE
	LDA	XVEL.HIGH,X
 	BPL	!OFFLEFT
	LDA	BOUNCE
	CLC
 	ADC	#4
	STA	BOUNCE
!OFFLEFT	; Bounce xvel and xpos
	LDA	#0
	SEC
 	SBC	XVEL.LOW,X
	STA	XVEL.LOW,X
	LDA	#0
	SBC	XVEL.HIGH,X
 	STA	XVEL.HIGH,X
 
 	SEC
 	LDA	#0
	SBC	XPOS.LOW,X
	STA	XPOS.LOW,X
	LDA	BOUNCE
	SBC	XPOS.HIGH,X
 	CLC
 	ADC	BOUNCE
	STA	XPOS.HIGH,X
 	RTS
 
 
 
; Add velocities to the positions of the sprites
; ----------------------------------------------
MOVE_SPRITES	LDX	#NUM_OBJS-1
!LOOP	LDA	STATUS,X
 	BEQ	!DEAD
 	LDA	XVEL.LOW,X
	CLC
 	ADC	XPOS.LOW,X
	STA	XPOS.LOW,X
	LDA	XVEL.HIGH,X
 	ADC	XPOS.HIGH,X
 	STA	XPOS.HIGH,X
 	LDA	YVEL.LOW,X
	CLC
 	ADC	YPOS.LOW,X
	STA	YPOS.LOW,X
	LDA	YVEL.HIGH,X
 	ADC	YPOS.HIGH,X
 	STA	YPOS.HIGH,X
!DEAD	DEX
	BPL	!LOOP
 	RTS
 
 
; ============================
; High level movement routines
; ============================
 
 
; Move the main sprite appropriately
; ----------------------------------
; Pre - X = object to move as a player,
;       CONTROL and CONTROLDOWN are commands to execute
; Preserves X
MOVE_MAN	; Damp the man's current velocity
;	JSR	DAMP_VEL
 	; Check all joystick directions
 	LDA	CONTROL
 	AND	#JOY_UP
 	BEQ	!NOT_UP
 	JSR	MOVE_UP
 	JSR	ON_LADDER	; Check to see if still on ladder
 	BCS	!NOT_UP
 	JSR	MOVE_DOWN	; Go back to previous position
!NOT_UP	LDA	CONTROL
	AND	#JOY_DOWN
 	BEQ	!NOT_DOWN
 	JSR	MOVE_DOWN
 	JSR	ON_LADDER	; Check to see if still on ladder
 	BCS	!NOT_DOWN
 	JSR	MOVE_UP		; Go back to previous position
!NOT_DOWN	LDA	CONTROL
	AND	#JOY_LEFT
 	BEQ	!NOT_LEFT
 	JSR	MOVE_LEFT
 	JSR	ON_PLATFORM	; Check to see if still on platform
 	BCS	!NOT_LEFT
 	JSR	MOVE_RIGHT
!NOT_LEFT	LDA	CONTROL
	AND	#JOY_RIGHT
	BEQ	!NOT_RIGHT
	JSR	MOVE_RIGHT
	JSR	ON_PLATFORM	; Check to see if still on platform
 	BCS	!NOT_RIGHT
	JSR	MOVE_LEFT
!NOT_RIGHT	LDA	CONTROLDOWN
 	AND	#JOY_FIRE
 	BEQ	!NOT_FIRE
 	JSR	FIRE_HARPOON
!NOT_FIRE	LDA	CONTROLDOWN
	AND	#JOY_EXTRA
	BEQ	!NOT_EXTRA
	JSR	SPAWN
!NOT_EXTRA	; Check that player is not offscreen
	LDA	XPOS.HIGH,X
 	CMP	#-4
 	BCC	!NOTATLEFT
	LDA	#0
	STA	XPOS.LOW,X
	STA	XVEL.LOW,X
	STA	XVEL.HIGH,X
 	STA	XPOS.HIGH,X
 	JMP	!NOTATRIGHT
!NOTATLEFT	CMP	#160-WIDTH_OBJ5+1
 	BCC	!NOTATRIGHT
 	LDA	#0
	STA	XVEL.LOW,X
	STA	XVEL.HIGH,X
 	LDA	#128
	STA	XPOS.LOW,X
	LDA	#160-WIDTH_OBJ5
 	STA	XPOS.HIGH,X
!NOTATRIGHT	RTS

  

; Is object X on a ladder?
; ------------------------
; Pre - X = number of object (assumes it is the player)
; Post - carry set if on ladder
; Preserves X
ON_LADDER	LDY	#0
 	CPY	NUMLADDERS
	BEQ	!END
!LOOP	LDA	LADDER_X,Y
 	SEC
 	SBC	#(WIDTH_OBJ5)/2
 	STA	BANGX
 	LDA	XPOS.HIGH,X
 	SEC
 	SBC	BANGX
 	CMP	#WIDTH_LADDER
 	BCS	!NOGO
 	LDA	LADDER_Y,Y
	SEC
 	SBC	#HEIGHT_OBJ5
	STA	BANGY
 	LDA	LADDER_HEIGHT,Y
 	STA	BANGHEIGHT
	INC	BANGHEIGHT
	LDA	YPOS.HIGH,X
 	SEC
 	SBC	BANGY
 	CMP	BANGHEIGHT
	BCS	!NOGO
 	; Found ladder to climb
 	SEC
 	RTS
!NOGO	; Continue checking other ladders
	INY
 	CPY	NUMLADDERS
	BNE	!LOOP
!END	CLC
 	RTS
 
 
; Is object X on a platform?
; --------------------------
; Pre - X = number of object (assumes it is the player)
; Post - carry set if on a platform or the ground
; Preserves X
ON_PLATFORM	; Check for being on the floor
 	LDA	YPOS.HIGH,X
 	CMP	#SCRBOT-HEIGHT_OBJ5
 	BEQ	!FOUND
	LDY	#0
	CPY	NUMBOXES	; No platforms to check
	BEQ	!END
!LOOP	LDA	BOX_X,Y
	SEC
 	SBC	#(WIDTH_OBJ5)/2
 	STA	BANGX
 	LDA	XPOS.HIGH,X
 	SEC
 	SBC	BANGX
 	CMP	BOX_WIDTH,Y
 	BCS	!NOGO
 	LDA	BOX_Y,Y
 	SEC
 	SBC	#HEIGHT_OBJ5
	CMP  	YPOS.HIGH,X
 	BNE	!NOGO		; Must be the same height
!FOUND	; Found platform to walk on
 	SEC
 	RTS
!NOGO	; Continue checking other ladders
	INY
 	CPY	NUMLADDERS
	BNE	!LOOP
!END	CLC
 	RTS
 
 
 
; Widths of all objects
; ---------------------
OBJWIDTHS	DB	WIDTH_OBJ0, WIDTH_OBJ1, WIDTH_OBJ2
	DB	WIDTH_OBJ3, WIDTH_OBJ4, WIDTH_OBJ5
 
 
; Heights of all objects
; ----------------------
OBJHEIGHTS	DB	HEIGHT_OBJ0, HEIGHT_OBJ1, HEIGHT_OBJ2
	DB	HEIGHT_OBJ3, HEIGHT_OBJ4, HEIGHT_OBJ5

 
; Position of floor (relative to objects)
; ---------------------------------------
POS_FLOOR	DB	SCRBOT-HEIGHT_OBJ0, SCRBOT-HEIGHT_OBJ1
	DB	SCRBOT-HEIGHT_OBJ2, SCRBOT-HEIGHT_OBJ3
 	DB	SCRBOT-HEIGHT_OBJ4, SCRBOT-HEIGHT_OBJ5
 
 
; Position of right wall (relative to objects)
; --------------------------------------------
POS_WALL	DB	160-WIDTH_OBJ0, 160-WIDTH_OBJ1
 	DB	160-WIDTH_OBJ2, 160-WIDTH_OBJ3
 	DB	160-WIDTH_OBJ4, 160-WIDTH_OBJ5
 
 
; Move object X as if it were a bouncing ball
; -------------------------------------------
; Preserves X
MOVE_BALL	; Y = type of object
 	LDA	OBJTYPE,X
 	TAY
 	; Does it need to bounce off the ceiling?
 	LDA	YPOS.HIGH,X
 	CMP	#-20
	BCC	!YNOTNEG
	LDA	#0
	STA	BOUNCE
	JMP	!REVERSE_Y
!YNOTNEG	; Does it need to bounce off the floor?
 	LDA	POS_FLOOR,Y
 	STA	BOUNCE
	CMP	YPOS.HIGH,X
 	BEQ	!REVERSE_Y
	BCS	!NOBOUNCE
!REVERSE_Y	; Bounce the y velocity
 	LDA	#0
	SEC
 	SBC	YVEL.LOW,X
	STA	YVEL.LOW,X
	LDA	#0
	SBC	YVEL.HIGH,X
 	STA	YVEL.HIGH,X
 
 	SEC
 	LDA	#0
	SBC	YPOS.LOW,X
	STA	YPOS.LOW,X
	LDA	BOUNCE
	SBC	YPOS.HIGH,X
 	CLC
 	ADC	BOUNCE
	STA	YPOS.HIGH,X
 
!NOBOUNCE	; Does it need to bounce horizontally?
 	LDA	#-20
	CMP	XPOS.HIGH,X
 	BCS	!XNOTNEG
	LDA	#0
	STA	BOUNCE
	JMP	!REVERSE_X
!XNOTNEG	LDA	POS_WALL,Y
	STA	BOUNCE
	CMP	XPOS.HIGH,X
 	BEQ	!REVERSE_X
	BCS	!NOBOUNCE2	
!REVERSE_X	; Bounce the x velocity
 	LDA	#0
	SEC
 	SBC	XVEL.LOW,X
	STA	XVEL.LOW,X
	LDA	#0 
 	SBC	XVEL.HIGH,X
 	STA	XVEL.HIGH,X
 
 	SEC
 	LDA	#0
	SBC	XPOS.LOW,X
	STA	XPOS.LOW,X
	LDA	BOUNCE
	SBC	XPOS.HIGH,X
 	CLC
 	ADC	BOUNCE
	STA	XPOS.HIGH,X
 
!NOBOUNCE2	; Add gravity to the ball
 	LDA	YVEL.LOW,X
	CLC
 	ADC	#<GRAVITY
 	STA	YVEL.LOW,X
	LDA	YVEL.HIGH,X
 	ADC	#>GRAVITY
 	STA	YVEL.HIGH,X
 	RTS
 
 
 
; ===========================
; Low level movement routines
; ===========================

 
; Move object X down NOW
; ----------------------
MOVE_DOWN	LDA	YPOS.LOW,X
 	CLC
 	ADC	#<MAN_DOWNVEL
 	STA	YPOS.LOW,X
	LDA	YPOS.HIGH,X
 	ADC	#>MAN_DOWNVEL
 	STA	YPOS.HIGH,X
 	RTS
 
 
; Move object X up NOW
; --------------------
MOVE_UP	LDA	YPOS.LOW,X
 	CLC
 	ADC	#<MAN_UPVEL
 	STA	YPOS.LOW,X
	LDA	YPOS.HIGH,X
 	ADC	#>MAN_UPVEL
 	STA	YPOS.HIGH,X
 	RTS
 
 
; Move object X left NOW
; ----------------------
MOVE_LEFT	LDA	XPOS.LOW,X
 	CLC
 	ADC	#<MAN_LEFTVEL
 	STA	XPOS.LOW,X
	LDA	XPOS.HIGH,X
 	ADC	#>MAN_LEFTVEL
 	STA	XPOS.HIGH,X
 	RTS
 
 
; Move object X right NOW
; -----------------------
MOVE_RIGHT	LDA	XPOS.LOW,X
	CLC
 	ADC	#<MAN_RIGHTVEL
	STA	XPOS.LOW,X
	LDA	XPOS.HIGH,X
 	ADC	#>MAN_RIGHTVEL
	STA	XPOS.HIGH,X
 	RTS
 
 
; Accelerate object X down
; ------------------------
ACC_DOWN	LDA	YVEL.LOW,X
	CLC
 	ADC	#<ACCELY
	STA	YVEL.LOW,X
	LDA	YVEL.HIGH,X
 	ADC	#>ACCELY
	STA	YVEL.HIGH,X
 	RTS	

; Accelerate object X up
; ----------------------
ACC_UP	LDA	YVEL.LOW,X
	SEC
 	SBC	#<ACCELY
	STA	YVEL.LOW,X
	LDA	YVEL.HIGH,X
 	SBC	#>ACCELY
	STA	YVEL.HIGH,X
 	RTS	

 
; Accelerate object X left
; ------------------------
ACC_LEFT	LDA	XVEL.LOW,X
	SEC
 	SBC	#<ACCELX
	STA	XVEL.LOW,X
	LDA	XVEL.HIGH,X
 	SBC	#>ACCELX
	STA	XVEL.HIGH,X
 	RTS	

 
; Accelerate object X right
; -------------------------
ACC_RIGHT	LDA	XVEL.LOW,X
 	CLC
 	ADC	#<ACCELX
	STA	XVEL.LOW,X
	LDA	XVEL.HIGH,X
 	ADC	#>ACCELX
	STA	XVEL.HIGH,X
 	RTS	

 
; Damp X and Y velocities of object X
; -----------------------------------
DAMP_VEL	LDA	YVEL.HIGH,X
 	BMI	!UP
 	JSR	DAMPDOWN
	JMP	!NEXT
!UP	JSR	DAMPUP
!NEXT	LDA	XVEL.HIGH,X
	BMI	!LEFT
 	JMP	DAMPRIGHT
!LEFT	JMP	DAMPLEFT
 
 
 
; Damp the leftward movement of object X
; --------------------------------------
DAMPLEFT	LDA	XVEL.LOW,X
	CLC
 	ADC	#<DAMPX
 	STA	XVEL.LOW,X
	LDA	XVEL.HIGH,X
 	ADC	#>DAMPX
 	STA	XVEL.HIGH,X
 	BCC	!DONE
 	LDA	#0
	STA	XVEL.LOW,X
	STA	XVEL.HIGH,X
!DONE	RTS

 
; Damp the rightward movement of object X
; ---------------------------------------
DAMPRIGHT	LDA	XVEL.LOW,X
 	SEC
 	SBC	#<DAMPX
 	STA	XVEL.LOW,X
	LDA	XVEL.HIGH,X
 	SBC	#>DAMPX
 	STA	XVEL.HIGH,X
 	BCS	!DONE
 	LDA	#0
	STA	XVEL.LOW,X
	STA	XVEL.HIGH,X
!DONE	RTS

 
 
; Damp the upward movement of object X
; ------------------------------------
DAMPUP	LDA	YVEL.LOW,X
	CLC
 	ADC	#<DAMPY
 	STA	YVEL.LOW,X
	LDA	YVEL.HIGH,X
 	ADC	#>DAMPY
 	STA	YVEL.HIGH,X
 	BCC	!DONE
 	LDA	#0
	STA	YVEL.LOW,X
	STA	YVEL.HIGH,X
!DONE	RTS

 
; Damp the downward movement of object X
; --------------------------------------
DAMPDOWN	LDA	YVEL.LOW,X
	SEC
 	SBC	#<DAMPY
 	STA	YVEL.LOW,X
	LDA	YVEL.HIGH,X
 	SBC	#>DAMPY
 	STA	YVEL.HIGH,X
 	BCS	!DONE
 	LDA	#0
	STA	YVEL.LOW,X
	STA	YVEL.HIGH,X
!DONE	RTS

 
 
; ============================
; Collision detection routines
; ============================
 
; Object size definitions
; -----------------------
WIDTH_OBJ0	EQU	0	; Null object
HEIGHT_OBJ0	EQU	0
WIDTH_OBJ1	EQU	3	; Tiny ball
HEIGHT_OBJ1	EQU	4
WIDTH_OBJ2	EQU	5	; Small ball
HEIGHT_OBJ2	EQU	7
WIDTH_OBJ3	EQU	8	; Medium ball
HEIGHT_OBJ3	EQU	14
WIDTH_OBJ4	EQU	12	; Large ball
HEIGHT_OBJ4	EQU	21
WIDTH_OBJ5	EQU	7	; Player
HEIGHT_OBJ5	EQU	21
 
 
; Setup size of box depending on type of object
; (Only sets up variables for ball objects)
; ---------------------------------------------
CALC_SIZES	; Calculate X positions
 	LDA	BANGX
 	SEC
 	SBC	#WIDTH_OBJ1
 	STA	BANGX+1
 	SBC	#(WIDTH_OBJ2-WIDTH_OBJ1)
	STA	BANGX+2
 	SBC	#(WIDTH_OBJ3-WIDTH_OBJ2)
	STA	BANGX+3
 	SBC	#(WIDTH_OBJ4-WIDTH_OBJ3)
	STA	BANGX+4
 	; Calculate Y positions
 	LDA	BANGY
 	SEC
 	SBC	#HEIGHT_OBJ1
	STA	BANGY+1
 	SBC	#(HEIGHT_OBJ2-HEIGHT_OBJ1)
	STA	BANGY+2
 	SBC	#(HEIGHT_OBJ3-HEIGHT_OBJ2)
	STA	BANGY+3
 	SBC	#(HEIGHT_OBJ4-HEIGHT_OBJ3)
	STA	BANGY+4
 	; Calculate widths
	LDA	BANGWIDTH
 	CLC
 	ADC	#WIDTH_OBJ1
 	STA	BANGWIDTH+1
 	ADC	#(WIDTH_OBJ2-WIDTH_OBJ1)
	STA	BANGWIDTH+2
 	ADC	#(WIDTH_OBJ3-WIDTH_OBJ2)
	STA	BANGWIDTH+3
 	ADC	#(WIDTH_OBJ4-WIDTH_OBJ3)
	STA	BANGWIDTH+4
 	; Calculate heights
 	LDA	BANGHEIGHT
	CLC
 	ADC	#HEIGHT_OBJ1
	STA	BANGHEIGHT+1
	ADC	#(HEIGHT_OBJ2-HEIGHT_OBJ1)
	STA	BANGHEIGHT+2
	ADC	#(HEIGHT_OBJ3-HEIGHT_OBJ2)
	STA	BANGHEIGHT+3
	ADC	#(HEIGHT_OBJ4-HEIGHT_OBJ3)
	STA	BANGHEIGHT+4
	RTS
 
 
; Setup variables for collision check with harpoon
; ------------------------------------------------
; Pre - HARPOON pointer is set to active harpoon
; Post - bang variables set up
SETUP_CHECK	LDA	#ST_HIT.W2
 	LDY	HARPOON
 	BNE	!USE2
 	LDA	#ST_HIT.W1
!USE2	STA	BITSET
 	LDA	WIRE_X,Y
	STA	BANGX
 	LDA	WIRE_TOP,Y
	STA	BANGY
 	LDA	#1
	STA	BANGWIDTH
 	LDA	WIRE_BOT,Y
	SEC
 	SBC	WIRE_TOP,Y
	STA	BANGHEIGHT
	JMP	CALC_SIZES

 
 
; Setup variables for collision check with another object
; -------------------------------------------------------
; Pre - X = object to check collision with
; Post - bang variables setup except for BITSET
SETUP_CHECK2	LDA	XPOS.HIGH,X
 	STA	BANGX
 	LDA	YPOS.HIGH,X
 	STA	BANGY
 	LDA	OBJTYPE,X
 	TAY
 	LDA	OBJWIDTHS,Y
 	STA	BANGWIDTH
 	LDA	OBJHEIGHTS,Y
	STA	BANGHEIGHT
	JMP	CALC_SIZES

 
 
; Setup variables for collision check with a platform
; ---------------------------------------------------
; Pre - Y = platform to check collision with
; Post - bang variables setup
SETUP_CHECK3	LDA	#ST_HIT.PLAT
	STA	BITSET
	LDA	BOX_X,Y
 	STA	BANGX
 	LDA	BOX_Y,Y
 	STA	BANGY
 	LDA	BOX_WIDTH,Y
 	STA	BANGWIDTH
 	LDA	BOX_HEIGHT,Y
	STA	BANGHEIGHT
	JMP	CALC_SIZES

 
 
; Check object X for a platform collision
; ---------------------------------------
CHECK_CRASH.P	; Find location of ball
	LDA	YPOS.HIGH,X
 	LSR
 	LSR
 	LSR
 	TAY
 	LDA	COLLIS.LOW,Y
	STA	PTR1
	LDA	COLLIS.HIGH,Y
 	STA	PTR1+1
	LDA	XPOS.HIGH,X
 	LSR
 	LSR
 	TAY
 	LDA	(PTR1),Y
	STA	TEMP
	; Mask with object type
 	LDY	OBJTYPE,X
 	AND	COLLISMASKY,Y
 	PHA
 	LDA	TEMP
	AND	COLLISMASKX,Y
 	BEQ	!NOREVX
 	JSR	REVERSE_X
!NOREVX	PLA
	BEQ	!NOREVY
 	JSR	REVERSE_Y
!NOREVY	RTS

 
 
; Check object X for a collision
; ------------------------------
; Pre - bang variables set, X = object to check
; Post - carry set if collision occured
CHECK_CRASH	LDA	OBJTYPE,X
	TAY
 	LDA	XPOS.HIGH,X
 	SEC
 	SBC	BANGX,Y
 	CMP	BANGWIDTH,Y
 	BCS	!NOGO
 	LDA	YPOS.HIGH,X
 	SEC
 	SBC	BANGY,Y
 	CMP	BANGHEIGHT,Y
	BCS	!NOGO
 	LDA	HITSTATUS,X
 	AND	BITSET
	BEQ	!DONE
 	LDA	HITSTATUS,X
 	EOR	BITSET
	STA	HITSTATUS,X
 	; Inform calling routine of crash
 	SEC
 	RTS
!NOGO	 ; Allow it to crash
 	LDA	HITSTATUS,X
 	ORA	BITSET
	STA	HITSTATUS,X	
!DONE	CLC
	RTS
 
 
 
; Check object X for a collision (simple version)
; -----------------------------------------------
; Pre - bang variables set, X = object to check
; Post - carry set if collision occured
; This version does not worry about the objects previous collision state
CHECK_CRASH2	LDA	OBJTYPE,X
 	TAY
 	LDA	XPOS.HIGH,X
 	SEC
 	SBC	BANGX,Y
 	CMP	BANGWIDTH,Y
 	BCS	!NOGO
 	LDA	YPOS.HIGH,X
 	SEC
 	SBC	BANGY,Y
 	CMP	BANGHEIGHT,Y
	BCS	!NOGO
 	; Inform calling routine of crash
 	SEC
 	RTS
!NOGO	; Allow it to crash
!DONE	CLC
	RTS
 
 
 
; ========================
; Object creation routines
; ========================
 
 
; Create a new object from object X (player)
; ------------------------------------------
SPAWN	; Find new object to create
	LDY	#NUM_OBJS
!LOOP	DEY
	BMI	!NONE
 	LDA	STATUS,Y
	BNE	!LOOP
 
 	LDA	#<NOERASE
 	STA	SPRKILL.LOW,Y
 	LDA	#>NOERASE
 	STA	SPRKILL.HIGH,Y
	LDA	#0
	LDA	XPOS.HIGH,X
 	SEC
 	SBC	#(WIDTH_OBJ4-WIDTH_OBJ5)/2
	STA	XPOS.HIGH,Y
 	LDA	XVEL.LOW,X
	STA	XVEL.LOW,Y
	LDA	XVEL.HIGH,X
 	STA	XVEL.HIGH,Y
 	LDA	#0
	STA	XPOS.LOW,Y
	STA	YPOS.LOW,Y
	STA	YVEL.LOW,Y
	STA	YVEL.HIGH,Y
 	LDA	#50
 	STA	YPOS.HIGH,Y
 	LDA	#4
	STA	OBJTYPE,Y
 	LDA	#ST_HARDWARE+ST_BALL
	STA	STATUS,Y
!NONE	RTS

 
 
; Split a ball up (object x)
; --------------------------
; Preserves X 
SPLIT_BALL	; Change type of object
 	DEC	OBJTYPE,X
 	BNE	!KEEP
 	; Destroy an object if necessary
	LDA	STATUS,X
	ORA	#ST_DEAD
	STA	STATUS,X	
 	RTS
!KEEP	; Find out status of object
	LDA	OBJTYPE,X
 	TAY
 	LDA	STATUSTYPE,Y
	STA	STATUS,X
	; Find new object to use
	LDY	#NUM_OBJS
!LOOP	DEY
	BMI	!NONE
 	LDA	STATUS,Y
	BNE	!LOOP
 	; Set up new object (moving left)
 	LDA	OBJTYPE,X
 	STA	OBJTYPE,Y
 	LDA	STATUS,X
	STA	STATUS,Y
	LDA	#<NOERASE
 	STA	SPRKILL.LOW,Y
 	LDA	#>NOERASE
 	STA	SPRKILL.HIGH,Y
	LDA	XPOS.LOW,X
	STA	XPOS.LOW,Y
	LDA	XPOS.HIGH,X
 	STA	XPOS.HIGH,Y
 	LDA	YPOS.LOW,X
	STA	YPOS.LOW,Y
	LDA	YPOS.HIGH,X
 	STA	YPOS.HIGH,Y
 	LDA	#<LEFTVEL
 	STA	XVEL.LOW,Y
	LDA	#>LEFTVEL
 	STA	XVEL.HIGH,Y
 	LDA	#<UPVEL
 	STA	YVEL.LOW,Y
	LDA	#>UPVEL
 	STA	YVEL.HIGH,Y
!NONE	; Change original object (moving right)
	LDA	#<RIGHTVEL
	STA	XVEL.LOW,X
	LDA	#>RIGHTVEL
	STA	XVEL.HIGH,X
 	LDA	#<UPVEL
 	STA	YVEL.LOW,X
	LDA	#>UPVEL
 	STA	YVEL.HIGH,X
 	RTS
 
 
; Kill the player
; ---------------
; Preserves X
; Assumes PLAYER is set to players number
KILLME	STX	SPRNUM
	JSR	SFX3
	LDA	PLAYER
	BNE	!KILL2
	; Kill player 1
 	LDA	#0
	STA	HARPOON
 	JSR	ERASE_HARPOON
 	LDX	MAN.P1
	LDA	#0
	STA	STATUS,X
	LDA	#255
	STA	MAN.P1
	LDA	MAN.P2		; Check to see if both are dead
 	BMI	!BOTHDEAD
 	LDX	SPRNUM
	RTS
!KILL2	; Kill player 2
 	LDA	#1
	STA	HARPOON
 	JSR	ERASE_HARPOON
 	LDX	MAN.P2
	LDA	#0
	STA	STATUS,X
	LDA	#255
	STA	MAN.P2
	LDA	MAN.P1
	BMI	!BOTHDEAD
 	LDX	SPRNUM
	RTS
!BOTHDEAD	; Both players are dead
	LDA	#1
	STA	DEAD
	RTS
 
 
 
; ================
; Weapons routines
; ================
 
 
; Fire the harpoon
; ----------------
; Pre - X is object to fire harpoon from
; Preserves X
FIRE_HARPOON	; See if it is already in use
 	LDY	HARPOON
 	LDA	WIRE_FLAG,Y
 	BEQ	!OK
 	; Kill previous harpoon
 	STX	SPRNUM
	JSR	ERASE_HARPOON
 	LDX	SPRNUM
!OK	; Setup variables
	LDY	HARPOON
 	LDA	XPOS.HIGH,X
 	CLC
 	ADC	#(WIDTH_OBJ5)/2
 	STA	WIRE_X,Y
	LDA	YPOS.HIGH,X
 	STA	WIRE_TOP,Y
	CLC
 	ADC	#HEIGHT_OBJ5
	STA	WIRE_LASTTOP,Y
	STA	WIRE_BOT,Y
	LDA	#1
	STA	WIRE_FLAG,Y
 	JMP	DRAW_HARPOON

 
 
; Handle moving the harpoons
; --------------------------
MOVE_HARPOONS	LDY	#0
!LOOP	STY	HARPOON
	LDA	WIRE_FLAG,Y
 	BEQ	!DONE
 	LDA	WIRE_TOP,Y
	STA	WIRE_LASTTOP,Y
	BEQ	!DONE
 	; Move harpoon up a bit
 	LDA	WIRE_TOP,Y
	SEC
 	SBC	#3
	BCS	!NOTATTOP
 	LDA	#0
!NOTATTOP	STA	WIRE_TOP,Y
 	JSR	DRAW_HARPOON
!DONE	LDY	HARPOON
	INY
 	CPY	#NUM_HARPOONS
 	BNE	!LOOP
 	RTS
