;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; =====================================
; This file contains bitmap access code
; sprite handling and sprite printing
; =====================================

 
; Table of colours - used for plotting pixels
; -------------------------------------------
PIXBITS	DB	192, 48, 12, 3
PIXBITS2	DB	255-192, 255-48, 255-12, 255-3
 
 
; Shape data for balls
SH00	EQU	%11001111
SH01	EQU	%00000011
SH02	EQU	%00000011
SH03	EQU	%11001111

SH10	EQU	%11110011
SH11	EQU	%11000000
SH12	EQU	%11000000
SH13	EQU	%11110011

SH20	EQU	%1111110011111111
SH21	EQU	%1111000000111111
SH22	EQU	%1111000000111111
SH23	EQU	%1111110011111111

SH30	EQU	%1111111100111111
SH31	EQU	%1111110000001111
SH32	EQU	%1111110000001111
SH33	EQU	%1111111100111111


; Status of various sizes of object (software/hardware)
; -----------------------------------------------------
STATUSTYPE	DB	0, ST_SOFTWARE+ST_BALL, ST_HARDWARE+ST_BALL
	DB	ST_HARDWARE+ST_BALL, ST_HARDWARE+ST_BALL
 
 
; Collision mask of various types of object
; -----------------------------------------
COLLISMASKY	DB	0, 1, 1, 2, 4, 0
COLLISMASKX	DB	0, 16, 16, 32, 64, 0

 
; Sprite definitions of objects
; -----------------------------
SPRITETYPE1	DB	0	; Null object
 	DB	0	; Tiny ball (software sprite)
	DB	(SMALL_BALL1-VICBANK)/64
 	DB	(MED_BALL1-VICBANK)/64
 	DB	(BIG_BALL-VICBANK)/64
	DB	(PLAYER_1-VICBANK)/64

SPRITETYPE2	; Versions of sprites for lower half of screen
 	DB	0
	DB	0
	DB	(SMALL_BALL2-VICBANK)/64
 	DB	(MED_BALL2-VICBANK)/64
 	DB	(BIG_BALL-VICBANK)/64
	DB	(PLAYER_1-VICBANK)/64

 
; ========================
; Hardware sprite routines
; ========================



; Plot objects which are hardware sprites
; onto the screen.
; ---------------------------------------
PLOT_SPRITES	; Clear all interrupts
	LDX	#7
	LDA	#0
!CLRLOOP	STA	IRQTYPE,X
 	STA	IRQTYPE+8,X
 	STA	IRQTYPE+16,X
	STA	IRQTYPE+24,X
	STA	IRQTYPE+32,X
	STA	IRQTYPE+40,X
	STA	IRQTYPE+48,X
	STA	IRQTYPE+56,X
	DEX
 	BPL	!CLRLOOP
	; Set split IRQ at top
	LDA	#128+4
	STA	IRQTYPE+0
 	; Set first IRQ near top
	LDA	#128+1
	STA	IRQTYPE+1	; Note that this will be delayed
	; Set split irq near bottom
 	LDA	#128+3
	STA	IRQTYPE+61
	; Set final IRQ at bottom (placeholders)
	LDA	#128+2
	STA	IRQTYPE+63
	STA	IRQTYPE+62

 	; Insert sprites into position
	LDX	#0
	LDY	#1
!LOOP	LDA	STATUS,X
 	AND	#ST_HARDWARE
	BEQ	!NOTSPRITE
	STY	SPRNUM
	; Get sprite ypos
 	LDA	YPOS.HIGH,X
 	BMI	!ATBOT
	; Handle sprites in upper half of screen
	CLC
 	ADC	#50	; Add vertical offset
 	STA	VIRT_YPOS,Y
 	; Get sprite definition
 	LDY	OBJTYPE,X
 	LDA	SPRITETYPE1,Y
 	LDY	SPRNUM
	STA	VIRT_SHAPE,Y
	JMP	!CONT
 
!ATBOT	; Handle sprites in lower half of screen
	LDY	OBJTYPE,X	; Y = type of object
	CLC
 	ADC	VERTOFFSET,Y	; Add vertical offset
	CMP	#250-21
 	BCS	!NOTSPRITE
	LDY	SPRNUM
	STA	VIRT_YPOS,Y
 	; Get sprite definition
 	LDY	OBJTYPE,X
 	LDA	SPRITETYPE2,Y
 	LDY	SPRNUM
	STA	VIRT_SHAPE,Y

!CONT	; Find the xpos of the sprite
	LDA	XPOS.LOW,X
	ROL
 	LDA	XPOS.HIGH,X
 	PHP
 	CLC
 	ADC	#12	; Add horizontal offset
 	PLP
 	ROL
 	STA	VIRT_XPOS,Y
 	LDA	#0
	BCC	!NOTFAR
 	LDA	#255
!NOTFAR	STA	VIRT_MSB,Y
 	; Now find gap in interrupt set
 	STX	SPRNUM
	LDA	VIRT_YPOS,Y
 	LSR
 	LSR
 	TAX
 	CMP	#4
	BCC	!NOHOPE
 	DEX
!FINDLOOP	DEX
	BEQ	!NOHOPE	; No interrupts available before sprite position
	LDA	IRQTYPE,X
 	BNE	!FINDLOOP
 	TYA
 	STA	IRQTYPE,X
!NOHOPE	LDX	SPRNUM
 	; Keep going
	INY
 	CPY	#MAX_SPRITES
	BEQ	!TOOMANY	; No virtual sprites left	
!NOTSPRITE	INX
 	CPX	#NUM_OBJS
 	BNE	!LOOP
!TOOMANY	; End of routine
	RTS
 
 
; Vertical offsets to add to hardware sprites in lower half of screen
; -------------------------------------------------------------------
VERTOFFSET	DB	0, 0, 50+HEIGHT_OBJ2-21
	DB	50+HEIGHT_OBJ3-21, 50+HEIGHT_OBJ4-21, 50+HEIGHT_OBJ5-21

 
; Start up the IRQ handler from the bottom
; ----------------------------------------
SETUP_IRQ	; Set up first interrupt
 	SEI
 	XY	IRQVEC
 	STXY	VECTOR_IRQ
 	XY	IRQ_HANDLER
	STXY	IRQVEC+1
 	LDA	#_JMP
 	STA	IRQVEC
	LDA	#1
	STA	RASTER_ENABLE
 	LDA	RASTER_FLAG
 	STA	RASTER_FLAG
 	LDA	#0
	STA	CURRENTPOS
	STA	RASTER.LOW
	CLI
 	RTS
 
 
 
; Main game IRQ handler
; ---------------------
IRQ_HANDLER
;	INC	BORDER_COL
 	STA	IRQ.A
 	STX	IRQ.X
 	STY	IRQ.Y
 	; Acknowledge interrupt
 	LDA	RASTER_FLAG
 	STA	RASTER_FLAG
 	; Find out type of interrupt
REPEATIRQ	LDX	CURRENTPOS
 	LDA	IRQTYPE,X
 	BMI	USEOTHER
	TAX			; X = virtual sprite number
 
 	; Plot virtual sprite
 	INC	CURRENTSPRITE
 	LDA	CURRENTSPRITE
 	AND	#7
	ASL
 	TAY			; Y = pointer to hardware sprite
;	LDA	SPRITE_POS+1,Y	; Test to see if we should try
;	CLC			; to use this sprite 
;	ADC	#21
;	CMP	RASTER.LOW
;	BCS	!GIVEUP
	LDA	VIRT_XPOS,X
 	STA	SPRITE_POS,Y
	LDA	VIRT_YPOS,X
 	STA	SPRITE_POS+1,Y
	TYA
 	LSR
 	TAY
 	LDA	VIRT_SHAPE,X
	STA	SCREEN+$3F8,Y
 	LDA	VIRT_MSB,X
	BEQ	!ISLEFT
 	LDA	SPRITE_MSB
	ORA	BIT_MASK0,Y
 	JMP	!OKMSB
!ISLEFT	LDA	SPRITE_MSB
 	AND	BIT_MASK1,Y	
!OKMSB	STA	SPRITE_MSB
!GIVEUP	; End of sprite plotting code

 	; Find next interrupt (there MUST be at least one)
FINDIRQ	TSX
	STX	STACKPTR
	LDX	CURRENTPOS
	TXS
 	; ************* WARNING *******************************
 	; Keep well clear of page boundary (for timing)
 	; *****************************************************
!LOOP	PLA
	BNE	!FOUND
	PLA
 	BNE	!FOUND
	PLA
 	BNE	!FOUND
	PLA
 	BEQ	!LOOP
 
!FOUND	TSX
 	STX	CURRENTPOS
	TXA
 	LDX	STACKPTR
	TXS
 	ASL
 	ASL
 	TAX
 	STX	RASTER.LOW	; Important for frame overrun
	; Check to see if it will be late - if so, go back
	CPX	RASTER.LOW
	BCS	ENDIRQ
	BCC	REPEATIRQ

USEOTHER	; Dispatch other types of interrupt
 	AND	#7
	ASL
 	TAX
 	LDA	OTHERIRQ,X
	STA	IJPTR
 	LDA	OTHERIRQ+1,X
	STA	IJPTR+1
 	JMP	(IJPTR)	

FINALIRQ	; Don't worry about next interrupt
	LDA	#0
	STA	RASTER_ENABLE
ENDIRQ	; End interrupt
 	LDA	IRQ.A
 	LDX	IRQ.X
 	LDY	IRQ.Y
;	DEC	BORDER_COL
 	RTI
 
 
; Table of various interrupt routines
; -----------------------------------
OTHERIRQ	DW	NULLIRQ, FIRSTIRQ, LASTIRQ, SPLITIRQ
 	DW	SPLITIRQTOP, NULLIRQ, NULLIRQ, NULLIRQ
 
 
; Placeholder interrupt
; ---------------------
NULLIRQ	JMP	FINDIRQ

 
; Interrupt at top of screen
; --------------------------
FIRSTIRQ	; Set sprite values to normal
 	LDA	#0		; Set sprites to be reused
	STA	SPRITE_EXPANDX
	LDA	#255
	STA	SPRITE_MULTI
	LDA	#BLACK
	STA	SPR0_COL
	STA	SPR1_COL
	STA	SPR2_COL
	STA	SPR3_COL
	STA	SPR4_COL
	STA	SPR5_COL
	STA	SPR6_COL
	STA	SPR7_COL
	; Set full size screen
	LDA	VIC_CTRL1
 	AND	#255-128		; Clear MSB of raster compare
 	ORA	#8
	STA	VIC_CTRL1
 	JMP	FINDIRQ		; Continue chain of interrupts
 
 
 
; Split interrupt at bottom of screen
; -----------------------------------
SPLITIRQ	; Enable sprites in the border
	LDX	#7
!SHLOOP	LDA	BITSPRDEFS,X
 	STA	SCREEN+$3F8,X
 	DEX
 	BPL	!SHLOOP
 
!LOOP	LDA	RASTER.LOW
 	CMP	#248
	BNE	!LOOP
 	LDA	VIC_CTRL1
 	AND	#255-128-8
	STA	VIC_CTRL1
 	; Display sprites in the bottom border
	LDA	#0
	STA	SPRITE_ENABLE
 	LDX	#16
!SLOOP	LDA	BOTSPRITES,X
	STA	SPRITE_POS,X
	DEX
 	BPL	!SLOOP
	LDA	#255
	STA	SPRITE_ENABLE
 	STA	SPRITE_EXPANDX
	LDA	#0
	STA	SPRITE_MULTI
	LDA	#LTGREEN
	STA	SPR0_COL
	STA	SPR1_COL
	STA	SPR2_COL
	STA	SPR3_COL
	STA	SPR4_COL
	STA	SPR5_COL
	STA	SPR6_COL
	STA	SPR7_COL
	JMP	LASTIRQ
 
 
; Split interrupt at top of screen
; --------------------------------
SPLITIRQTOP	LDX	#16
!SLOOP	LDA	TOPSPRITES,X
	STA	SPRITE_POS,X
	DEX
 	BPL	!SLOOP
	LDX	#7
!SHLOOP	LDA	BITSPRDEFS+8,X
 	STA	SCREEN+$3F8,X
 	DEX
 	BPL	!SHLOOP
 	; Delay next interrupt (one which switches sprites)
 	INC	CURRENTPOS
	LDA	#44
 	STA	RASTER.LOW
	JMP	ENDIRQ

 
; Interrupt to setup next frame
; -----------------------------
LASTIRQ	; Sync with foreground program
 	INC	FRAME
 	LDA	#0
	STA	CURRENTPOS
	STA	RASTER.LOW
	JMP	ENDIRQ		; This IRQ will repeat next frame
 				; if foreground program is too slow

 
; Data for sprites in bottom border
; ---------------------------------
BOTSPRITES	DB	24, 255, 24+48, 255, 24+48*2, 255, 24+48*3, 255
	DB	24+48*4, 255, 24+48*5-256, 255, 24+48*6-256, 255
 	DB	24+48*6-256, 255
 	DB	%11100000

TOPSPRITES	DB	24, 23, 24+48, 23, 24+48*2, 23, 24+48*3, 23
	DB	24+48*4, 23, 24+48*5-256, 23, 24+48*6-256, 23
	DB	24+48*6-256, 23
	DB	%11100000

BITSPRDEFS	DB	(BITSPR-VICBANK)/64, (BITSPR-VICBANK)/64+1
 	DB	(BITSPR-VICBANK)/64+2, (BITSPR-VICBANK)/64+3
 	DB	(BITSPR-VICBANK)/64+4, (BITSPR-VICBANK)/64+5
 	DB	(BITSPR-VICBANK)/64+6, (BITSPR-VICBANK)/64+7
 	DB	(BITSPR-VICBANK)/64+8, (BITSPR-VICBANK)/64+9
 	DB	(BITSPR-VICBANK)/64+10, (BITSPR-VICBANK)/64+11
 	DB	(BITSPR-VICBANK)/64+12, (BITSPR-VICBANK)/64+13
 	DB	(BITSPR-VICBANK)/64+14, (BITSPR-VICBANK)/64+15
 
 
; ====================
; Software sprite code
; ====================


; This code erases all balls
; --------------------------
ERASE_BALLS	LDX	#NUM_OBJS-1
!LOOP	LDA	STATUS,X
 	AND	#ST_SOFTWARE
	BEQ	!NOTBALL
	JSR	ERASE_BALL
!NOTBALL	DEX
 	BPL	!LOOP
 	RTS
 
 
 
; This code plots all balls
; -------------------------
PLOT_BALLS	LDX	#NUM_OBJS-1
!LOOP	LDA	STATUS,X
 	AND	#ST_SOFTWARE
	BEQ	!NOTBALL
	JSR	PLOT_BALL
!NOTBALL	DEX
 	BPL	!LOOP
 	RTS
 
 
 
; Do some address calculation from XY
; affects ptr1 and ptr2
CALC_ADDRESS	MACRO
 	STXY	PTR2
 	TYA		; Find position of rows
	LSR
 	LSR
 	LSR
 	TAY
 	LDA	ROWS.LOW,Y
	STA	PTR1
	LDA	ROWS.HIGH,Y
 	STA	PTR1+1
	LDA	PTR2
	AND	#252
	ASL
 	BCC	!NOINC
	INC	PTR1+1
!NOINC	CLC
 	ADC	PTR1
	STA	PTR1
	BCC	!NOINC2
 	INC	PTR1+1
!NOINC2	LDA	PTR2+1
 	AND	#7
	ENDM

 
 
; Plot a pixel on the bitmap
; --------------------------
; Pre - X = x position (0..159)
;       Y = y position (0..199)
; Post - point is set to colour 3
; Preserves X and Y
; Uses A, ptr1, ptr2
PLOT_PIXEL	; BITMAP+320*(y/8)+(y&7)+8*(x/4)	|= 3*2^(2*(3-x&3))
 	CALC_ADDRESS
	TAY
 	LDA	PTR2
	AND	#3
	TAX
 	LDA	(PTR1),Y
	ORA	PIXBITS,X
 	STA	(PTR1),Y
	LDXY	PTR2
 	RTS
 
 
 
; Erase pixel (as above)
; ----------------------
ERASE_PIXEL	; BITMAP+320*(y/8)+(y&7)+8*(x/4)	|= 3*2^(2*(3-x&3))
	CALC_ADDRESS
	TAY
 	LDA	PTR2
	AND	#3
	TAX
 	LDA	(PTR1),Y
	AND	PIXBITS2,X
	STA	(PTR1),Y
	LDXY	PTR2
 	RTS
 
 
; Plot software sprite X
; ----------------------
; Preserves X
; ptr1 = address, jptr = routine
PLOT_BALL	; Find position of this sprite
 	STX	SPRNUM
	LDA	YPOS.HIGH,X
 	TAY
 	LDA	XPOS.HIGH,X
 	TAX
 	; Calculate the address of the bytes
	CALC_ADDRESS
	CLC
 	ADC	PTR1
	STA	PTR1
	LDX	SPRNUM
	STA	SPRPOS.LOW,X
	LDA	PTR1+1
	ADC	#0
	STA	PTR1+1
	STA	SPRPOS.HIGH,X
 	; Calculate the routine address
 	LDA	YPOS.HIGH,X
 	AND	#7
	ROL
 	ROL
 	STA	TEMP
	LDA	XPOS.HIGH,X
 	AND	#3
	ORA	TEMP
	TAY
 	LDA	DOPLOT.LOW,Y
	STA	JPTR
	LDA	DOPLOT.HIGH,Y
 	STA	JPTR+1
	LDA	DOERASE.LOW,Y
 	STA	SPRKILL.LOW,X
 	LDA	DOERASE.HIGH,Y
	STA	SPRKILL.HIGH,X
	LDX	SPRNUM
	LDY	#0
	JMP	(JPTR)	; Call the specific plot routine
 
 
; Erase software sprite X
; -----------------------
; Preserves X
; ptr1 = address, ptr2 = address of picture, jptr = routine
ERASE_BALL	LDA	STATUS,X
	AND	#ST_DEAD
	BEQ	!NOTDEAD
	LDA	#0
	STA	STATUS,X
!NOTDEAD	LDA	SPRPOS.LOW,X
	STA	PTR1
	STA	PTR2
	LDA	SPRPOS.HIGH,X
 	STA	PTR1+1
	SEC
 	SBC	#(BITMAP-PICCY)/256
 	STA	PTR2+1
	LDA	SPRKILL.LOW,X
 	STA	JPTR
	LDA	SPRKILL.HIGH,X
	STA	JPTR+1
	LDY	#0
	JMP	(JPTR)

NOERASE	RTS

 
 
; ===============
; Adding routines
; ===============

 
; Add 320 to ptr1 and ptr2 (assuming they are bitmap-piccy apart)
; This macro is used by the harpoon plot routine
ADD320.A	MACRO
 	LDA	PTR2
	CLC
 	ADC	#<320
 	STA	PTR2
	STA	PTR1
	LDA	PTR2+1
	ADC	#>320
 	STA	PTR2+1
	ADC	#>(BITMAP-PICCY)
	STA	PTR1+1
	ENDM

; Add 312 to ptr1 and ptr2 (assuming they are bitmap-piccy apart)
; This macro is used by the erase routines
ADD312.A	MACRO
 	LDA	PTR2
	CLC
 	ADC	#<312
 	STA	PTR2
	STA	PTR1
	LDA	PTR2+1
	ADC	#>312
 	STA	PTR2+1
	ADC	#>(BITMAP-PICCY)
	STA	PTR1+1
	ENDM

; Add 312 to ptr1 only
; This macro is used by the plot routines
ADD312.B	MACRO
 	LDA	PTR1
	CLC
 	ADC	#<312
 	STA	PTR1
	LDA	PTR1+1
	ADC	#>312
 	STA	PTR1+1
	ENDM

 
 
; =====================
; Ball erasing routines
; =====================

 
; Macro for 1 byte wide screen refreshes
DOERASE0	MACRO
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	INY
 	IF	@1=3
 	ADD312.A
	ENDIF
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	INY
 	IF	@1=2
 	ADD312.A
	ENDIF
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	INY
 	IF	@1=1
 	ADD312.A
	ENDIF
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	RTS
 	ENDM

 
; Macro for 2 byte wide screen refreshes
DOERASE2	MACRO
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	LDY	#8
	LDA	(PTR2),Y
	STA	(PTR1),Y
	IF	@1=3
 	ADD312.A
	ENDIF
 	LDY	#1
	LDA	(PTR2),Y
	STA	(PTR1),Y
	LDY	#9
	LDA	(PTR2),Y
	STA	(PTR1),Y
	IF	@1=2
 	ADD312.A
	ENDIF
 	LDY	#2
	LDA	(PTR2),Y
	STA	(PTR1),Y
	LDY	#10
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	IF	@1=1
 	ADD312.A
	ENDIF
 	LDY	#3
	LDA	(PTR2),Y
	STA	(PTR1),Y
	LDY	#11
 	LDA	(PTR2),Y
	STA	(PTR1),Y
	RTS
 	ENDM

 
 
; Actual routines for erasing balls
DOERASE00	DOERASE0 0
DOERASE01	DOERASE0 1
DOERASE02	DOERASE0 2
DOERASE03	DOERASE0 3
DOERASE20	DOERASE2 0
DOERASE21	DOERASE2 1
DOERASE22	DOERASE2 2
DOERASE23	DOERASE2 3
 
 
; ======================
; Ball plotting routines
; ======================



; Macro for 1 byte wide screen refreshes
DOPLOT0	MACRO
	LDA	(PTR1),Y
	AND	#@2
 	STA	(PTR1),Y
	INY
 	IF	@1=3
 	ADD312.B
	ENDIF
 	LDA	(PTR1),Y
	AND	#@3
 	STA	(PTR1),Y
	INY
 	IF	@1=2
 	ADD312.B
	ENDIF
 	LDA	(PTR1),Y
	AND	#@4
 	STA	(PTR1),Y
	INY
 	IF	@1=1
 	ADD312.B
	ENDIF
 	LDA	(PTR1),Y
	AND	#@5
 	STA	(PTR1),Y
	RTS
 	ENDM

 
; Macro for 2 byte wide ball plots
DOPLOT2	MACRO
	LDA	(PTR1),Y
	AND	#>@2
	STA	(PTR1),Y
	LDY	#8
	LDA	(PTR1),Y
	AND	#<@2
	STA	(PTR1),Y
	IF	@1=3
 	ADD312.B
	ENDIF
 	LDY	#1
	LDA	(PTR1),Y
	AND	#>@3
	STA	(PTR1),Y
	LDY	#9
	LDA	(PTR1),Y
	AND	#<@3
	STA	(PTR1),Y
	IF	@1=2
 	ADD312.B
	ENDIF
 	LDY	#2
	LDA	(PTR1),Y
	AND	#>@4
	STA	(PTR1),Y
	LDY	#10
 	LDA	(PTR1),Y
	AND	#<@4
	STA	(PTR1),Y
	IF	@1=1
 	ADD312.B
	ENDIF
 	LDY	#3
	LDA	(PTR1),Y
	AND	#>@5
	STA	(PTR1),Y
	LDY	#11
 	LDA	(PTR1),Y
	AND	#<@5
	STA	(PTR1),Y
	RTS
 	ENDM

 
 
; Actual routines for plotting balls
; ----------------------------------
DOPLOT00	DOPLOT0 0,SH00,SH01,SH02,SH03
DOPLOT01	DOPLOT0 1,SH00,SH01,SH02,SH03
DOPLOT02	DOPLOT0 2,SH00,SH01,SH02,SH03
DOPLOT03	DOPLOT0 3,SH00,SH01,SH02,SH03
DOPLOT10	DOPLOT0 0,SH10,SH11,SH12,SH13
DOPLOT11	DOPLOT0 1,SH10,SH11,SH12,SH13
DOPLOT12	DOPLOT0 2,SH10,SH11,SH12,SH13
DOPLOT13	DOPLOT0 3,SH10,SH11,SH12,SH13
DOPLOT20	DOPLOT2 0,SH20,SH21,SH22,SH23
DOPLOT21	DOPLOT2 1,SH20,SH21,SH22,SH23
DOPLOT22	DOPLOT2 2,SH20,SH21,SH22,SH23
DOPLOT23	DOPLOT2 3,SH20,SH21,SH22,SH23
DOPLOT30	DOPLOT2 0,SH30,SH31,SH32,SH33
DOPLOT31	DOPLOT2 1,SH30,SH31,SH32,SH33
DOPLOT32	DOPLOT2 2,SH30,SH31,SH32,SH33
DOPLOT33	DOPLOT2 3,SH30,SH31,SH32,SH33



; Address of routines to plot a ball
; ----------------------------------
DOPLOT.LOW	DL	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DL	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DL	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DL	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DL	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DL	DOPLOT01, DOPLOT11, DOPLOT21, DOPLOT31
 	DL	DOPLOT02, DOPLOT12, DOPLOT22, DOPLOT32
 	DL	DOPLOT03, DOPLOT13, DOPLOT23, DOPLOT33
 
DOPLOT.HIGH	DH	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
	DH	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DH	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DH	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DH	DOPLOT00, DOPLOT10, DOPLOT20, DOPLOT30
 	DH	DOPLOT01, DOPLOT11, DOPLOT21, DOPLOT31
 	DH	DOPLOT02, DOPLOT12, DOPLOT22, DOPLOT32
 	DH	DOPLOT03, DOPLOT13, DOPLOT23, DOPLOT33
 
 
; Address of routines to erase a ball
; -----------------------------------
DOERASE.LOW	DL	DOERASE00, DOERASE00, DOERASE20, DOERASE20
	DL	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DL	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DL	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DL	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DL	DOERASE01, DOERASE01, DOERASE21, DOERASE21
 	DL	DOERASE02, DOERASE02, DOERASE22, DOERASE22
 	DL	DOERASE03, DOERASE03, DOERASE23, DOERASE23
 
DOERASE.HIGH	DH	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DH	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DH	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DH	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DH	DOERASE00, DOERASE00, DOERASE20, DOERASE20
 	DH	DOERASE01, DOERASE01, DOERASE21, DOERASE21
 	DH	DOERASE02, DOERASE02, DOERASE22, DOERASE22
 	DH	DOERASE03, DOERASE03, DOERASE23, DOERASE23
 
 
; Table of row positions - used for address calculations
; ------------------------------------------------------
ROWS.LOW	DL	BITMAP+320*0, BITMAP+320*1, BITMAP+320*2, BITMAP+320*3
 	DL	BITMAP+320*4, BITMAP+320*5, BITMAP+320*6, BITMAP+320*7
 	DL	BITMAP+320*8, BITMAP+320*9, BITMAP+320*10, BITMAP+320*11
 	DL	BITMAP+320*12, BITMAP+320*13, BITMAP+320*14, BITMAP+320*15
 	DL	BITMAP+320*16, BITMAP+320*17, BITMAP+320*18, BITMAP+320*19
 	DL	BITMAP+320*20, BITMAP+320*21, BITMAP+320*22, BITMAP+320*23
 	DL	BITMAP+320*24, BITMAP, BITMAP, BITMAP
	DL	BITMAP, BITMAP, BITMAP, BITMAP
 
ROWS.HIGH	DH	BITMAP+320*0, BITMAP+320*1, BITMAP+320*2, BITMAP+320*3
	DH	BITMAP+320*4, BITMAP+320*5, BITMAP+320*6, BITMAP+320*7
 	DH	BITMAP+320*8, BITMAP+320*9, BITMAP+320*10, BITMAP+320*11
 	DH	BITMAP+320*12, BITMAP+320*13, BITMAP+320*14, BITMAP+320*15
 	DH	BITMAP+320*16, BITMAP+320*17, BITMAP+320*18, BITMAP+320*19
 	DH	BITMAP+320*20, BITMAP+320*21, BITMAP+320*22, BITMAP+320*23
 	DH	BITMAP+320*24, BITMAP, BITMAP, BITMAP
	DH	BITMAP, BITMAP, BITMAP, BITMAP
 
 
 
; =====================
; Harpoon handling code
; =====================

 
; Erase the straight part of the harpoon
; --------------------------------------
; ptr1 = bitmap, ptr2 = piccy, x -> oldpiccy
ERASE_HARPOON	; Find the mask to use
 	LDY	HARPOON
 	LDA	#0
	STA	WIRE_FLAG,Y
 	LDX	WIRE_X,Y	; Find the bitmap address
	LDA	WIRE_TOP,Y
	TAY
 	CALC_ADDRESS
	STA	TEMP2		; Set Y to bottom 3 bits
 	LDA	PTR1		; Find piccy from bitmap
	STA	PTR2
	LDA	PTR1+1
	SEC
 	SBC	#(BITMAP-PICCY)/256
 	STA	PTR2+1
	; Find out how many to do (count)
 	LDY	HARPOON
 	LDA	WIRE_BOT,Y
	SEC
 	SBC	WIRE_TOP,Y
	STA	COUNT
 	BEQ	!DONE
 	LDX	WIRE_TOP,Y	; X = index into oldpiccy
	LDY	TEMP2
 
 	LDA	HARPOON
 	BNE	!LOOP2
!LOOP1	; Erase a pixel (harpoon 1)
 	LDA	OLDPICCY1,X
 	STA	(PTR1),Y
	STA	(PTR2),Y
	INY
 	CPY	#8
	BNE	!NOTOVER1
 	LDY	#0
	ADD320.A
!NOTOVER1	INX
	DEC	COUNT
 	BNE	!LOOP1
!DONE	RTS

!LOOP2	; Erase a pixel (harpoon 2)
 	LDA	OLDPICCY2,X
 	STA	(PTR1),Y
	STA	(PTR2),Y
	INY
 	CPY	#8
	BNE	!NOTOVER2
 	LDY	#0
	ADD320.A
!NOTOVER2	INX
	DEC	COUNT
 	BNE	!LOOP2
	RTS
 
 
 
 
; Draw a section of the harpoon
; -----------------------------
; ptr1 = bitmap, ptr2 = piccy, x -> oldpiccy
DRAW_HARPOON	; Find the mask to use
	LDY	HARPOON
 	LDA	WIRE_X,Y
	AND	#3
	TAX
 	LDA	PIXBITS2,X
	STA	TEMP
	LDX	WIRE_X,Y	; Find the bitmap address
	LDA	WIRE_TOP,Y
	TAY
 	CALC_ADDRESS
	STA	TEMP2	; (put in y) Set Y to bottom 3 bits
 	LDA	PTR1	; Find piccy from bitmap
 	STA	PTR2
	LDA	PTR1+1
	SEC
 	SBC	#(BITMAP-PICCY)/256
 	STA	PTR2+1
	; Find out how many to do (x)
 	LDY	HARPOON
 	LDA	WIRE_LASTTOP,Y
	SEC
 	SBC	WIRE_TOP,Y
	STA	COUNT
 	BEQ	!DONE
 	LDX	WIRE_TOP,Y
	LDY	TEMP2
 
 	LDA	HARPOON
 	BNE	!LOOP2
!LOOP1	; Plot a pixel (harpoon 1)
	LDA	(PTR1),Y
	AND	TEMP
	STA	(PTR1),Y
	LDA	(PTR2),Y
	STA	OLDPICCY1,X	; Remember data under harpoon
 	AND	TEMP
	STA	(PTR2),Y
	INY
 	CPY	#8
	BNE	!NOTOVER1
 	LDY	#0
	ADD320.A
!NOTOVER1	INX
	DEC	COUNT
 	BNE	!LOOP1
!DONE	RTS

 	; Plot a pixel (harpoon 2)
!LOOP2	LDA	(PTR1),Y
	AND	TEMP
	STA	(PTR1),Y
	LDA	(PTR2),Y
	STA	OLDPICCY2,X	; Remember data under harpoon
 	AND	TEMP
	STA	(PTR2),Y
	INY
 	CPY	#8
	BNE	!NOTOVER2
 	LDY	#0
	ADD320.A
!NOTOVER2	INX
	DEC	COUNT
 	BNE	!LOOP2
	RTS
 
 
; =====================
; Platform drawing code
; =====================

; Draw platform X on the bitmap
; -----------------------------
; Pre - X = index into box table
; Preserves X
; NB this only draws into the virtual bitmap and the collision map
; ptr1 = piccy
DRAW_PLATFORM	; Calculate start position of platform
 	STX	SPRNUM
	LDA	BOX_Y,X
 	TAY
 	LDA	BOX_HEIGHT,X
	STA	COUNT2
!BIGLOOP	STY	TEMP2
 	LDA	BOX_X,X
 	TAX
 	CALC_ADDRESS
	TAY
 	LDA	PTR1+1
	SEC
 	SBC	#(BITMAP-PICCY)/256
 	STA	PTR1+1
	; Calculate width of platform
 	LDX	SPRNUM
	LDA	BOX_WIDTH,X
 	LSR
 	LSR
 	STA	COUNT
!LOOP	; Plot line into bitmap
	LDA	#0
	STA	(PTR1),Y
	TYA
 	CLC
 	ADC	#8
	TAY
 	DEC	COUNT
 	BNE	!LOOP
 	; Continue to next line
 	LDY	TEMP2
 	INY
 	DEC	COUNT2
	BNE	!BIGLOOP	
 
 	; Draw platform into collision map
	LDA	BOX_Y,X
 	LSR
 	LSR
 	LSR
 	TAY
 	LDA	COLLIS.LOW,Y
	STA	PTR1
	LDA	COLLIS.HIGH,Y
 	STA	PTR1+1
	LDA	BOX_WIDTH,X
 	LSR
 	LSR
 	STA	COUNT
 	LDA	BOX_X,X
 	LSR
 	LSR
 	TAY
 	DEY
 	LDA	(PTR1),Y
	ORA	#240
	STA	(PTR1),Y
	INY
!MAPLOOP	LDA	(PTR1),Y
	ORA	#15
 	STA	(PTR1),Y
	INY
 	DEC	COUNT
 	BNE	!MAPLOOP
	LDA	(PTR1),Y
	ORA	#240
	STA	(PTR1),Y
	RTS
 
 
 
; Macro for smearing map
; ----------------------
SMEAR	MACRO
	LDY	#@1
 	LDA	(PTR1),Y
	AND	#@2
 	BEQ	!NOSM
 	LDY	#0
	LDA	(PTR1),Y
	ORA	#@3
 	STA	(PTR1),Y
!NOSM
	ENDM

 		
; Smears the collision detection map for larger balls
; ---------------------------------------------------
SMEAR_MAP	XY	COLLIS
	STXY	PTR1
!LOOP	; Smear ycollis
	SMEAR	1, 1, 6		; Medium balls
 	SMEAR	SM+1, 1, 6
	SMEAR	SM, 1, 6
	SMEAR	2, 1, 4 	; Large balls
	SMEAR	SM+2, 1, 4
	SMEAR	SM+SM+2, 1, 4
 	SMEAR	SM+SM+1, 1, 4
 	SMEAR	SM+SM, 1, 4
 	; Smear xcollis
 	SMEAR	1, 16, 96		; Medium balls
 	SMEAR	SM+1, 16, 96
	SMEAR	SM, 16, 96
	SMEAR	2, 16, 64 	; Large balls
	SMEAR	SM+2, 16, 64
	SMEAR	SM+SM+2, 16, 64
 	SMEAR	SM+SM+1, 16, 64
 	SMEAR	SM+SM, 16, 64
 	; Continue
	INC	PTR1
	BNE	!NOW
	INC	PTR1+1
!NOW	LDA	PTR1
	CMP	#<(COLLIS+SM*25)
	BEQ	!OUT1
 	JMP	!LOOP
!OUT1	LDA	PTR1+1
 	CMP	#>(COLLIS+SM*25)
	BEQ	!OUT2
 	JMP	!LOOP
!OUT2	RTS

 	

; Draw ladder X on the bitmap
; ---------------------------
; Pre - X = index into ladder table
; Preserves X
; NB this only draws into the virtual bitmap
; ptr1 = piccy
DRAW_LADDER	; Calculate start position of platform
 	STX	SPRNUM
	LDA	LADDER_Y,X
	TAY
 	LDA	LADDER_HEIGHT,X
 	STA	COUNT2
!BIGLOOP	STY	TEMP2
 	LDA	LADDER_X,X
	TAX
 	CALC_ADDRESS
	TAY
 	LDA	PTR1+1
	SEC
 	SBC	#(BITMAP-PICCY)/256
 	STA	PTR1+1
	; Plot line into bitmap
 	LDA	COUNT2
	AND	#7
	TAX
 	LDA	(PTR1),Y
	AND	LADDERLEFT,X
	STA	(PTR1),Y
	TYA
 	CLC
 	ADC	#8
	TAY
 	LDA	(PTR1),Y
	AND	LADDERRIGHT,X
 	STA	(PTR1),Y
	; Continue to next line
 	LDX	SPRNUM
	LDY	TEMP2
 	INY
 	DEC	COUNT2
	BNE	!BIGLOOP	
 	RTS
 
 
; Definition of shape of ladder
; -----------------------------
LADDERLEFT	DB	%00111111
	DB	%00111111
	DB	%00000000
	DB	%00000000
	DB	%00111111
	DB	%00111111
	DB	%00111111
	DB	%00111111

 
LADDERRIGHT	DB	%11111100
 	DB	%11111100
	DB	%00000000
	DB	%00000000
	DB	%11111100
	DB	%11111100
	DB	%11111100
	DB	%11111100

 
; ========================
; Sprite printing routines
; ========================


; Print the standard text in the sprites
; --------------------------------------
SPRINTER	LDY	#0
	LDX	#0
!LOOP	LDA	BOTLINE1,X
 	BEQ	!ENDLOOP
	JSR	SPRINT_CHAR
 	INX
 	BNE	!LOOP
!ENDLOOP	LDX	#24
 	LDY	#21-8
!LOOP2	LDA	TOPLINE2-24,X
 	BEQ	!ENDLOOP2
 	JSR	SPRINT_CHAR
 	INX
 	BNE	!LOOP2
!ENDLOOP2	LDY	#9
 	LDX	#0
!LOOP3	LDA	BOTLINE2,X
	BEQ	!ENDLOOP3
 	JSR	SPRINT_CHAR
 	INX
 	BNE	!LOOP3
!ENDLOOP3	LDX	#24
	LDY	#21-17
!LOOP4	LDA	TOPLINE1-24,X
 	BEQ	!ENDLOOP4
 	JSR	SPRINT_CHAR
 	INX
 	BNE	!LOOP4
!ENDLOOP4	RTS

 
; Clear bitmapped sprites
; -----------------------
CLR_SPRITES	LDX	#128
 	LDA	#0
!LOOP	STA	BITSPR,X
 	STA	BITSPR+128,X
	STA	BITSPR+128*2,X
	STA	BITSPR+128*3,X
	STA	BITSPR+128*4,X
	STA	BITSPR+128*5,X
	STA	BITSPR+128*6,X
	STA	BITSPR+128*7,X
	DEX
 	BPL	!LOOP
 	RTS
 
 
; Line to plot in sprites
; -----------------------
TOPLINE1	DB "--------------------", 0
TOPLINE2	DB "** Emerald Temple **", 0
BOTLINE1	DB "Player 1....Player 2", 0
BOTLINE2	DB "Pang C64 - Demo V1.0", 0

 
; Print an ASCII character into a sprite
; --------------------------------------
; Pre - A = character, X = xpos (0..19), Y = ypos (0..21)
; Preserves A, X, Y
; Ptr1 = sprite, ptr2 = charset
SPRINT_CHAR	; Find sprite to use
 	PHA
 	STY	TEMP
	LDA	PRINTSPR.LOW,X
	STA	PTR1
	LDA	PRINTSPR.HIGH,X
 	STA	PTR1+1
	TYA
 	ASL
 	ADC	TEMP
	ADC	PTR1
	STA	PTR1
	; Find character to use
 	LDA	#0
	STA	PTR2+1
	PLA
 	PHA
 	SEC		; Translate to char number
 	SBC	#32
 	ASL
 	ROL	PTR2+1
	ASL
 	ROL	PTR2+1
	ASL
 	ROL	PTR2+1
	STA	PTR2
	LDA	PTR2+1
	CLC
 	ADC	#CHARSET/256
	STA	PTR2+1
	; Copy data
 	LDY	#0
!LOOP	LDA	(PTR2),Y
 	STA	(PTR1),Y
	INC	PTR1
	INC	PTR1
	INY
 	CPY	#8
	BNE	!LOOP
 	; Restore registers
 	PLA
 	LDY	TEMP
	RTS
 
 
 
; Table of sprite positions
; -------------------------
PRINTSPR.LOW	DL	BITSPR, BITSPR+1, BITSPR+2
 	DL	BITSPR+64, BITSPR+1+64, BITSPR+2+64
	DL	BITSPR+64*2, BITSPR+1+64*2, BITSPR+2+64*2
	DL	BITSPR+64*3, BITSPR+1+64*3, BITSPR+2+64*3
	DL	BITSPR+64*4, BITSPR+1+64*4, BITSPR+2+64*4
	DL	BITSPR+64*5, BITSPR+1+64*5, BITSPR+2+64*5
	DL	BITSPR+64*6, BITSPR+1+64*6, BITSPR+2+64*6
	DL	BITSPR+64*7, BITSPR+1+64*7, BITSPR+2+64*7
	DL	BITSPR+64*8, BITSPR+1+64*8, BITSPR+2+64*8
	DL	BITSPR+64*9, BITSPR+1+64*9, BITSPR+2+64*9
	DL	BITSPR+64*10, BITSPR+1+64*10, BITSPR+2+64*10
 	DL	BITSPR+64*11, BITSPR+1+64*11, BITSPR+2+64*11
 	DL	BITSPR+64*12, BITSPR+1+64*12, BITSPR+2+64*12
 	DL	BITSPR+64*13, BITSPR+1+64*13, BITSPR+2+64*13
 	DL	BITSPR+64*14, BITSPR+1+64*14, BITSPR+2+64*14
 	DL	BITSPR+64*15, BITSPR+1+64*15, BITSPR+2+64*15
 
PRINTSPR.HIGH	DH	BITSPR, BITSPR+1, BITSPR+2
	DH	BITSPR+64, BITSPR+1+64, BITSPR+2+64
	DH	BITSPR+64*2, BITSPR+1+64*2, BITSPR+2+64*2
	DH	BITSPR+64*3, BITSPR+1+64*3, BITSPR+2+64*3
	DH	BITSPR+64*4, BITSPR+1+64*4, BITSPR+2+64*4
	DH	BITSPR+64*5, BITSPR+1+64*5, BITSPR+2+64*5
	DH	BITSPR+64*6, BITSPR+1+64*6, BITSPR+2+64*6
	DH	BITSPR+64*7, BITSPR+1+64*7, BITSPR+2+64*7
	DH	BITSPR+64*8, BITSPR+1+64*8, BITSPR+2+64*8
	DH	BITSPR+64*9, BITSPR+1+64*9, BITSPR+2+64*9
	DH	BITSPR+64*10, BITSPR+1+64*10, BITSPR+2+64*10
 	DH	BITSPR+64*11, BITSPR+1+64*11, BITSPR+2+64*11
 	DH	BITSPR+64*12, BITSPR+1+64*12, BITSPR+2+64*12
 	DH	BITSPR+64*13, BITSPR+1+64*13, BITSPR+2+64*13
 	DH	BITSPR+64*14, BITSPR+1+64*14, BITSPR+2+64*14
 	DH	BITSPR+64*15, BITSPR+1+64*15, BITSPR+2+64*15
 
