;       File  "---- PANG - C64 ---"
;    Version          00.45        
;         By  "--- CARL MULLER ---"
;    
;     Created on Tue the 07th of Aug 1990  
;        Last update 15:18 on 03/09/90 
; 
 
; ========================
; Front end code and music
; and sound effects
; ========================
 
 
HISCORE	JSR	SETUP_SCREEN
 
; Setup up the screen in custom character mode
; --------------------------------------------
; Assumes screen is turned off at beginning
SETUP_SCREEN	; Setup screen
	CLEAR_BLOCK SCREEN, SCREEN+1000, 0
	CLEAR_BLOCK COLOUR, COLOUR+1000, CYAN
 	JSR	WAIT_VB
 	; Set up VIC chip to display screen
 	LDX	#VIC_INIT2.END-VIC_INIT2-1
!LOOP	LDA	VIC_INIT2,X
	STA	VIC,X
 	DEX
 	BPL	!LOOP
 
 	; Setup print variables
 	LDA	#0
	STA	PRINTX
	STA	PRINTY
	STA	WINDOW_X1
 	STA	WINDOW_Y1
 	LDA	#40
 	STA	WINDOW_X2
 	LDA	#25
 	STA	WINDOW_Y2
 	LDA	#CYAN
 	STA	PRINTCOLOUR
 	RTS
 
 
; Print a text string on the screen
; ---------------------------------
; Pre - XY points to text string
PRINT_STRING	STXY	PTR1
!LOOP	LDY	#0
 	LDA	(PTR1),Y
	BEQ	!END
	JSR	PRINT_CHAR
	INC	PTR1
	BNE	!NOINC
	INC	PTR1+1
!NOINC	JMP	!LOOP
!END	RTS
 
 
 
; Print a character on the screen
; -------------------------------
; Pre - A = ASCII value
; Side - destroys A
PRINT_CHAR	CMP	#32
 	BCC	!NOTDISPLAY
 	CMP	#128
	BCS	!NOTDISPLAY
 	; It's a displayable character
	PHA
 	; Calculate display position
	JSR	CALC_PRINTPTR
 	PLA
 	SEC
 	SBC	#32
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	; Update pointers
 	JMP	!RIGHT

!NOTDISPLAY	; See if it's a cursor control character
 	; Handle home command
 	CMP	#HOME
 	BNE	!NOTHOME
	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	RTS
 
!NOTHOME	; Handle clear command
	CMP	#CLR
	BNE	!NOTCLEAR
 	JMP	CLRSCREEN
 
!NOTCLEAR	; Handle carriage return
 	CMP	#CR
 	BNE	!NOTCR
	LDA	WINDOW_X1
 	STA	PRINTX
	JMP	!DOWN
 
!NOTCR	; Handle command to go left
 	CMP	#CRSR_LEFT
	BNE	!NOTLEFT
	LDA	PRINTX
	CMP	WINDOW_X1
 	BNE	!NOW1		; Not at beginning of line
 	LDA	PRINTY
	CMP	WINDOW_Y1
 	BEQ	!NOW1A		; At beginning of window
	DEC	PRINTY
	LDA	WINDOW_X2
 	STA	PRINTX		; Wrap around line
!NOW1	DEC	PRINTX
!NOW1A	RTS
 
!NOTLEFT	; Handle command to go right
	CMP	#CRSR_RIGHT
 	BNE	!NOTRIGHT
!RIGHT	INC	PRINTX
	LDA	PRINTX
	CMP	WINDOW_X2
 	BNE	!NOW2
 	LDA	WINDOW_X1
 	STA	PRINTX
	JMP	!DOWN
!NOW2	RTS

!NOTRIGHT	; Handle command to go down
	CMP	#CRSR_DOWN
	BNE	!NOTDOWN
!DOWN	INC	PRINTY
 	LDA	PRINTY
	CMP	WINDOW_Y2
 	BNE	!NOW3
 	JMP	SCROLLUP
!NOW3	RTS

!NOTDOWN	; Handle command to go up
 	CMP	#CRSR_UP
	BNE	!NOTUP
	LDA	PRINTY
	CMP	WINDOW_Y1
 	BEQ	!NOW4
 	DEC	PRINTY
!NOW4	RTS

!NOTUP	; Handle insert command
 	CMP	#INSERT
 	BNE	!NOTINS
 	JMP	INSERT_SPACE

!NOTINS	; Handle delete command
	CMP	#DEL
	BNE	!NOTDEL
 	JMP	DELETE_SPACE

!NOTDEL	; See if it is a colour command
	LDX	#15
!COLLOOP	CMP	COLOURCODES,X
 	BNE	!NOTCOL
 	STX	PRINTCOLOUR
!NOTCOL	DEX
	BPL	!COLLOOP
	RTS
 
 
; Table of colour codes used in print routines
; -------------------------------------------- 
COLOURCODES	DB	CTRL_BLACK, CTRL_WHITE, CTRL_RED, CTRL_CYAN
 	DB	CTRL_PURPLE, CTRL_GREEN, CTRL_BLUE, CTRL_YELLOW
	DB	CTRL_ORANGE, CTRL_BROWN, CTRL_PINK, CTRL_DKGREY
	DB	CTRL_MDGREY, CTRL_LTGREEN, CTRL_LTBLUE, CTRL_LTGREY 
 
 
; Clear the window
; ----------------
CLRSCREEN	LDX	WINDOW_Y1
	LDA	SCREENROWS.LOW,X
	STA	PRINTPTR
	STA	PRINTPTR2
 	LDA	SCREENROWS.HIGH,X
 	STA	PRINTPTR+1
	CLC
 	ADC	#(COLOUR-SCREEN)/256
	STA	PRINTPTR2+1
!BIGLOOP	LDY	WINDOW_X1
!LOOP	LDA	#0
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	INY
 	CPY	WINDOW_X2
 	BNE	!LOOP
 	LDA	PRINTPTR
	CLC
 	ADC	#40
 	STA	PRINTPTR
	STA	PRINTPTR2
 	BCC	!NOINC
	INC	PRINTPTR+1
	INC	PRINTPTR2+1
!NOINC	INX
 	CPX	WINDOW_Y2
 	BNE	!BIGLOOP
	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	RTS
 
 
 
; Scroll the window up a line
; ---------------------------
SCROLLUP	LDX	WINDOW_Y1
 	INX
!BIGLOOP	DEX
 	LDA	SCREENROWS.LOW,X
	STA	PRINTPTR
	CLC
 	ADC	#40
 	STA	PRINTPTR2
 	LDA	SCREENROWS.HIGH,X
 	STA	PRINTPTR+1
	ADC	#0
	STA	PRINTPTR2+1
 	; Scroll a line of text
 	LDY	WINDOW_X1
!LOOP	LDA	(PRINTPTR2),Y
	STA	(PRINTPTR),Y
	INY
 	CPY	WINDOW_X2
 	BNE	!LOOP
 
 	; Scroll a line of colour
 	LDA	PRINTPTR+1
	CLC
 	ADC	#(COLOUR-SCREEN)/256
	STA	PRINTPTR+1
	LDA	PRINTPTR2+1
 	CLC
 	ADC	#(COLOUR-SCREEN)/256
	STA	PRINTPTR2+1
 	LDY	WINDOW_X1
!LOOP2	LDA	(PRINTPTR2),Y
 	STA	(PRINTPTR),Y
	INY
 	CPY	WINDOW_X2
 	BNE	!LOOP2

 	INX
 	INX
 	CPX	WINDOW_Y2
 	BNE	!BIGLOOP

 	; Set new line at bottom to spaces
	LDA	PRINTPTR
	CLC
 	ADC	#<(COLOUR-SCREEN+40)
	STA	PRINTPTR
	LDA	PRINTPTR+1
	ADC	#>(COLOUR-SCREEN+40)
	STA	PRINTPTR+1
	LDY	WINDOW_X1
!LOOP3	LDA	#0
	STA	(PRINTPTR2),Y
 	LDA	PRINTCOLOUR
 	STA	(PRINTPTR),Y
	INY
 	CPY	WINDOW_X2
 	BNE	!LOOP3
	; Fix up next print position	
 	LDA	PRINTY
	BEQ	!NOWRAP
 	DEC	PRINTY
!NOWRAP	RTS

 
; Calculate the print pointers
; ----------------------------
; Pre - printx and printy are valid
; Post - printptr+y = screen, printptr2+y = colour
CALC_PRINTPTR	LDX	PRINTY
 	LDA	SCREENROWS.LOW,X
	STA	PRINTPTR
	STA	PRINTPTR2
 	LDA	SCREENROWS.HIGH,X
 	STA	PRINTPTR+1
	CLC
 	ADC	#(COLOUR-SCREEN)/256
	STA	PRINTPTR2+1
 	LDY	PRINTX
	RTS
 
 
; Insert a space in the window
; ----------------------------
INSERT_SPACE	JSR	CALC_PRINTPTR
 	LDY	WINDOW_X2
!LOOP	DEY
	CPY	PRINTX
	BEQ	!EDGE
 	DEY
 	LDA	(PRINTPTR2),Y
 	TAX
 	LDA	(PRINTPTR),Y
	INY
 	STA	(PRINTPTR),Y
	TXA
 	STA	(PRINTPTR2),Y
 	JMP	!LOOP
!EDGE	LDA	#0
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	RTS
 
 
; Delete a space from the window
; ------------------------------
DELETE_SPACE	LDA	PRINTX
	CMP	WINDOW_X1
 	BEQ	!END
	DEC	PRINTX
	DEC	PRINTX
	JSR	CALC_PRINTPTR
!LOOP	INY
	CPY	WINDOW_X2
 	BEQ	!EDGE
 	INY
 	LDA	(PRINTPTR2),Y
 	TAX
 	LDA	(PRINTPTR),Y
	DEY
 	STA	(PRINTPTR),Y
	TXA
 	STA	(PRINTPTR2),Y
 	JMP	!LOOP
!EDGE	INC	PRINTX
 	DEY
 	LDA	#0
	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
!END	RTS
 
 
; Set up standard IRQ
; -------------------
SETUP_STD	SEI
	XY	STDIRQ
 	STXY	VECTOR_IRQ
 	LDA	#0
	STA	RASTER.LOW
	LDA	#1
	STA	RASTER_ENABLE
 	CLI
 	RTS
 
 
; Standard IRQ interrupt
; ----------------------
STDIRQ	; Preserve registers
	STA	IRQ.A
 	STX	IRQ.X
 	STY	IRQ.Y
 	; Acknowledge interrupt
 	LDA	RASTER_FLAG
 	STA	RASTER_FLAG
 	; Process interrupt
 	INC	FRAME
 	JSR	READ_JOY
	JSR	SCAN_KEYS
 	; Restore registers
 	LDA	IRQ.A
 	LDX	IRQ.X
 	LDY	IRQ.Y
 	RTI
 
 
; Input a line of text from the keyboard
; --------------------------------------
INPUT	JSR	INIT_KEYS
	JSR	SETUP_STD
 	SEC
 	JSR	CURSOR_SET
!LOOP	; Main input loop
	JSR	WAIT_SYNC
 	JSR	FLASH_CURSOR
	JSR	READ_KEY
	CMP	#0
	BEQ	!LOOP
 	; Handle key presses
	CMP	#"_"	; commodore <- arrow = quit character
	BEQ	!END
	PHA
 	CLC
 	JSR	CURSOR_SET
	PLA
 	JSR	PRINT_CHAR
	SEC
 	JSR	CURSOR_SET
	JMP	!LOOP
!END	CLC
 	JSR	CURSOR_SET
	RTS
 
 
 
 
; Print the cursor
; ----------------
; Pre - carry clear to clear cursor, set to plot cursor
CURSOR_SET	; Set up counter to next flash
	PHP
 	LDA	#20
 	STA	CURSORCOUNT
 	LDX	PRINTY
	LDA	SCREENROWS.LOW,X
	STA	PRINTPTR
	STA	PRINTPTR2
 	LDA	SCREENROWS.HIGH,X
 	STA	PRINTPTR+1
	CLC
 	ADC	#(COLOUR-SCREEN)/256
	STA	PRINTPTR2+1
 	LDY	PRINTX

 	PLP
 	BCC	!CLRCURSOR
	; Set the cursor
	LDA	(PRINTPTR),Y
	STA	CURSORCHAR
	LDA	(PRINTPTR2),Y
 	STA	CURSORCOLOUR
	LDA	#"*"-32
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	LDA	#1
	STA	CURSORSTATE
 	RTS
 
!CLRCURSOR	LDA	CURSORCHAR
	STA	(PRINTPTR),Y
	LDA	CURSORCOLOUR
	STA	(PRINTPTR2),Y
 	LDA	#0
	STA	CURSORSTATE
!END	RTS
 
 
; Flash the cursor (call once a frame)
; ------------------------------------
FLASH_CURSOR	LDA	CURSORCOUNT
 	BEQ	!FLASH
	DEC	CURSORCOUNT
 	RTS
!FLASH	LDA	CURSORSTATE
 	EOR	#1
	ROR
 	JMP	CURSOR_SET

 
; Draw a line on the character screen
; -----------------------------------
; Pre - PRINTX, PRINTY, PRINTCOLOUR set up
;       X = size of line to draw
VERT_LINE	TXA
	BEQ	!END
	CLC
 	ADC	PRINTY
	BCS	!OVER
 	CMP	WINDOW_Y2
 	BCC	!NOTOVER
!OVER	LDA	WINDOW_Y2
!NOTOVER	STA	COUNT2		; Count2 = final position
 	DEC	COUNT2
	LDA	PRINTY
	STA	COUNT		; Count = first position
 
!LOOP	; Calculate bits to OR on screen
 	LDA	#0
	LDX	PRINTY
	CPX	COUNT
 	BEQ	!FIRST
	ORA	#1
!FIRST	CPX	COUNT2
	BEQ	!LAST
 	ORA	#2
!LAST	STA	TEMP		; Temp = bits to OR on screen
	; Calculate pointers to screen
	JSR	CALC_PRINTPTR
 	LDA	(PRINTPTR),Y
	CMP	#LINECHAR
 	BCS	!ISLINE
 	LDA	#LINECHAR
!ISLINE	ORA	TEMP
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	LDA	PRINTY
	CMP	COUNT2
	BEQ	!END
	INC	PRINTY
	JMP	!LOOP
!END	RTS
 
 
 
; Draw a line on the character screen
; -----------------------------------
; Pre - PRINTX, PRINTY, PRINTCOLOUR set up
;       X = size of line to draw
HORIZ_LINE	TXA
 	BEQ	!END
	CLC
 	ADC	PRINTX
	BCS	!OVER
 	CMP	WINDOW_X2
 	BCC	!NOTOVER
!OVER	LDA	WINDOW_X2
!NOTOVER	STA	COUNT2		; Count2 = final position
 	DEC	COUNT2
	LDA	PRINTX
	STA	COUNT		; Count = first position
!LOOP	; Calculate bits to OR on screen
 	LDA	#0
	LDX	PRINTX
	CPX	COUNT
 	BEQ	!FIRST
	ORA	#4
!FIRST	CPX	COUNT2
	BEQ	!LAST
 	ORA	#8
!LAST	STA	TEMP		; Temp = bits to OR on screen
	; Calculate pointers to screen
	JSR	CALC_PRINTPTR
 	LDA	(PRINTPTR),Y
	CMP	#LINECHAR
 	BCS	!ISLINE
 	LDA	#LINECHAR
!ISLINE	ORA	TEMP
 	STA	(PRINTPTR),Y
	LDA	PRINTCOLOUR
 	STA	(PRINTPTR2),Y
 	LDA	PRINTX
	CMP	COUNT2
	BEQ	!END
	INC	PRINTX
	JMP	!LOOP
!END	RTS
 
 
 
; Draw a box around the current window and shrink the window
; ----------------------------------------------------------
BOX_WINDOW	; Draw line at left of window
 	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	LDX	#255		; Maximum sized line
	JSR	VERT_LINE
 	; Draw line at right of window
	LDA	WINDOW_X2
 	STA	PRINTX
	DEC	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	LDX	#255
	JSR	VERT_LINE
 	; Draw line at top of window
	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	LDX	#255
	JSR	HORIZ_LINE
	; Draw line at bottom of window
 	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y2
 	STA	PRINTY
	DEC	PRINTY
	LDX	#255
	JSR	HORIZ_LINE
	; Shrink window - assumes it is big enough
	INC	WINDOW_X1
 	INC	WINDOW_Y1
 	DEC	WINDOW_X2
 	DEC	WINDOW_Y2
 	LDA	WINDOW_X1
 	STA	PRINTX
	LDA	WINDOW_Y1
 	STA	PRINTY
	RTS
 
 
 
; Display the specified window
; ----------------------------
; Pre - X = window to display (0..7)
; Preserves X
PRINT_WINDOW	TXA
 	PHA
 	ASL
 	TAY
 	LDA	WINDOWPTRS,Y
	STA	PTR1
	LDA	WINDOWPTRS+1,Y
	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y	; Colour of window
 	STA	PRINTCOLOUR
 	INY
 	LDA	(PTR1),Y	; Start X
	STA	WINDOW_X1
 	INY
 	LDA	(PTR1),Y	; Start Y
	STA	WINDOW_Y1
 	INY
 	LDA	(PTR1),Y	; Width
	CLC
 	ADC	WINDOW_X1
 	STA	WINDOW_X2
 	INY
 	LDA	(PTR1),Y	; Height
 	CLC
 	ADC	WINDOW_Y1
 	STA	WINDOW_Y2
 	JSR	BOX_WINDOW	; Put a box around the window
	; Print text message stored in window
!LOOP	LDY	#5
 	LDA	(PTR1),Y
	BEQ	!END
	JSR	PRINT_CHAR
	INC	PTR1
	BNE	!LOOP
 	INC	PTR1+1
	BNE	!LOOP
!END	PLA
 	TAX
 	RTS
 
 
 
; Pointers to window information
; ------------------------------
WINDOWPTRS	DW	WIND0, WIND1, WIND2, WIND3
 
 
; Window 1  - title
; -----------------------
WIND0
WIND1	DB	YELLOW, 12, 0, 16, 3
	DB	CTRL_WHITE, "  Pang - C64"	
	DB	0

 
; Window 2 - information
; ----------------------
WIND2	DB	YELLOW, 0, 2, 40, 4
 	DB	CTRL_CYAN, "Written by Carl Muller", CR
	DB	CTRL_PINK, "Demonstration version 1.2", CR
 	DB	CTRL_GREEN, "Press the <- key to play again."
	DB	0

; Window 3 - input window
; -----------------------
WIND3	DB	WHITE, 0, 12, 40, 13
	DB	CTRL_LTGREEN, 0

 
; Initialise star positions
; -------------------------
INIT_STARS	LDX	#NUM_OBJS-1
 	LDA	#0
!LOOP	STA	STATUS,X
 	DEX
 	BPL	!LOOP
 	RTS
 
 
 
; ===============
; Fading routines
; ===============

 
 
 
; Fade the bitmap picture out to black
; ------------------------------------
; Ptr1 = screen, ptr2 = colour
FADE_OUT	; Setup translation table
 	LDY	#0
!SETUP	TYA
 	AND	#15
 	TAX
 	LDA	FADEOUT,X
 	STA	TEMP
	TYA
 	LSR
 	LSR
 	LSR
 	LSR
 	TAX
 	LDA	FADEOUT,X
 	ASL
 	ASL
 	ASL
 	ASL
 	ORA	TEMP
	STA	FADEBUFFER,Y
	INY
 	BNE	!SETUP

 	; Setup loop
	LDA	#16
 	STA	COUNT
!BIGLOOP	; Fade out the bitmap by one level
	JSR	WAIT_VB
 	; Fade out the background colour etc
	LDX	#SPR7_COL-BORDER_COL
!LOOPBACK	LDY	BORDER_COL,X
 	LDA	FADEBUFFER,Y
	STA	BORDER_COL,X
	DEX
 	BPL	!LOOPBACK
 
 	; Fade out the colour RAM
 	LDY	#0
!LOOP1	
;	DO 4
 	  LDX	COLOUR,Y
	  LDA	FADEBUFFER,X
	  STA	COLOUR,Y
	  INY
 ;	LOOP
 	BNE	!LOOP1

!LOOP2	
;	DO 4
 	  LDX	COLOUR+256,Y
	  LDA	FADEBUFFER,X
	  STA	COLOUR+256,Y
	  INY
;	LOOP
 	BNE	!LOOP2
!LOOP3	
;	DO 4
 	  LDX	COLOUR+512,Y
	  LDA	FADEBUFFER,X
	  STA	COLOUR+512,Y
	  INY
;	LOOP
 	BNE	!LOOP3
!LOOP4
;	DO 4
 	  LDX	COLOUR+768,Y
	  LDA	FADEBUFFER,X
	  STA	COLOUR+768,Y
	  INY
;	LOOP
 	BNE	!LOOP4

 	; Check to see if we are in bitmap mode
 	; and hence need to fade out screen ram
 	LDA	VIC_CTRL1
 	AND	#BIT5
 	BNE	!DOIT
 	JMP	!CONT
 
!DOIT	; Fade out screen RAM
	JSR	WAIT_VB
!LOOP5
;	DO 4
 	  LDX	SCREEN,Y
	  LDA	FADEBUFFER,X
	  STA	SCREEN,Y
	  INY
;	LOOP
 	BNE	!LOOP5
!LOOP6
;	DO 4
 	  LDX	SCREEN+256,Y
	  LDA	FADEBUFFER,X
	  STA	SCREEN+256,Y
	  INY
;	LOOP
 	BNE	!LOOP6
!LOOP7
;	DO 4
 	  LDX	SCREEN+512,Y
	  LDA	FADEBUFFER,X
	  STA	SCREEN+512,Y
	  INY
;	LOOP
 	BNE	!LOOP7
!LOOP8	
;	DO 4
 	  LDX	SCREEN+768,Y
	  LDA	FADEBUFFER,X
	  STA	SCREEN+768,Y
	  INY
;	LOOP
 	CPY	#1000-768
 	BNE	!LOOP8

!CONT	; Continue for other fades
 	DEC	COUNT
 	BEQ	!DONE
 	JMP	!BIGLOOP

!DONE	; Complete fade out
	LDA	#0
	STA	VIC_CTRL1
 	RTS
 
 
 
; Colours to cycle through
; ------------------------
FADECOLOURS	DB	BLACK, DKGREY, BROWN, RED
 	DB	BLUE, LTBLUE, PURPLE, PINK
 	DB	ORANGE, MDGREY, GREEN, YELLOW 
 	DB	LTGREY, CYAN, LTGREEN, WHITE
 
 
; Colours to transpose
; --------------------
FADEOUT	DB	BLACK, LTGREEN, BROWN, LTGREY
 	DB	LTBLUE, MDGREY, RED, GREEN
 	DB	PINK, DKGREY, PURPLE, BLACK
	DB	ORANGE, CYAN, BLUE, YELLOW
 	

 
; ====================
; MUSIC PLAYER
; (C) CARL MULLER 1988
; ====================
 
 
 
 
; Variables to reserve
YN	DS	BYTE
MLT	DS	7
MUS	DS	33

 
DO_MUSIC	; Process a frames worth of music
	LDX	#0
	LDY	#0
	JSR	CHANNEL
 	LDX	#11
 	LDY	#7
	JSR	CHANNEL
 	LDX	#22
 	LDY	#14
 	JSR	CHANNEL
 	RTS
 
 
CHANNEL	; Process a single sound channel
 	STY	YN
	LDA	MUS+10,X
	INC	MUS+10,X
	CMP	MUS+9,X
 	BNE	CHAN1
 	JSR	NOTE
	LDA	#0
	STA	MUS+10,X
	LDY	YN
	STA	54276,Y
 	LDA	MUS+2,X
 	ASL
 	ASL
 	ASL
 	ASL
 	ORA	MUS+3,X
 	STA	54277,Y
CHAN1	LDA	MUS+4,X
	ASL
 	TAY
 	LDA	O.VOICE,Y
 	CLC
 	ADC	MUS+10,X
	STA	PTR1
	LDA	O.VOICE+1,Y
 	ADC	#0
	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y
	LDY	YN
	STA	54276,Y
 	LDA	MUS+5,X
 	ASL
 	TAY
 	LDA	O.WIDTH,Y
 	CLC
 	ADC	MUS+10,X
	STA	PTR1
	LDA	O.WIDTH+1,Y
 	ADC	#0
	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y
	LDY	YN
	PHA
 	ASL
 	ASL
 	ASL
 	ASL
 	STA	54274,Y
 	PLA
 	LSR
 	LSR
 	LSR
 	LSR
 	STA	54275,Y
 	LDA	MUS+6,X
 	ASL
 	TAY
 	LDA	O.FREQ,Y
	CLC
 	ADC	MUS+10,X
	STA	PTR1
	LDA	O.FREQ+1,Y
	ADC	#0
	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y
	STA	MLT
 	LDA	MUS+7,X
 	STA	MLT+1
 	LDA	MUS+8,X
 	STA	MLT+2
 	JSR	MULT
	LDY	YN
	LDA	MLT+5
 	STA	54272,Y
 	LDA	MLT+6
 	STA	54273,Y
 	RTS
 
 
MULT	; Multiplacation routine
	LDA	#0
	STA	MLT+4
 	STA	MLT+5
 	STA	MLT+6
 	STA	MLT+3
 	BEQ	!MULTX
!MULT2	ASL	MLT+1
 	ROL	MLT+2
 	ROL	MLT+3
!MULTX	LSR	MLT
 	BCC	!MULT1
	LDA	MLT+1
 	CLC
 	ADC	MLT+4
 	STA	MLT+4
 	LDA	MLT+2
 	ADC	MLT+5
 	STA	MLT+5
 	LDA	MLT+3
 	ADC	MLT+6
 	STA	MLT+6
!MULT1	LDA	MLT
 	BNE	!MULT2
	ASL	MLT+4
 	ROL	MLT+5
 	ROL	MLT+6
 	ASL	MLT+4
 	ROL	MLT+5
 	ROL	MLT+6
 	RTS
 
 
 
NOTE	; Score processing routine
	INC	MUS,X
 	BNE	!NOINC
	INC	MUS+1,X
!NOINC	LDA	MUS,X
 	STA	PTR1
	LDA	MUS+1,X
 	STA	PTR1+1
	LDY	#0
	LDA	(PTR1),Y
	PHA
 	LSR
 	LSR
 	LSR
 	LSR
 	CMP	#4
	BCS	!NOTE1
	PLA
 	AND	#63
 	ASL
 	TAY
 	LDA	XNOTE,Y
 	STA	MUS+7,X
 	LDA	XNOTE+1,Y
 	STA	MUS+8,X
 	RTS
!NOTE1
 	CMP	#8
	BCS	!NOTE2
	PLA
 	SEC
 	SBC	#64
 	BNE	!NO2
	LDA	#95
!NO2	STA	MUS+9,X
 	JMP	NOTE
!NOTE2
 	CMP	#8
	BNE	!NOTE3
	PLA
 	AND	#15
 	STA	MUS+2,X
 	JMP	NOTE
!NOTE3
 	CMP	#9
	BNE	!NOTE4
	PLA
 	AND	#15
 	STA	MUS+3,X
 	JMP	NOTE
!NOTE4	CMP	#10
 	BNE	!NOTE5
	PLA
 	AND	#15
 	STA	MUS+4,X
 	JMP	NOTE
!NOTE5	CMP	#11
 	BNE	!NOTE6
	PLA
 	AND	#15
 	STA	MUS+5,X
 	JMP	NOTE
!NOTE6	CMP	#12
 	BNE	!NOTE7
	PLA
 	AND	#15
 	STA	MUS+6,X
 	JMP	NOTE
!NOTE7	CMP	#13
 	BNE	!NOTE8
	PLA
 	AND	#15
 	STA	54296
 	JMP	NOTE
!NOTE8	PLA
 	JSR	START_MUSIC
 	JMP	NOTE

 
; Setup music to play
; -------------------
START_MUSIC
	TXA
 	PHA
 	LDA	#0
	LDX	#32
!LOOP	STA	54272,X
	STA	MUS,X
 	DEX
 	BPL	!LOOP
 	LDA	#3
	STA	54289
 	LDA	#255
	STA	54288
 	LDA	#17
 	STA	54291
 	LDA	#241
	STA	54292
 	LDA	O.SONG
	STA	MUS
 	LDA	O.SONG+1
	STA	MUS+1
 	LDA	O.SONG+2
	STA	MUS+11
	LDA	O.SONG+3
	STA	MUS+12
	LDA	O.SONG+4
	STA	MUS+22
	LDA	O.SONG+5
	STA	MUS+23
	PLA
 	TAX
 	RTS
 
 
; Table of frequencies to use for notes
; -------------------------------------
XNOTE	DW 0,0,1024,1084,1149,1217
 	DW 1290,1366,1448,1534,1625
 	DW 1722,1824,1933,2048,2169
 	DW 2298,2435,2580,2733,2896
 	DW 3068,3250,3444,3649,3866
 	DW 4096,4339,4597,4870,5160
 	DW 5467,5792,6137,6501,6888
 	DW 7298,7732,8192,8679,9195
 	DW 9741,10321,10935,11585
 	DW 12274,13003,13777,14596
	DW 15464,16384,17358,18390
	DW 19483,20642,21870,23170
	DW 24548,26007,27554,29192
	DW 30928,32768,34716,36780,38967

 
; Table of voices to use
; ----------------------
O.FREQ	DW	O.FREQ1, O.FREQ2, O.FREQ3, O.FREQ4
 	DW	O.FREQ5, O.FREQ6, O.FREQ7, O.FREQ8
O.VOICE	DW	O.VOICE1, O.VOICE2, O.VOICE3, O.VOICE4, O.VOICE5
O.WIDTH	DW	O.WIDTH1, O.WIDTH2, O.WIDTH1
O.SONG	DW	O.SONG1, O.SONG2, O.SONG3

 
; Voice definitions
; -----------------
O.VOICE1	; Symbals
 	HEX 81818181818181818181818181818181
	HEX 81818181818181818181818181818181
	HEX 81818181818181818181818181818181
O.VOICE3	; Snare drum
	HEX 81418141814181418141814181418141
	HEX 81418141814181418141814181418141
	HEX 81418141814181418141814181418141
O.VOICE2	; Main synth voice
	HEX 41414141414141414141414141414141
	HEX 41414141414141414141414141414141
	HEX 41414141414141414141414141414141
	HEX 41414141414141414141414141414141
	HEX 41414141414141414141414141414141
	HEX 41414141414141414141414141414141
O.VOICE4	; Harpsichord
 	HEX 21212121212121212121212121212121
	HEX 21212121212121212121212121212121
O.VOICE5	; Pure tone
 	HEX 11111111111111111111111111111111
	HEX 11111111111111111111111111111111

 
; Pulse width definitions
; -----------------------
O.WIDTH1	HEX 2024282C3034383C4044484C5054585C
	HEX 6064686C7074787C807C7874706C6864
	HEX 605C5854504C4844403C3834302C2824
	HEX 2024282C3034383C4044484C5054585C
	HEX 6064686C7074787C807C7874706C6864
	HEX 605C5854504C4844403C3834302C2824

O.WIDTH2	HEX 00020406080A0C0E1012141618191C1E
	HEX 20222426282A2C2E302E2C2A28262422
	HEX 201E1C1A18161412100E0C0A08060402
	HEX 00020406080A0C0E10121416181A1C1E
	HEX 20222426282A2C2E302E2C2A28262422
	HEX 201E1C1A18161412100E0C0A08060402

 
; Frequency sweep definitions
; ---------------------------
O.FREQ1	; Constant frequency
 	HEX 40404040404040404040404040404040
	HEX 40404040404040404040404040404040
	HEX 40404040404040404040404040404040
	HEX 40404040404040404040404040404040
	HEX 40404040404040404040404040404040
	HEX 40404040404040404040404040404040
O.FREQ2	; Warbling frequency
 	HEX 40208040208040208040208040208040
	HEX 20804020804020804020804020804020
	HEX 20804020804020804020804020804020
	HEX 80402080402080402080402080402080
	HEX 80402080402080402080402080402080
	HEX 40208040208040208040208040208040
O.FREQ3	HEX 80808080606060605050505060606060
 	HEX 50505050404040405050505040404040
	HEX 30303030404040404040404040404040
O.FREQ4	HEX 4041403F4041403F4041403F4041403F
 	HEX 4041403F4041403F4041403F4041403F
	HEX 4041403F4041403F4041403F4041403F
O.FREQ5	HEX 40404030303040404050505060606050
 	HEX 50506060605050504040403030304040
	HEX 40505050606060505050606060505050
O.FREQ6	HEX 81818181818181818181818181818181
 	HEX 81818181818181818181818181818181
	HEX 81818181818181818181818181818181
O.FREQ7	HEX 7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
 	HEX 7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
	HEX 7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
O.FREQ8	HEX 80808080808080808080808080808080
 	HEX 80808080808080808080808080808080
	HEX 80808080808080808080808080808080

; Actual music data
O.SONG1	HEX 00869BA1B0C0DF57244B2657264B2424
 	HEX 2221631F4B211F1D57224B21631F1857
	HEX 244B2657264B24242221631F4B1D1F21
	HEX 57184B1C631D2940000000008F9D2122
	HEX 1F211D1F1C1C8A9AC1401D0000000000
	HEX 00000000000000000000000000000000

O.SONG2	HEX 00869BA1B0C0DF6F2157224B211F571D
 	HEX 1C4B1D1C6F1A631C451315571357214B
	HEX 2157224B21211F1D1D571C4B1A1A1D57
	HEX 134B1663151DA1C182996F0563004B05
	HEX 40056F0563004B054005A3C081964535
	HEX 3435343534353435343230323432302E
	HEX 32302D292D2B242E32353A3734352937
	HEX 343A373935373037343A3C303435292B
	HEX 2D2E303234353739353A343C39373032
	HEX 2D2E2B2D292B28322D2E2B2D32312D2B
	HEX 2E32373632372B2E32302D2B2F302428
	HEX 24282B282B302B303430343734373C3A
	HEX 3735303A3735303A3735303A37353024
	HEX 2D3534353435346F9A35000000000000
	HEX 00000000000000000000000000000000

O.SONG3	HEX 00869BA1B0C0DF4B1D571C6F1D571A63
 	HEX 1857184B1557134B11630C0C571D4B1D
	HEX 571D4B1D1C1A1A63184B15171A57104B
	HEX 106311118297A24B05A1050505A205A1
	HEX 050505A205A1050505A205A1050505A2
	HEX 05A1050505A205A1050505A205A10505
	HEX 05A205A1050505A205A105A0C129A1C0
	HEX 05A205A105A0C129A1C005A205A105A0
	HEX C129A1C005A205A105A0C129A1C005A2
	HEX 0CA10CA0C130A1C00CA20CA10CA0C130
	HEX A1C00CA205A105A0C128A1C005A205A1
	HEX 05A0C128A1C005A202A102A0C126A1C0
	HEX 02A202A102A0C126A1C002A207A107A0
	HEX C12BA1C007A207A107A0C12BA1C007A2
	HEX 0CA10CA0C12EA1C00CA20CA10CA0C12E
	HEX A1C00CA20C0C0C0C0C0C0C0C8A9AA140
	HEX 05000000E00000000000000000000000

; =============
; Sound effects
; =============

; Crash noise
; -----------
SFX1	; Used for splitting up balls
 	LDA	#8
	STA	SID2_FREQ.HIGH
	LDA	#$59
	STA	SID2_AD
 	LDA	#0
	STA	SID2_SR
 	LDA	#0
	STA	SID2_WAVE
 	LDA	#81
 	STA	SID2_WAVE
 	RTS
 
; Chink noise
; -----------
SFX2	; Used for wall bounces
 	LDA	#30
 	STA	SID1_FREQ.HIGH
	LDA	#45
 	STA	SID3_FREQ.HIGH
	LDA	#$06
	STA	SID1_AD
 	LDA	#0
	STA	SID1_SR
 	LDA	#0
	STA	SID1_WAVE
 	LDA	#21
 	STA	SID1_WAVE
 	RTS
 
; Clash noise
; -----------
SFX3	; Used for killing the player
 	LDA	#128
	STA	SID3_FREQ.HIGH
	LDA	#$59
	STA	SID3_AD
 	LDA	#0
	STA	SID3_SR
 	LDA	#0
	STA	SID3_WAVE
 	LDA	#129
	STA	SID3_WAVE
 	RTS
 
CODE.END
